/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note;

import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeWriter;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.ContentSyntax;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

class NoteWriter
implements IExtensionElementWriter,
IAttributeWriter {
    NoteController noteManager;

    public NoteWriter(NoteController noteManager) {
        this.noteManager = noteManager;
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
        if (!NodeWriter.shouldWriteSharedContent(writer)) {
            return;
        }
        this.noteManager.onWrite((MapModel)userObject);
    }

    @Override
    public void writeContent(ITreeWriter writer, Object node, IExtension extension) throws IOException {
        Object transformed;
        String data;
        NoteModel note = (NoteModel)extension;
        XMLElement element = new XMLElement();
        element.setName("richcontent");
        if (extension instanceof NoteModel) {
            element.setAttribute("TYPE", "NOTE");
        } else {
            element.setAttribute("TYPE", "UNKNOWN");
        }
        String transformedXhtml = "";
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting && (data = note.getText()) != null && !(transformed = TextController.getController().getTransformedObjectNoFormattingNoThrow((NodeModel)node, note, data)).equals(data)) {
            String transformedHtml = HtmlUtils.objectToHtml(transformed);
            transformedXhtml = HtmlUtils.toXhtml(transformedHtml);
        }
        boolean containsXml = transformedXhtml.isEmpty() && note.getXml() != null;
        String contentType = note.getContentType();
        ContentSyntax contentSyntax = containsXml ? ContentSyntax.XML : ContentSyntax.PLAIN;
        element.setAttribute("CONTENT-TYPE", contentSyntax.with(contentType));
        if (containsXml) {
            String content = note.getXml().replace('\u0000', ' ');
            writer.addElement((Object)content, element);
        } else {
            String text = note.getText();
            if (text != null) {
                XMLElement textElement = element.createElement("text");
                textElement.setContent(text);
                element.addChild(textElement);
            }
            writer.addElement((Object)transformedXhtml, element);
        }
    }
}

