/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.LinkedHashSet;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.GotoLinkNodeAction;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

class LinkMenuBuilder
implements EntryVisitor {
    private final ModeController modeController;
    private final LinkController linkController;

    LinkMenuBuilder(ModeController modeController, LinkController linkController) {
        this.modeController = modeController;
        this.linkController = linkController;
    }

    @Override
    public void visit(Entry entry) {
        Controller controller = this.modeController.getController();
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return;
        }
        NodeModel node = selection.getSelected();
        Configurable mapViewComponent = controller.getMapViewManager().getMapViewConfiguration();
        LinkedHashSet<? extends NodeLinkModel> links = new LinkedHashSet<NodeLinkModel>(this.linkController.getLinksFrom(node, mapViewComponent));
        links.addAll(this.linkController.getLinksTo(node, mapViewComponent));
        boolean firstAction = true;
        for (NodeLinkModel nodeLinkModel : links) {
            NodeModel target;
            String targetID = nodeLinkModel.getTargetID();
            if (node.getID().equals(targetID)) {
                ConnectorModel cm;
                if (!(nodeLinkModel instanceof ConnectorModel) || node.equals(target = (cm = (ConnectorModel)nodeLinkModel).getSource())) {
                    continue;
                }
            } else {
                target = node.getMap().getNodeForID(targetID);
            }
            GotoLinkNodeAction gotoLinkNodeAction = new GotoLinkNodeAction(this.linkController, target);
            gotoLinkNodeAction.configureText("follow_graphical_link", target);
            if (!(nodeLinkModel instanceof ConnectorModel)) {
                gotoLinkNodeAction.putValue("SmallIcon", LinkController.LinkType.LOCAL.icon);
            }
            if (firstAction) {
                entry.addChild(new Entry().setBuilders("separator"));
                firstAction = false;
            }
            this.modeController.addActionIfNotAlreadySet(gotoLinkNodeAction);
            new EntryAccessor().addChildAction(entry, gotoLinkNodeAction);
        }
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return true;
    }
}

