/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.Set;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class ConnectorCondition
extends StringConditionAdapter {
    static final String TEXT = "TEXT";
    private final String text;
    private final StringMatchingStrategy stringMatchingStrategy;

    protected StringMatchingStrategy getStringMatchingStrategy() {
        return this.stringMatchingStrategy;
    }

    public ConnectorCondition(String text, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, ignoreDiacritics);
        this.text = text;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    public String getText() {
        return this.text;
    }

    protected abstract boolean checkLink(ConnectorModel var1);

    @Override
    public boolean checkNode(NodeModel node) {
        NodeLinks nodeLinks = NodeLinks.getLinkExtension(node);
        if (nodeLinks != null) {
            for (NodeLinkModel l : nodeLinks.getLinks()) {
                if (!(l instanceof ConnectorModel) || !this.checkLink((ConnectorModel)l)) continue;
                return true;
            }
        }
        if (!node.hasID()) {
            return false;
        }
        MapLinks mapLinks = MapLinks.getLinks(node.getMap());
        if (mapLinks == null) {
            return false;
        }
        Set<NodeLinkModel> targetLinks = mapLinks.get(node.getID());
        if (targetLinks == null) {
            return false;
        }
        for (NodeLinkModel l : targetLinks) {
            if (!(l instanceof ConnectorModel) || !this.checkLink((ConnectorModel)l)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(TEXT, this.text);
    }

    @Override
    protected Object conditionValue() {
        return this.text;
    }
}

