/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.FoundNodes;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class FindAction
extends AFreeplaneAction {
    static final String KEY = "FindAction";
    private static final long serialVersionUID = 1L;
    private FilterConditionEditor editor;
    private final FindNextAction findNextAction = new FindNextAction();
    private final AFreeplaneAction findPreviousAction = new FindPreviousAction();
    private NodeModel searchStart;
    private NodeModel subtreeRoot;

    public FindAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent editorPanel;
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return;
        }
        NodeModel start = selection.getSelected();
        if (this.editor == null) {
            this.editor = new FilterConditionEditor(FilterController.getCurrentFilterController(), 5, FilterConditionEditor.Variant.SEARCH_DIALOG, new FreeplaneToolBar(0));
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
            editorPanel = this.editor.getPanel();
            AbstractButton applyFindPreviousBtn = FreeplaneToolBar.createButton(this.findPreviousAction);
            AbstractButton applyFindNextBtn = FreeplaneToolBar.createButton(this.findNextAction);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.gridy = 0;
            editorPanel.add((Component)applyFindPreviousBtn, constraints);
            editorPanel.add((Component)applyFindNextBtn, constraints);
        } else {
            this.editor.filterChanged(selection.getFilter());
        }
        editorPanel = this.editor.getPanel();
        editorPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JComponent component = event.getComponent();
                final Window windowAncestor = SwingUtilities.getWindowAncestor(component);
                if (windowAncestor.isFocused()) {
                    FindAction.this.editor.focusInputField(true);
                } else {
                    windowAncestor.addWindowFocusListener(new WindowFocusListener(){

                        @Override
                        public void windowLostFocus(WindowEvent e) {
                        }

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                            windowAncestor.removeWindowFocusListener(this);
                            FindAction.this.editor.focusInputField(true);
                        }
                    });
                    windowAncestor.toFront();
                }
                editorPanel.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.searchStart = selection.getSelected();
        this.subtreeRoot = selection.getSelectionRoot();
        UITools.showConfirmDialog(start, editorPanel, TextUtils.getText("FindAction.text"), -1, -1);
        this.subtreeRoot = null;
        this.searchStart = null;
        Container parent = editorPanel.getParent();
        if (parent != null) {
            parent.remove(editorPanel);
        }
    }

    void findNext(MapController.Direction direction) {
        Controller controller = Controller.getCurrentController();
        FilterController filterController = FilterController.getCurrentFilterController();
        NodeModel start = controller.getSelection().getSelected();
        Filter filter = controller.getSelection().getFilter();
        ASelectableCondition condition = this.editor.getCondition();
        if (condition == null) {
            return;
        }
        NodeModel next = filterController.findNextInSubtree(start, this.subtreeRoot, direction, condition, filter);
        if (next == null) {
            this.displayNotFoundMessage(this.searchStart, condition);
            return;
        }
        MapModel map = controller.getMap();
        FoundNodes info = FoundNodes.get(map);
        info.displayFoundNode(next);
    }

    private void displayNotFoundMessage(NodeModel start, ICondition condition) {
        String message = TextUtils.format("no_more_found_from", condition.toString(), this.getFindFromText(start));
        UITools.informationMessage(Controller.getCurrentController().getViewController().getCurrentRootComponent(), message);
    }

    public String getFindFromText(NodeModel node) {
        String plainNodeText = node.toString().replaceAll("\n", " ");
        return plainNodeText.length() <= 30 ? plainNodeText : plainNodeText.substring(0, 30) + "...";
    }

    public AFreeplaneAction getFindNextAction() {
        return this.findNextAction;
    }

    public AFreeplaneAction getFindPreviousAction() {
        return this.findPreviousAction;
    }

    private class FindNextAction
    extends AFreeplaneAction {
        FindNextAction() {
            super("FindNextAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAction.this.findNext(MapController.Direction.FORWARD);
        }
    }

    private class FindPreviousAction
    extends AFreeplaneAction {
        FindPreviousAction() {
            super("FindPreviousAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAction.this.findNext(MapController.Direction.BACK);
        }
    }
}

