/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.LinkedList;
import java.util.ListIterator;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;

public class FilterHistory {
    private ListIterator<Filter> filters;

    FilterHistory() {
        this.init();
    }

    void add(Filter filter) {
        Filter currentFilter = this.getCurrentFilter();
        if (filter.canUseFilterResultsFrom(currentFilter)) {
            this.filters.previous();
            this.filters.remove();
        }
        while (this.filters.hasNext()) {
            this.filters.next();
            this.filters.remove();
        }
        this.filters.add(filter);
    }

    void clear() {
        this.init();
    }

    Filter getCurrentFilter() {
        this.filters.previous();
        return this.filters.next();
    }

    private void init() {
        LinkedList list = new LinkedList();
        this.filters = list.listIterator();
        this.filters.add(Filter.createTransparentFilter());
    }

    void redo() {
        if (!this.filters.hasNext()) {
            return;
        }
        Filter next = this.filters.next();
        FilterController.getCurrentFilterController().applyFilter(true, next);
    }

    void undo() {
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        Filter previous = this.filters.previous();
        this.undoImpl(selection);
        while (previous != this.filters.next()) {
        }
        if (this.filters.nextIndex() > 1) {
            this.filters.previous();
        }
    }

    private void undoImpl(IMapSelection selection) {
        if (!this.filters.hasPrevious()) {
            return;
        }
        Filter previous = this.filters.previous();
        if (previous.appliesToVisibleNodesOnly()) {
            this.undoImpl(selection);
        }
        FilterController.getCurrentFilterController().applyFilter(true, previous);
    }
}

