/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.encrypt.EnterPassword;
import org.freeplane.features.encrypt.PasswordStrategy;
import org.freeplane.features.encrypt.SingleDesEncrypter;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class EncryptionController
implements IExtension {
    private static final IconStore STORE = IconStoreFactory.ICON_STORE;
    private static UIIcon decryptedIcon = STORE.getUIIcon("unlock.svg");
    private static UIIcon encryptedIcon = STORE.getUIIcon("lock.svg");

    public static void install(EncryptionController encryptionController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(EncryptionController.class, encryptionController);
        EnterPassword pwdAction = new EnterPassword(encryptionController);
        modeController.addAction(pwdAction);
    }

    public EncryptionController(ModeController modeController) {
        this.registerStateIconProvider(modeController);
    }

    private void registerStateIconProvider(ModeController modeController) {
        IconController.getController(modeController).addStateIconProvider(new IStateIconProvider(){

            @Override
            public UIIcon getStateIcon(NodeModel node) {
                EncryptionModel encryptionModel = EncryptionModel.getModel(node);
                if (encryptionModel != null) {
                    if (encryptionModel.isAccessible()) {
                        return decryptedIcon;
                    }
                    return encryptedIcon;
                }
                return null;
            }

            @Override
            public boolean mustIncludeInIconRegistry() {
                return true;
            }
        });
    }

    public void toggleLock(final NodeModel node, PasswordStrategy passwordStrategy) {
        final EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        if (encryptionModel != null) {
            final boolean wasFolded = node.isFolded();
            final boolean wasAccessible = encryptionModel.isAccessible();
            if (!wasAccessible && !this.doPasswordCheckAndDecryptNode(node, encryptionModel, passwordStrategy)) {
                return;
            }
            boolean becomesFolded = true;
            final boolean becomesAccessible = !wasAccessible;
            Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(node);
            final MapWriter mapWriter = Controller.getCurrentModeController().getMapController().getMapWriter();
            IActor actor = new IActor(){

                @Override
                public boolean isReadonly() {
                    return true;
                }

                @Override
                public void act() {
                    this.apply(becomesAccessible, true, wasFolded);
                }

                private void apply(boolean becomesAccessible2, boolean becomesFolded, boolean wasFolded2) {
                    boolean encryptionSucceeded;
                    if (encryptionModel.isAccessible() == becomesAccessible2) {
                        return;
                    }
                    if (becomesAccessible2) {
                        encryptionModel.unlock();
                    } else {
                        encryptionModel.lock(mapWriter);
                    }
                    boolean bl = encryptionSucceeded = encryptionModel.isAccessible() == becomesAccessible2;
                    if (encryptionSucceeded) {
                        if (becomesFolded != wasFolded2) {
                            node.setFolded(becomesFolded);
                        }
                        EncryptionController.this.fireEncryptionChangedEvent(node);
                    }
                }

                @Override
                public String getDescription() {
                    return "toggleCryptState";
                }

                @Override
                public void undo() {
                    this.apply(wasAccessible, wasFolded, true);
                }
            };
            Controller.getCurrentModeController().execute(actor, node.getMap());
        } else {
            this.encrypt(node, passwordStrategy);
        }
    }

    private boolean doPasswordCheckAndDecryptNode(NodeModel node, EncryptionModel encryptionModel, PasswordStrategy passwordStrategy) {
        StringBuilder password = passwordStrategy.getPassword(node);
        if (passwordStrategy.isCancelled()) {
            return false;
        }
        if (!this.decrypt(encryptionModel, password)) {
            passwordStrategy.onWrongPassword();
            return false;
        }
        return true;
    }

    private boolean decrypt(EncryptionModel encryptionModel, StringBuilder password) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        return encryptionModel.decrypt(mapController, new SingleDesEncrypter(password));
    }

    private void encrypt(final NodeModel node, PasswordStrategy passwordStrategy) {
        if (node.allClones().size() > 1) {
            UITools.errorMessage(TextUtils.getText("can_not_encrypt_cloned_node"));
            return;
        }
        StringBuilder password = passwordStrategy.getPasswordWithConfirmation(node);
        if (passwordStrategy.isCancelled()) {
            return;
        }
        final EncryptionModel encryptionModel = new EncryptionModel(node, new SingleDesEncrypter(password));
        IActor actor = new IActor(){

            @Override
            public void act() {
                node.addExtension(encryptionModel);
                this.fireEncryptionChangedEvent();
            }

            @Override
            public String getDescription() {
                return "encrypt";
            }

            @Override
            public void undo() {
                node.removeExtension(encryptionModel);
                this.fireEncryptionChangedEvent();
            }

            private void fireEncryptionChangedEvent() {
                Controller.getCurrentModeController().getMapController().setSaved(node.getMap(), false);
                EncryptionController.this.fireEncryptionChangedEvent(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private void fireEncryptionChangedEvent(NodeModel node) {
        Controller.getCurrentModeController().getMapController().nodeRefresh(node, EncryptionModel.class, null, null);
    }
}

