/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URI;
import javax.swing.SwingUtilities;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeBuilder;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeSelection;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.clipboard.AttributeClipboardController;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.SetBooleanMapPropertyAction;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.NodeView;

public class AttributeController
implements IExtension {
    public static final String SHOW_ICON_FOR_ATTRIBUTES = "show_icon_for_attributes";
    private static final Integer ATTRIBUTE_TOOLTIP = 7;
    private static UIIcon attributeIcon = null;
    private static AttributeSelection attributeSelection = AttributeSelection.EMPTY;
    private final ModeController modeController;

    public static void setAttributeSelection(AttributeSelection attributeSelection) {
        if (AttributeController.attributeSelection != AttributeSelection.EMPTY) {
            throw new IllegalStateException();
        }
        AttributeController.attributeSelection = attributeSelection;
    }

    public static AttributeController getController() {
        return AttributeController.getController(Controller.getCurrentModeController());
    }

    public static AttributeController getController(ModeController modeController) {
        return modeController.getExtension(AttributeController.class);
    }

    public static void install(AttributeController attributeController) {
        Controller.getCurrentModeController().addExtension(AttributeController.class, attributeController);
    }

    public AttributeController(ModeController modeController) {
        this.modeController = modeController;
        MapController mapController = Controller.getCurrentModeController().getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        MapReader mapReader = mapController.getMapReader();
        AttributeBuilder attributeBuilder = new AttributeBuilder(this, mapReader);
        attributeBuilder.registerBy(readManager, writeManager);
        modeController.addAction(new SetBooleanMapPropertyAction(SHOW_ICON_FOR_ATTRIBUTES));
        this.registerTooltipProvider();
        this.registerStateIconProvider();
        this.registerAttributeClipboardController(modeController);
    }

    protected void registerAttributeClipboardController(ModeController modeController) {
        modeController.getExtension(ClipboardControllers.class).add(new AttributeClipboardController());
    }

    public NodeAttributeTableModel createAttributeTableModel(NodeModel node) {
        NodeAttributeTableModel attributeModel = node.getExtension(NodeAttributeTableModel.class);
        if (attributeModel != null) {
            return attributeModel;
        }
        attributeModel = new NodeAttributeTableModel();
        node.addExtension(attributeModel);
        if (node.areViewsEmpty()) {
            return attributeModel;
        }
        this.modeController.getMapController().nodeRefresh(node);
        return attributeModel;
    }

    public void performInsertRow(NodeModel node, NodeAttributeTableModel model, int row, String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void performRegistryAttribute(MapModel map, String name) {
        throw new UnsupportedOperationException();
    }

    public void performRegistryAttributeValue(MapModel map, String name, String value, boolean manual) {
        throw new UnsupportedOperationException();
    }

    public void performRegistrySubtreeAttributes(NodeModel model) {
        throw new UnsupportedOperationException();
    }

    public void performRemoveAttribute(MapModel map, String name) {
        throw new UnsupportedOperationException();
    }

    public void performRemoveAttributeValue(MapModel map, String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public Attribute performRemoveRow(NodeModel node, NodeAttributeTableModel model, int row) {
        throw new UnsupportedOperationException();
    }

    public void performReplaceAtributeName(MapModel map, String oldName, String newName) {
        throw new UnsupportedOperationException();
    }

    public void performReplaceAttributeValue(MapModel map, String name, Object oldO, Object newO) {
        throw new UnsupportedOperationException();
    }

    public void performSetColumnWidth(NodeModel node, NodeAttributeTableModel model, int col, Quantity<LengthUnit> width) {
        throw new UnsupportedOperationException();
    }

    public void performSetRestriction(MapModel map, int row, boolean restricted) {
        throw new UnsupportedOperationException();
    }

    public void performSetValueAt(NodeModel node, NodeAttributeTableModel model, Object o, int row, int col) {
        throw new UnsupportedOperationException();
    }

    public void performSetVisibility(MapModel map, int index, boolean isVisible) {
        throw new UnsupportedOperationException();
    }

    private void registerTooltipProvider() {
        this.modeController.addToolTipProvider(ATTRIBUTE_TOOLTIP, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                Color textColor;
                NodeView nodeView;
                NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
                int rowCount = attributes.getRowCount();
                if (rowCount == 0) {
                    return null;
                }
                AttributeRegistry registry = AttributeRegistry.getRegistry(node.getMap());
                TextController textController = TextController.getController(modeController);
                if (registry.getAttributeViewType().equals("extended") && !textController.isMinimized(node)) {
                    return null;
                }
                NodeStyleController style = modeController.getExtension(NodeStyleController.class);
                MapStyleModel model = MapStyleModel.getExtension(node.getMap());
                NodeModel attributeStyleNode = model.getStyleNodeSafe(MapStyleModel.ATTRIBUTE_STYLE);
                Font font = style.getFont(attributeStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                StringBuilder tooltip = new StringBuilder();
                Color backgroundColor = style.getBackgroundColor(attributeStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                if (backgroundColor == null && (nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, view)) != null) {
                    backgroundColor = nodeView.getBackgroundColor();
                }
                if (backgroundColor != null) {
                    textColor = style.getColor(attributeStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                } else {
                    backgroundColor = Color.WHITE;
                    textColor = Color.BLACK;
                }
                tooltip.append("<html><body><table style=\"");
                tooltip.append(new CssRuleBuilder().withHTMLFont(font).withBackground(backgroundColor).withColor(textColor));
                tooltip.append(" \" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" ");
                int currentRowCount = attributes.getRowCount();
                for (int i = 0; i < currentRowCount; ++i) {
                    tooltip.append("<tr><td>");
                    tooltip.append(attributes.getValueAt(i, 0));
                    tooltip.append("</td><td>");
                    Object object = attributes.getValueAt(i, 1);
                    String text = this.getTransformedValue(node, attributes, textController, object);
                    if (object instanceof Hyperlink || object instanceof URI) {
                        tooltip.append("<a");
                        tooltip.append(" href=\"");
                        tooltip.append(object);
                        tooltip.append("\"");
                        tooltip.append(">");
                        tooltip.append(text);
                        tooltip.append("</a>");
                    } else {
                        tooltip.append(text);
                    }
                    tooltip.append("</td></tr>");
                }
                tooltip.append("</table></body></html>");
                return tooltip.toString();
            }

            private String getTransformedValue(NodeModel node, NodeAttributeTableModel attributes, TextController textController, Object value) {
                try {
                    String text = textController.getTransformedText(node, attributes, value);
                    boolean markTransformedText = TextController.isMarkTransformedTextSet();
                    String unicodeText = HtmlUtils.unicodeToHTMLUnicodeEntity(text);
                    if (markTransformedText && text != value) {
                        return this.colorize(unicodeText, "green");
                    }
                    return unicodeText;
                }
                catch (Throwable e) {
                    LogUtils.warn(e.getMessage());
                    return this.colorize(TextUtils.format("MainView.errorUpdateText", String.valueOf(value), e.getLocalizedMessage()).replace("\n", "<br>"), "red");
                }
            }

            private String colorize(String text, String color) {
                return "<span style=\"color:" + color + ";font-style:italic;\">" + text + "</span>";
            }
        });
    }

    private void registerStateIconProvider() {
        IconController.getController().addStateIconProvider(new IStateIconProvider(){

            @Override
            public UIIcon getStateIcon(NodeModel node) {
                NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
                if (attributes.getRowCount() == 0) {
                    return null;
                }
                String showAttributeIcon = MapStyle.getController(AttributeController.this.modeController).getPropertySetDefault(node.getMap(), AttributeController.SHOW_ICON_FOR_ATTRIBUTES);
                boolean showIcon = Boolean.parseBoolean(showAttributeIcon);
                if (showIcon) {
                    if (attributeIcon == null) {
                        attributeIcon = IconStoreFactory.ICON_STORE.getUIIcon("showAttributes.svg");
                    }
                    return attributeIcon;
                }
                return null;
            }

            @Override
            public boolean mustIncludeInIconRegistry() {
                return true;
            }
        });
    }

    public boolean canEdit() {
        return false;
    }

    public static AttributeSelection getAttributeSelection() {
        return attributeSelection;
    }
}

