/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionEnabler;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.ToolbarComponentProvider;

public class JToolbarComponentBuilder
implements EntryVisitor {
    private final ComponentProvider componentProvider;

    public JToolbarComponentBuilder(ComponentProvider componentProvider) {
        this.componentProvider = componentProvider;
    }

    public JToolbarComponentBuilder(ResourceAccessor resourceAccessor) {
        this(new ToolbarComponentProvider(resourceAccessor));
    }

    @Override
    public void visit(Entry entry) {
        Component component = this.componentProvider.createComponent(entry);
        if (component != null) {
            EntryAccessor entryAccessor = new EntryAccessor();
            entryAccessor.setComponent(entry, component);
            AFreeplaneAction action = entryAccessor.getAction(entry);
            if (action != null) {
                ActionEnabler actionEnabler = new ActionEnabler(component);
                action.addPropertyChangeListener(actionEnabler);
                entry.setAttribute(actionEnabler.getClass(), (Object)actionEnabler);
            }
            JToolBar container = (JToolBar)new EntryAccessor().getAncestorComponent(entry);
            String rowSpec = (String)entry.getAttribute("row");
            if (rowSpec == null) {
                rowSpec = (String)entry.getParent().getAttribute("row");
            }
            int row = "2".equals(rowSpec) ? 1 : 0;
            String widthSpec = (String)entry.getAttribute("width");
            int gridWidth = widthSpec != null ? Integer.valueOf(widthSpec) : 1;
            int gridHeight = rowSpec == null || component instanceof JSeparator ? 2 : 1;
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = row;
            constraints.gridwidth = gridWidth;
            constraints.gridheight = gridHeight;
            String weightSpec = (String)entry.getAttribute("weight");
            constraints.weightx = weightSpec != null ? (double)Integer.parseInt(weightSpec) : 0.0;
            constraints.fill = gridHeight == 1 ? 2 : 1;
            constraints.anchor = entry.builders().contains("dropdownMenu") ? 15 : 12;
            container.add(component, constraints);
        }
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        EntryAccessor entryAccessor = new EntryAccessor();
        return entryAccessor.getAction(entry) != null || entry.builders().contains("dropdownMenu");
    }
}

