/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Color;
import java.awt.Font;
import org.freeplane.api.Quantity;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.nodestyle.FontUtils;

public class CssRuleBuilder {
    private StringBuilder rule = new StringBuilder();

    public String buildRule() {
        return this.rule.toString();
    }

    public CssRuleBuilder withHTMLFont(Font font) {
        return this.withHTMLFont(font, 1.0f);
    }

    public CssRuleBuilder withCSSFont(Font font) {
        return this.withCSSFont(font, 1.0f);
    }

    public CssRuleBuilder withHTMLFont(Font font, float fontScaleFactor) {
        if (font != null) {
            this.withFontFamily(font.getFamily(), "&quot;");
            this.withFontConfiguration(font, fontScaleFactor);
        }
        return this;
    }

    public CssRuleBuilder withCSSFont(Font font, float fontScaleFactor) {
        if (font != null) {
            this.withFontFamily(font.getFamily(), "\"");
            this.withFontConfiguration(font, fontScaleFactor);
        }
        return this;
    }

    private void withFontConfiguration(Font font, float fontScaleFactor) {
        this.rule.append(" font-size: ");
        int fontSize = Math.round((float)font.getSize() / fontScaleFactor);
        this.rule.append(fontSize);
        this.rule.append("pt;");
        if (font.isBold()) {
            this.rule.append(" font-weight: bold;");
        }
        if (font.isItalic()) {
            this.rule.append(" font-style: italic;");
        }
        if (FontUtils.isStrikedThrough(font)) {
            this.rule.append(" text-decoration: line-through;");
        }
    }

    private void withFontFamily(String family, String quote) {
        this.rule.append(" font-family: ").append(quote).append(family).append(quote).append("; ");
    }

    public CssRuleBuilder withColor(Color color) {
        if (color != null) {
            this.rule.append("color: ").append(ColorUtils.colorToString(color)).append(";");
        }
        return this;
    }

    public CssRuleBuilder withBackground(Color color) {
        if (color != null) {
            this.rule.append("background-color: ").append(ColorUtils.colorToString(color)).append(";");
        }
        return this;
    }

    public CssRuleBuilder withAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                this.rule.append("text-align: center;");
                break;
            }
            case 2: {
                this.rule.append("text-align: left;");
                break;
            }
            case 4: {
                this.rule.append("text-align: right;");
                break;
            }
        }
        return this;
    }

    public String toString() {
        return this.rule.toString();
    }

    public CssRuleBuilder withMaxWidthAsPt(float zoom, Quantity<?> ... widths) {
        int maxBaseUnits = -1;
        for (Quantity<?> width : widths) {
            if (width == null) continue;
            int zoomedBaseUnits = (int)((double)zoom * width.toBaseUnits() + 0.5);
            maxBaseUnits = Math.max(maxBaseUnits, zoomedBaseUnits);
        }
        if (maxBaseUnits >= 0) {
            this.rule.append("width: ").append(maxBaseUnits).append("pt").append(";");
        }
        return this;
    }
}

