/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;

public class MultipleImage
implements Icon {
    private final List<Icon> mIcons = new ArrayList<Icon>();
    private final List<NamedIcon> mUIIcons = new ArrayList<NamedIcon>();

    public void addIcon(NamedIcon uiIcon) {
        Icon icon = uiIcon.getIcon();
        Objects.requireNonNull(icon);
        this.mIcons.add(icon);
        this.mUIIcons.add(uiIcon);
    }

    public void addIcon(NamedIcon uiIcon, Quantity<LengthUnit> iconHeight) {
        Icon icon = uiIcon.getIcon(iconHeight);
        Objects.requireNonNull(icon);
        this.mIcons.add(icon);
        this.mUIIcons.add(uiIcon);
    }

    public void addLinkIcon(Icon icon, NodeModel node, LogicalStyleController.StyleOption option) {
        Objects.requireNonNull(icon);
        Quantity<LengthUnit> iconHeight = IconController.getController().getIconSize(node, option);
        IconFactory iconFactory = IconFactory.getInstance();
        Icon scaledIcon = iconFactory.canScaleIcon(icon) ? iconFactory.getScaledIcon(icon, iconHeight) : icon;
        this.mIcons.add(scaledIcon);
        this.mUIIcons.add(null);
    }

    @Override
    public int getIconHeight() {
        int myY = 0;
        for (Icon icon : this.mIcons) {
            int otherHeight = icon.getIconHeight();
            if (otherHeight <= myY) continue;
            myY = otherHeight;
        }
        return myY;
    }

    @Override
    public int getIconWidth() {
        int myX = 0;
        for (Icon icon : this.mIcons) {
            myX += icon.getIconWidth();
        }
        return myX;
    }

    public int getImageCount() {
        return this.mIcons.size();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int myX = x;
        for (Icon icon : this.mIcons) {
            icon.paintIcon(c, g, myX, y);
            myX += icon.getIconWidth();
        }
    }

    public NamedIcon getUIIconAt(Point coordinate) {
        if (coordinate.x < 0 || coordinate.y < 0) {
            return null;
        }
        int iconX = 0;
        for (int iconIndex = 0; iconIndex < this.mIcons.size(); ++iconIndex) {
            if (coordinate.x > (iconX += this.mIcons.get(iconIndex).getIconWidth())) continue;
            return this.mUIIcons.get(iconIndex);
        }
        return null;
    }

    public Rectangle getIconR(Icon icon) {
        int myX = 0;
        for (Icon ico : this.mIcons) {
            if (ico.equals(icon)) {
                return new Rectangle(myX, 0, ico.getIconWidth(), ico.getIconHeight());
            }
            myX += ico.getIconWidth();
        }
        return null;
    }
}

