/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.components.KeyEventTranslator;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IAcceleratorChangeListener;
import org.freeplane.core.ui.IKeyStrokeProcessor;
import org.freeplane.core.ui.SetAcceleratorOnNextClickAction;
import org.freeplane.core.ui.components.SetFKeyAcceleratorOnNextClickAction;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class FButtonBar
extends JComponent
implements IAcceleratorChangeListener,
KeyEventDispatcher,
WindowFocusListener,
IKeyStrokeProcessor {
    private static final int BUTTON_NUMBER = 12;
    private static final long serialVersionUID = 1L;
    private final Map<Integer, JButton[]> buttons;
    private int lastModifiers = -1;
    private int nextModifiers = 0;
    private JFrame ownWindowAncestor;
    private final Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FButtonBar.this.onModifierChangeImpl();
        }
    });
    private boolean altPressedEventHidden = false;

    public FButtonBar(JRootPane rootPane) {
        this.timer.setRepeats(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.buttons = new HashMap<Integer, JButton[]>();
        this.onModifierChange();
    }

    @Override
    public void acceleratorChanged(AFreeplaneAction action, KeyStroke oldStroke, KeyStroke newStroke) {
        JButton button;
        JButton[] buttonRow;
        int modifiers;
        int newButtonNumber;
        int oldButtonNumber = oldStroke != null ? oldStroke.getKeyCode() - 112 : -1;
        int n = newButtonNumber = newStroke != null ? newStroke.getKeyCode() - 112 : -1;
        if (oldButtonNumber >= 0 && oldButtonNumber < 12) {
            modifiers = oldStroke.getModifiers() & 0x2F;
            buttonRow = this.buttons.get(modifiers);
            button = buttonRow[oldButtonNumber];
            this.setAcceleratorAction(button, oldStroke);
        }
        if (newButtonNumber >= 0 && newButtonNumber < 12) {
            modifiers = newStroke.getModifiers() & 0x2F;
            buttonRow = this.createButtons(modifiers);
            button = buttonRow[newButtonNumber];
            String text = (String)action.getValue("Name");
            button.setText(text);
            button.setToolTipText(text);
            button.setAction(action);
            button.setEnabled(action.isEnabled());
        }
    }

    private void setAcceleratorAction(JButton button, KeyStroke ks) {
        SetFKeyAcceleratorOnNextClickAction setAcceleratorAction = new SetFKeyAcceleratorOnNextClickAction(ks);
        button.setAction(setAcceleratorAction);
        button.setEnabled(setAcceleratorAction.isEnabled());
        String text = TextUtils.getText("f_button_unassigned");
        button.setText(text);
    }

    private void cleanModifiers(int modifiers) {
        if ((this.nextModifiers & modifiers) == 0) {
            return;
        }
        this.nextModifiers &= ~modifiers;
        this.onModifierChange();
    }

    private JButton[] createButtonRow(int modifiers) {
        JButton[] buttons = new JButton[12];
        for (int i = 0; i < 12; ++i) {
            String name = "f" + (i + 1) + ".svg";
            JButton button = buttons[i] = new JButton((Icon)FreeplaneIconFactory.toImageIcon(IconStoreFactory.ICON_STORE.getUIIcon(name).getIcon())){
                private static final long serialVersionUID = 1L;

                @Override
                protected void configurePropertiesFromAction(Action a) {
                }
            };
            button.setFocusable(false);
            KeyStroke ks = KeyStroke.getKeyStroke(112 + i, modifiers);
            this.setAcceleratorAction(button, ks);
        }
        return buttons;
    }

    private JButton[] createButtons(int modifiers) {
        JButton[] buttonRow = this.buttons.get(modifiers);
        if (buttonRow == null) {
            buttonRow = this.createButtonRow(modifiers);
            this.buttons.put(modifiers, buttonRow);
        }
        return buttonRow;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        Window windowAncestor;
        if (!(Controller.getCurrentModeController() instanceof MModeController)) {
            return false;
        }
        if (this.ownWindowAncestor == null) {
            this.ownWindowAncestor = (JFrame)SwingUtilities.getWindowAncestor(this);
            if (this.ownWindowAncestor == null) {
                return false;
            }
            this.ownWindowAncestor.addWindowFocusListener(this);
        }
        if ((windowAncestor = SwingUtilities.getWindowAncestor(e.getComponent())) == this.ownWindowAncestor && this.ownWindowAncestor.getJMenuBar() != null && this.ownWindowAncestor.getJMenuBar().isEnabled()) {
            this.processDispatchedKeyEvent(e);
        } else {
            this.resetModifiers();
        }
        if (e.getKeyCode() == 18) {
            switch (e.getID()) {
                case 401: {
                    Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    this.altPressedEventHidden = !(focusOwner instanceof JRootPane) && 0 != (e.getModifiersEx() & 0xFFFFFDF7);
                    return this.altPressedEventHidden;
                }
                case 402: {
                    if (!this.altPressedEventHidden) break;
                    this.altPressedEventHidden = false;
                    return true;
                }
            }
        }
        return false;
    }

    private void onModifierChange() {
        if (this.lastModifiers == this.nextModifiers) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if (this.nextModifiers == 0) {
            this.onModifierChangeImpl();
        } else {
            this.timer.start();
        }
    }

    private void onModifierChangeImpl() {
        JButton[] buttonRow;
        if (this.lastModifiers == this.nextModifiers) {
            return;
        }
        this.lastModifiers = this.nextModifiers;
        this.removeAll();
        for (JButton button : buttonRow = this.createButtons(this.nextModifiers)) {
            this.add(button);
        }
        this.revalidate();
        this.repaint();
    }

    private void processDispatchedKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        block0 : switch (e.getID()) {
            case 401: {
                switch (keyCode) {
                    case 17: {
                        this.setModifiers(2);
                        break;
                    }
                    case 157: {
                        this.setModifiers(4);
                        break;
                    }
                    case 16: {
                        this.setModifiers(1);
                        break;
                    }
                    case 18: {
                        this.setModifiers(8);
                        break;
                    }
                    case 65406: {
                        this.setModifiers(32);
                    }
                }
                break;
            }
            case 402: {
                switch (keyCode) {
                    case 17: {
                        this.cleanModifiers(2);
                        break block0;
                    }
                    case 157: {
                        this.cleanModifiers(4);
                        break block0;
                    }
                    case 16: {
                        this.cleanModifiers(1);
                        break block0;
                    }
                    case 18: {
                        this.cleanModifiers(8);
                        break block0;
                    }
                    case 65406: {
                        this.cleanModifiers(32);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent e) {
        return this.processFKey(e);
    }

    private boolean processFKey(KeyEvent e) {
        if (e.getID() != 401) {
            return false;
        }
        Window windowAncestor = SwingUtilities.getWindowAncestor(e.getComponent());
        if (windowAncestor != this.ownWindowAncestor) {
            this.resetModifiers();
            return false;
        }
        int keyCode = e.getKeyCode();
        if (keyCode >= 112 && keyCode <= 123) {
            JButton btn = this.createButtons(this.nextModifiers)[keyCode - 112];
            if (btn.getAction() instanceof SetAcceleratorOnNextClickAction && e.getComponent() instanceof JTextComponent) {
                return false;
            }
            if (this.timer.isRunning()) {
                this.timer.stop();
                this.onModifierChangeImpl();
            }
            btn.doClick();
            return true;
        }
        return false;
    }

    private void resetModifiers() {
        if (this.nextModifiers == 0) {
            return;
        }
        this.nextModifiers = 0;
        this.onModifierChange();
    }

    private void setModifiers(int modifiers) {
        if ((modifiers & ~this.nextModifiers) == 0) {
            return;
        }
        this.nextModifiers |= modifiers;
        this.nextModifiers = KeyEventTranslator.getCompatibleModifiers(this.nextModifiers);
        this.onModifierChange();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.resetModifiers();
    }

    @Override
    public void layout() {
        int w = this.getParent().getWidth();
        int border = 5;
        int h = this.getComponent((int)1).getPreferredSize().height;
        int componentCount = this.getComponentCount();
        float availableWidth = (float)(w - 10) + 0.0f;
        float dw = availableWidth / (float)componentCount;
        int preferredWidth = 0;
        int narrowComponentPreferredWidth = 0;
        for (int i = 0; i < componentCount; ++i) {
            int cw = this.getComponent((int)i).getPreferredSize().width;
            preferredWidth += cw;
            if (!((float)cw <= dw)) continue;
            narrowComponentPreferredWidth += cw;
        }
        float k = availableWidth < (float)preferredWidth ? (availableWidth - (float)narrowComponentPreferredWidth) / (float)(preferredWidth - narrowComponentPreferredWidth) : availableWidth / (float)preferredWidth;
        float x = 5.0f;
        for (int i = 0; i < componentCount; ++i) {
            float cw = this.getComponent((int)i).getPreferredSize().width;
            if (k > 1.0f || cw > dw) {
                cw *= k;
            }
            this.getComponent(i).setBounds((int)x, 0, (int)cw, h);
            x += cw;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getWidth(), this.getComponent((int)1).getPreferredSize().height);
    }
}

