/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.ui.menubuilders.generic.UserRoleConstraint;
import org.freeplane.core.util.TextUtils;

public abstract class AFreeplaneAction
extends AbstractAction
implements IFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final String key;
    private boolean selected = false;
    private final String rawText;
    private UserRoleConstraint constraint = UserRoleConstraint.NO_CONSTRAINT;

    public AFreeplaneAction(String key) {
        this.key = key;
        this.rawText = TextUtils.getRawText(this.getTextKey());
        LabelAndMnemonicSetter.setLabelAndMnemonic(this, this.rawText);
        this.setIcon(this.getIconKey());
        this.setTooltip(this.getTooltipKey());
    }

    public void addConstraint(UserRoleConstraint constraint) {
        this.constraint = this.constraint.and(constraint);
    }

    protected void setIcon(String iconKey) {
        Icon icon = ResourceController.getResourceController().getIcon(iconKey);
        this.setIcon(icon);
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setTooltip(String tooltipKey) {
        String tooltip = TextUtils.getRawText(tooltipKey, null);
        if (tooltip != null && !"".equals(tooltip)) {
            this.putValue("ShortDescription", tooltip);
            this.putValue("LongDescription", tooltip);
        }
    }

    public AFreeplaneAction(String key, String title, Icon icon) {
        if (title != null && !title.equals("")) {
            LabelAndMnemonicSetter.setLabelAndMnemonic(this, title);
        }
        this.rawText = title;
        this.key = key;
        this.setIcon(icon);
    }

    @Override
    public void afterMapChange(UserRole userRole) {
        if (userRole == UserRole.NO_MAP) {
            if (super.isEnabled()) {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(userRole);
        }
    }

    public boolean checkEnabledOnChange() {
        EnabledAction annotation = this.getClass().getAnnotation(EnabledAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnNodeChange();
    }

    public boolean checkSelectionOnChange() {
        SelectableAction annotation = this.getClass().getAnnotation(SelectableAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnNodeChange();
    }

    public boolean checkSelectionOnPropertyChange() {
        SelectableAction annotation = this.getClass().getAnnotation(SelectableAction.class);
        if (annotation == null) {
            return false;
        }
        return !"".equals(annotation.checkOnPropertyChange());
    }

    public boolean checkSelectionOnPopup() {
        SelectableAction annotation = this.getClass().getAnnotation(SelectableAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnPopup();
    }

    public boolean checkEnabledOnPopup() {
        EnabledAction annotation = this.getClass().getAnnotation(EnabledAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnPopup();
    }

    @Override
    public String getIconKey() {
        return this.key + ".icon";
    }

    public String getKey() {
        return this.key;
    }

    public String getTextKey() {
        return this.key + ".text";
    }

    public String getTooltipKey() {
        return this.key + ".tooltip";
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    protected void setEnabled() {
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
    }

    public void setSelected() {
    }

    @Override
    public void setSelected(boolean newValue) {
        boolean oldValue = this.selected;
        if (oldValue != newValue) {
            this.selected = newValue;
            this.firePropertyChange("selected", oldValue, newValue);
        }
    }

    public void setVisible() {
    }

    public boolean isSelectable() {
        return this.getClass().getAnnotation(SelectableAction.class) != null;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setEnabled(UserRole userRole) {
        if (this.constraint.test(userRole)) {
            this.setEnabled();
        } else {
            this.setEnabled(false);
        }
    }

    public Icon getIcon() {
        return ResourceController.getResourceController().getIcon(this.getIconKey());
    }
}

