/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io.xml;

import java.awt.Point;
import java.io.Reader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementContentHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.ListHashTable;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.xml.StdXMLBuilder;
import org.freeplane.core.io.xml.XMLParser;
import org.freeplane.core.util.LogUtils;
import org.freeplane.n3.nanoxml.IXMLBuilder;
import org.freeplane.n3.nanoxml.NonValidator;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLException;

public class TreeXmlReader
implements IXMLBuilder {
    private Hashtable<String, IAttributeHandler> attributeHandlersForTag;
    private Object currentElement;
    private String elementContentAsString;
    private final LinkedList<Object> elementStack = new LinkedList();
    private IElementHandler nodeCreator;
    private final LinkedList<IElementHandler> nodeCreatorStack = new LinkedList();
    private Object parentElement;
    private final ReadManager parseManager;
    private XMLParser parser;
    private XMLElement saveAsXmlUntil;
    private String tag;
    private StdXMLBuilder xmlBuilder;

    public static boolean xmlToBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public static Date xmlToDate(String xmlString) {
        try {
            return new Date(Long.valueOf(xmlString));
        }
        catch (Exception e) {
            return new Date(System.currentTimeMillis());
        }
    }

    public static Point xmlToPoint(String string) {
        StringTokenizer tok;
        if (string == null) {
            return null;
        }
        if (string.startsWith("java.awt.Point")) {
            string = string.replaceAll("java\\.awt\\.Point\\[x=(-?[0-9]+),y=(-?[0-9]+)\\]", "$1;$2");
        }
        if ((tok = new StringTokenizer(string, ";")).countTokens() != 2) {
            throw new IllegalArgumentException("A point must consist of two numbers (and not: '" + string + "').");
        }
        int x = Quantity.fromString((String)tok.nextToken(), (Enum)LengthUnit.px).toBaseUnitsRounded();
        int y = Quantity.fromString((String)tok.nextToken(), (Enum)LengthUnit.px).toBaseUnitsRounded();
        return new Point(x, y);
    }

    public TreeXmlReader(ReadManager parseManager) {
        this.parseManager = parseManager;
    }

    private boolean addAttribute(String key, String value) {
        IAttributeHandler attributeHandler;
        if (this.saveAsXmlUntil == null && this.attributeHandlersForTag != null && (attributeHandler = this.attributeHandlersForTag.get(key)) != null) {
            try {
                attributeHandler.setAttribute(this.currentElement, value);
                return true;
            }
            catch (Exception e) {
                LogUtils.severe("Can not process attribute" + key + " = '" + value + "'", e);
            }
        }
        return false;
    }

    @Override
    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        if (!this.addAttribute(key, value)) {
            this.xmlBuilder.addAttribute(key, nsPrefix, nsURI, value, type);
        }
    }

    @Override
    public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        this.xmlBuilder.addPCData(reader, systemID, lineNr);
    }

    @Override
    public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
        this.xmlBuilder.elementAttributesProcessed(name, nsPrefix, nsURI);
        if (this.saveAsXmlUntil != null || this.nodeCreator != null) {
            return;
        }
        Iterator<IElementHandler> iterator = this.getElementHandlers().iterator(this.tag);
        XMLElement lastBuiltElement = this.xmlBuilder.getLastBuiltElement();
        while (iterator.hasNext() && this.currentElement == null) {
            this.nodeCreator = iterator.next();
            try {
                this.currentElement = this.nodeCreator.createElement(this.parentElement, name, lastBuiltElement);
            }
            catch (Exception e) {
                LogUtils.severe("Can not process element" + name, e);
            }
        }
        if (this.currentElement != null) {
            if (this.nodeCreator instanceof IElementContentHandler && ((IElementContentHandler)this.nodeCreator).containsXml(lastBuiltElement)) {
                this.parser.notParseNextElementContent();
            }
            this.attributeHandlersForTag = this.getAttributeLoaders().get(this.tag);
            if (this.attributeHandlersForTag == null) {
                return;
            }
            Enumeration<String> attributeNames = lastBuiltElement.enumerateAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String atName = attributeNames.nextElement();
                if (!this.addAttribute(atName, lastBuiltElement.getAttribute(atName, null))) continue;
                lastBuiltElement.removeAttribute(atName);
            }
        } else {
            this.currentElement = null;
            this.nodeCreator = null;
            this.saveAsXmlUntil = lastBuiltElement;
        }
    }

    @Override
    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        XMLElement lastBuiltElement = this.xmlBuilder.getParentElement();
        this.xmlBuilder.endElement(name, nsPrefix, nsURI);
        if (this.saveAsXmlUntil == lastBuiltElement) {
            this.saveAsXmlUntil = null;
        }
        if (this.saveAsXmlUntil != null) {
            return;
        }
        this.tag = null;
        if (0 == this.elementStack.size()) {
            return;
        }
        Object element = this.currentElement;
        this.currentElement = this.elementStack.removeLast();
        try {
            if (this.nodeCreator instanceof IElementContentHandler) {
                IElementContentHandler contentHandler;
                contentHandler.endElement(this.currentElement, name, element, lastBuiltElement, (contentHandler = (IElementContentHandler)this.nodeCreator).containsXml(lastBuiltElement) ? this.elementContentAsString : lastBuiltElement.getContent());
            } else if (this.nodeCreator instanceof IElementDOMHandler) {
                ((IElementDOMHandler)this.nodeCreator).endElement(this.currentElement, name, element, lastBuiltElement);
            }
        }
        catch (Exception e) {
            LogUtils.severe("Can not process element" + name, e);
        }
        XMLElement top = lastBuiltElement.getParent();
        if (this.nodeCreator != null && top != null && top.hasChildren()) {
            int lastChildIndex = top.getChildrenCount() - 1;
            top.removeChildAtIndex(lastChildIndex);
        }
        this.nodeCreator = this.nodeCreatorStack.removeLast();
        this.elementContentAsString = null;
    }

    private Hashtable<String, Hashtable<String, IAttributeHandler>> getAttributeLoaders() {
        return this.parseManager.getAttributeHandlers();
    }

    private ListHashTable<String, IElementHandler> getElementHandlers() {
        return this.parseManager.getElementHandlers();
    }

    @Override
    public Object getResult() throws Exception {
        return null;
    }

    public void load(Reader reader) throws XMLException {
        this.parser = new XMLParser();
        StdXMLReader nanoxmlReader = new StdXMLReader(reader);
        this.parser.setReader(nanoxmlReader);
        this.parser.setBuilder(this);
        this.parser.setValidator(new NonValidator());
        this.parser.parse();
    }

    @Override
    public void newProcessingInstruction(String target, Reader reader) throws Exception {
        this.xmlBuilder.newProcessingInstruction(target, reader);
    }

    private void pushParentObjects() {
        this.elementStack.addLast(this.currentElement);
        this.nodeCreatorStack.addLast(this.nodeCreator);
    }

    public void setElementContent(String content) {
        this.elementContentAsString = content;
    }

    @Override
    public void startBuilding(String systemID, int lineNr) throws Exception {
        this.xmlBuilder = new StdXMLBuilder();
        this.xmlBuilder.startBuilding(systemID, lineNr);
        this.saveAsXmlUntil = null;
    }

    @Override
    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        if (this.saveAsXmlUntil != null) {
            this.xmlBuilder.startElement(name, nsPrefix, nsURI, systemID, lineNr);
            return;
        }
        this.xmlBuilder.startElement(name, nsPrefix, nsURI, systemID, lineNr);
        this.tag = name;
        this.pushParentObjects();
        this.parentElement = this.currentElement;
        this.currentElement = null;
        List<IElementHandler> handlers = this.getElementHandlers().list(this.tag);
        if (handlers != null && handlers.size() == 1) {
            this.nodeCreator = handlers.get(0);
            try {
                this.currentElement = this.nodeCreator.createElement(this.parentElement, this.tag, null);
            }
            catch (Exception e) {
                LogUtils.severe("Can not process element" + this.tag, e);
            }
        }
        if (this.currentElement != null) {
            this.attributeHandlersForTag = this.getAttributeLoaders().get(this.tag);
            if (this.nodeCreator instanceof IElementContentHandler) {
                this.parser.notParseNextElementContent();
            }
        } else {
            this.attributeHandlersForTag = null;
            this.currentElement = null;
            this.nodeCreator = null;
        }
    }

    public void load(Object currentElement, Reader pReader) throws XMLException {
        this.currentElement = currentElement;
        this.load(pReader);
    }
}

