/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DynamicResource;
import com.lightdev.app.shtm.PrefsDialog;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.UIResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;

public class Util {
    public static final String JAR_PREFIX = "jar:";
    public static final String JAR_EXTENSION = ".jar";
    public static final String FILE_PREFIX = "file:";
    public static final String CLASS_EXT = ".class";
    public static final String JAR_SEPARATOR = "!/";
    public static final String URL_SEPARATOR = "/";
    public static final char URL_SEPARATOR_CHAR = '/';
    public static final String CLASS_SEPARATOR = ".";
    public static final char CLASS_SEPARATOR_CHAR = '.';
    public static final String DIR_UP_INDICATOR = "..";
    public static final String RELATIVE_PREFIX = "../";
    public static final String PROTOCOL_SEPARATOR = ":";
    public static final String ANCHOR_SEPARATOR = "#";
    public static final String pct = "%";
    public static final String pt = "pt";
    public static final String px = "px";
    private static int blockSize = 1024;
    private static Vector startTimes = new Vector();
    private static final String ERR_TITLE = "Error";
    private static String unit = "";
    private static StyleSheet s = new StyleSheet();
    public static final String CSS_ATTRIBUTE_NORMAL = "normal";
    public static final String CSS_ATTRIBUTE_UNDERLINE = "underline";
    public static final String CSS_ATTRIBUTE_LINE_THROUGH = "line-through";
    public static final String CSS_ATTRIBUTE_NONE = "none";
    public static final String CSS_ATTRIBUTE_ALIGN_LEFT = "left";
    public static final String CSS_ATTRIBUTE_ALIGN_CENTER = "center";
    public static final String CSS_ATTRIBUTE_ALIGN_RIGHT = "right";

    public static File renameFile(File from, String newExt) {
        String fileName = Util.removeExtension(from.getName());
        String saveFileName = from.getParentFile().getAbsolutePath() + File.separator + fileName + newExt;
        File newFile = new File(saveFileName);
        from.renameTo(newFile);
        return newFile;
    }

    public static Object findLinkUp(Element elem) {
        Object linkAttr = null;
        Object href = null;
        while (elem != null && linkAttr == null) {
            linkAttr = elem.getAttributes().getAttribute(HTML.Tag.A);
            if (linkAttr != null) {
                href = ((AttributeSet)linkAttr).getAttribute(HTML.Attribute.HREF);
            }
            elem = elem.getParentElement();
        }
        if (linkAttr != null && href != null) {
            return linkAttr;
        }
        return null;
    }

    public static String removeExtension(String fileName) {
        String newName = fileName;
        int pos = newName.lastIndexOf(CLASS_SEPARATOR);
        if (pos > -1) {
            newName = fileName.substring(0, pos);
        }
        return newName;
    }

    public static AttributeSet resolveAttributes(AttributeSet style) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        if (style != null) {
            Enumeration<?> names = style.getAttributeNames();
            while (names.hasMoreElements()) {
                Object key = names.nextElement();
                Object value = style.getAttribute(key);
                if (!(key.equals(StyleConstants.NameAttribute) || key.equals(StyleConstants.ResolveAttribute) || key.equals(AttributeSet.ResolveAttribute) || key.equals(AttributeSet.NameAttribute))) {
                    set.addAttribute(key, value);
                    continue;
                }
                if (!key.equals(StyleConstants.ResolveAttribute) && !key.equals(AttributeSet.ResolveAttribute)) continue;
                set.addAttributes(Util.resolveAttributes((AttributeSet)value));
            }
        }
        return set;
    }

    public static String nameInput(Frame parent, String initialName, String regex, String title, String text) {
        String name;
        do {
            Object input;
            String string = name = (input = JOptionPane.showInputDialog(null, Util.getResourceString(text), Util.getResourceString(title), 3, null, null, initialName)) == null ? null : input.toString();
        } while (name != null && !name.matches(regex));
        return name;
    }

    public static int msgChoice(int options, String title, String msg, String item, String sep) {
        String message = item + sep + Util.getResourceString(msg);
        return JOptionPane.showConfirmDialog(null, message, Util.getResourceString(title), options, 3);
    }

    public static boolean msg(int options, String title, String msg, String item, String sep) {
        return Util.msgChoice(options, title, msg, item, sep) == 0;
    }

    public static Vector getStyleNamesForTag(StyleSheet styles, String tag) {
        return Util.getStyleClassVector(tag, styles.getStyleNames());
    }

    public static Vector getStyleNamesForTag(AttributeSet styles, String tag) {
        return Util.getStyleClassVector(tag, styles.getAttributeNames());
    }

    private static Vector getStyleClassVector(String tag, Enumeration e) {
        Vector<String> v = new Vector<String>(0);
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.toLowerCase().startsWith(tag + CLASS_SEPARATOR)) continue;
            v.addElement(name.substring(2));
        }
        return v;
    }

    public static Vector getStyleNames(StyleSheet styles) {
        Vector styleNames = new Vector(0);
        try {
            Enumeration<?> rules = styles.getStyleNames();
            while (rules.hasMoreElements()) {
                styleNames.addElement(rules.nextElement());
            }
        }
        catch (Exception ee) {
            Util.errMsg(null, ee.getMessage(), ee);
        }
        return styleNames;
    }

    public static void deleteDir(File dir) {
        if (dir.exists()) {
            File[] list = dir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    Util.deleteDir(list[i]);
                    continue;
                }
                list[i].delete();
            }
            dir.delete();
        }
    }

    public static void copyFile(File srcFile, File destFile) throws FileNotFoundException, IOException {
        if (!srcFile.toString().equals(destFile.toString()) && !destFile.exists()) {
            byte[] buf = new byte[blockSize];
            int bytesRead = 0;
            File destDir = new File(destFile.getParent());
            destDir.mkdirs();
            try (RandomAccessFile src = new RandomAccessFile(srcFile.getPath(), "r");
                 RandomAccessFile dest = new RandomAccessFile(destFile.getPath(), "rw");){
                bytesRead = src.read(buf);
                while (bytesRead > -1) {
                    dest.write(buf, 0, bytesRead);
                    bytesRead = src.read(buf);
                }
            }
        }
    }

    public static int getElementIndex(Element elem) {
        int i = 0;
        Element parent = elem.getParentElement();
        if (parent != null) {
            int last = parent.getElementCount() - 1;
            Element anElem = parent.getElement(i);
            if (anElem != elem) {
                while (i < last && anElem != elem) {
                    anElem = parent.getElement(++i);
                }
            }
        }
        return i;
    }

    public static String getClassFilePath(Class cls) {
        URL url;
        int end = 0;
        String urlStr = null;
        String clsName = cls.getName();
        int clsNameLen = clsName.length() + CLASS_EXT.length();
        int pos = clsName.lastIndexOf(CLASS_SEPARATOR);
        if (pos > -1) {
            clsName = clsName.substring(pos + 1);
        }
        if ((url = cls.getResource(clsName = clsName + CLASS_EXT)) != null) {
            urlStr = url.toString();
            pos = urlStr.indexOf(JAR_SEPARATOR);
            if (pos > -1) {
                urlStr = urlStr.substring(0, pos);
                end = urlStr.lastIndexOf(URL_SEPARATOR) + 1;
            } else {
                end = urlStr.length() - clsNameLen;
            }
            pos = urlStr.lastIndexOf(FILE_PREFIX);
            pos = pos > -1 ? (pos += FILE_PREFIX.length() + 1) : 0;
            urlStr = urlStr.substring(pos, end);
            urlStr = urlStr.replaceAll("%20", " ");
        }
        return urlStr;
    }

    public static float getPtValue(String valStr) {
        float len = 0.0f;
        int pos = valStr.indexOf(pt);
        if (pos > -1) {
            unit = pt;
            valStr = valStr.substring(0, pos);
            len = Float.valueOf(valStr).floatValue();
        } else {
            pos = valStr.indexOf(px);
            if (pos > -1) {
                unit = px;
                valStr = valStr.substring(0, pos);
                len = Float.valueOf(valStr).floatValue() * 1.3f;
            } else {
                pos = valStr.indexOf(pct);
                if (pos > -1) {
                    unit = pct;
                    valStr = valStr.substring(0, pos);
                    len = Float.valueOf(valStr).floatValue() / 100.0f;
                } else {
                    try {
                        len = Float.valueOf(valStr).floatValue();
                        unit = pt;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return len;
    }

    public static String getLastAttrUnit() {
        return unit;
    }

    public static float getAttrValue(Object attr) {
        float val = -1.0f;
        if (attr != null) {
            val = Util.getPtValue(attr.toString());
        }
        return val;
    }

    public static float getAbsoluteAttrVal(Object attr) {
        String valStr = null;
        if (attr != null) {
            valStr = attr.toString();
            int pos = valStr.indexOf(pt);
            unit = pt;
            if (pos < 0) {
                pos = valStr.indexOf(pct);
                unit = pct;
                if (pos < 0) {
                    pos = valStr.indexOf(px);
                }
            }
            if (pos > -1) {
                valStr = valStr.substring(0, pos);
                return Float.valueOf(valStr).floatValue();
            }
            unit = "";
        }
        try {
            return Float.valueOf(valStr).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static int getRowIndex(Element cell) {
        Element thisRow = cell.getParentElement();
        Element table = thisRow.getParentElement();
        int index = 0;
        int count = table.getElementCount();
        Element elem = table.getElement(index);
        while (!elem.equals(thisRow) && index < count) {
            elem = table.getElement(++index);
        }
        return index;
    }

    public static String[] tokenize(String input, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, delim);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)v.elementAt(i);
        }
        return result;
    }

    public static void msgStart(String startMsg) {
        long startTime = System.currentTimeMillis();
        startTimes.addElement(new Long(startTime));
    }

    public static Element findElementUp(String name, Element start) {
        Element elem;
        for (elem = start; elem != null && !elem.getName().equalsIgnoreCase(name); elem = elem.getParentElement()) {
        }
        return elem;
    }

    public static Element findElementUp(String name1, String name2, Element start) {
        Element elem;
        for (elem = start; elem != null && !elem.getName().equalsIgnoreCase(name1) && !elem.getName().equalsIgnoreCase(name2); elem = elem.getParentElement()) {
        }
        return elem;
    }

    public static Element findElementDown(String name, Element parent) {
        Element foundElement = null;
        ElementIterator eli = new ElementIterator(parent);
        Element thisElement = eli.first();
        while (thisElement != null && foundElement == null) {
            if (thisElement.getName().equalsIgnoreCase(name)) {
                foundElement = thisElement;
            }
            thisElement = eli.next();
        }
        return foundElement;
    }

    public static void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a) {
        Util.addGridBagComponent(container, comp, g, c, gx, gy, a, 1, 1, 0, 0.0, 0.0);
    }

    public static void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a, int gw, int gh) {
        Util.addGridBagComponent(container, comp, g, c, gx, gy, a, gw, gh, 0, 0.0, 0.0);
    }

    public static void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a, int gw, int gh, int f) {
        Util.addGridBagComponent(container, comp, g, c, gx, gy, a, gw, gh, 0, 0.0, 0.0);
    }

    public static void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a, int gw, int gh, int f, double wx, double wy) {
        c.gridx = gx;
        c.gridy = gy;
        c.anchor = a;
        c.insets = new Insets(2, 2, 2, 2);
        c.ipadx = 2;
        c.ipady = 2;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.fill = f;
        c.weightx = wx;
        c.weighty = wy;
        g.setConstraints(comp, c);
        container.add(comp);
    }

    public static URL resolveRelativePath(URL base, String relPath) {
        try {
            return new URL(base, relPath);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getRelativePath(File fromFile, File toFile) {
        if (!fromFile.isDirectory()) {
            return Util.getRelativePath(fromFile.getParentFile(), toFile);
        }
        String fromStr = fromFile.getAbsolutePath();
        if (!fromStr.endsWith(File.separator)) {
            fromStr = fromStr + File.separator;
        }
        String toStr = toFile.getAbsolutePath();
        int pos = fromStr.indexOf(File.separator);
        int fromLen = fromStr.length();
        int toLen = toStr.length();
        int oldPos = pos;
        while (pos > -1 && pos < fromLen && pos < toLen && fromStr.substring(0, pos).equalsIgnoreCase(toStr.substring(0, pos))) {
            oldPos = pos + 1;
            pos = fromStr.indexOf(File.separator, oldPos);
        }
        int samePos = oldPos;
        int level = 0;
        while (pos > -1) {
            ++level;
            oldPos = pos + 1;
            pos = fromStr.indexOf(File.separator, oldPos);
        }
        StringBuffer relPath = new StringBuffer();
        if (level > 0) {
            for (int i = 0; i < level; ++i) {
                relPath.append(DIR_UP_INDICATOR);
                relPath.append(File.separator);
            }
        }
        relPath.append(toStr.substring(samePos));
        return relPath.toString().replace(File.separatorChar, '/');
    }

    public static void errMsg(Component owner, String msg, Throwable e) {
        if (e != null) {
            e.printStackTrace();
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(owner, msg, ERR_TITLE, 0);
        }
    }

    public static void center(Component parent, Component comp) {
        Dimension cSize = comp.getPreferredSize();
        Dimension fSize = parent.getSize();
        Point loc = parent.getLocation();
        comp.setLocation((fSize.width - cSize.width) / 2 + loc.x, (fSize.height - cSize.height) / 2 + loc.y);
    }

    public static StyleSheet styleSheet() {
        return s;
    }

    public static String removeChar(String src, char c) {
        StringBuffer buf = new StringBuffer();
        int start = 0;
        int pos = src.indexOf(c);
        while (pos > -1 && start < src.length()) {
            pos = src.indexOf(c, start);
            if (pos <= -1 || start >= src.length()) continue;
            buf.append(src.substring(start, pos));
            start = pos + 1;
        }
        if (start < src.length()) {
            buf.append(src.substring(start));
        }
        if (buf.length() == 0) {
            buf.append(src);
        }
        return buf.toString();
    }

    public static String getResourceString(UIResources resources, String nm) {
        return DynamicResource.getResourceString(resources, nm);
    }

    public static String getResourceString(String nm) {
        String resourceString = DynamicResource.getResourceString(SHTMLPanelImpl.getUiResources(), nm);
        return resourceString != null ? resourceString : nm;
    }

    public static <T extends Enum<T>> T getPreference(String key, T defaultValue) {
        Class<?> valueClass = defaultValue.getClass();
        return (T)Enum.valueOf(valueClass, Util.getPreference(key, defaultValue.name()));
    }

    public static String getPreference(String key, String defaultValue) {
        String paramValue = DynamicResource.getResourceString(SHTMLPanel.getResources(), key);
        if (paramValue != null) {
            return paramValue;
        }
        paramValue = defaultValue;
        try {
            Preferences prefs = Preferences.userNodeForPackage(PrefsDialog.class);
            paramValue = prefs.get(key, paramValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paramValue;
    }

    static boolean preferenceIsTrue(String key) {
        return Util.getPreference(key, "false").equalsIgnoreCase("true");
    }

    static boolean preferenceIsTrue(String key, String defaultValue) {
        return Util.getPreference(key, defaultValue).equalsIgnoreCase("true");
    }

    static boolean useSteStyleSheet() {
        return Util.getPreference("use_std_styles", "false").equalsIgnoreCase("true");
    }

    static boolean showViewsInTabs() {
        return Util.preferenceIsTrue("showViewsInTabs", "true");
    }
}

