/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLDocument;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;

public class SHTMLWriter
extends HTMLWriter {
    private static final char NB_SPACE = '\u00a0';
    private Element element;
    private Writer writer = null;
    private boolean replaceEntities;
    private boolean inTextArea;
    private int inPreLevel = 0;
    private char[] tempChars;
    private static final Map<Character, String> HTML_CHAR_ENTITIES = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('<'), "&lt;");
            this.put(Character.valueOf('>'), "&gt;");
            this.put(Character.valueOf('&'), "&amp;");
            this.put(Character.valueOf('\"'), "&quot;");
            this.put(Character.valueOf('<'), "&lt;");
            this.put(Character.valueOf('\u00a0'), "&nbsp;");
        }
    };

    public SHTMLWriter(Writer w, HTMLDocument doc, int pos, int len) {
        super(w, doc, pos, len);
        this.writer = w;
    }

    public SHTMLWriter(HTMLDocument doc) {
        this((Writer)new StringWriter(), doc, 0, doc.getLength());
    }

    public SHTMLWriter(Writer w, HTMLDocument doc) {
        this(w, doc, 0, doc.getLength());
    }

    @Override
    protected ElementIterator getElementIterator() {
        if (this.element == null) {
            return super.getElementIterator();
        }
        return new ElementIterator(this.element);
    }

    @Override
    protected void output(char[] chars, int start, int length) throws IOException {
        if (!this.replaceEntities) {
            this.directOutput(chars, start, length);
            return;
        }
        if (this.inPreLevel == 0) {
            this.replaceMultipleSpacesByNonBreakingSpaces(chars, start, length);
        }
        int last = start;
        length += start;
        for (int counter = start; counter < length; ++counter) {
            char c = chars[counter];
            String replacement = this.entity(c);
            if (replacement == null) continue;
            this.directOutput(chars, last, counter - last);
            this.directOutput(replacement);
            last = counter + 1;
        }
        if (last < length) {
            this.directOutput(chars, last, length - last);
        }
    }

    private String entity(char c) {
        if (c < ' ') {
            return "&#x" + Integer.toHexString(c) + ';';
        }
        String knownEntity = HTML_CHAR_ENTITIES.get(Character.valueOf(c));
        return knownEntity;
    }

    private void replaceMultipleSpacesByNonBreakingSpaces(char[] chars, int start, int length) {
        if (chars[start] == ' ') {
            chars[start] = 160;
        }
        int last = start + length - 1;
        for (int i = start + 1; i < last; ++i) {
            if (chars[i] != ' ' || chars[i - 1] != '\u00a0' && chars[i + 1] != ' ') continue;
            chars[i] = 160;
        }
    }

    private void directOutput(char[] content, int start, int length) throws IOException {
        this.getWriter().write(content, start, length);
        this.setCurrentLineLength(this.getCurrentLineLength() + length);
    }

    private void directOutput(String string) throws IOException {
        int length = string.length();
        if (this.tempChars == null || this.tempChars.length < length) {
            this.tempChars = new char[length];
        }
        string.getChars(0, length, this.tempChars, 0);
        this.directOutput(this.tempChars, 0, length);
    }

    @Override
    protected void startTag(Element elem) throws IOException, BadLocationException {
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PRE)) {
            ++this.inPreLevel;
        }
        super.startTag(elem);
    }

    @Override
    protected void endTag(Element elem) throws IOException {
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PRE)) {
            --this.inPreLevel;
        }
        super.endTag(elem);
    }

    @Override
    protected void text(Element elem) throws BadLocationException, IOException {
        boolean replaceEntitiesOld = this.replaceEntities;
        this.replaceEntities = true;
        super.text(elem);
        this.replaceEntities = replaceEntitiesOld;
    }

    @Override
    protected void textAreaContent(AttributeSet attr) throws BadLocationException, IOException {
        boolean replaceEntitiesOld = this.replaceEntities;
        this.inTextArea = true;
        this.replaceEntities = true;
        super.textAreaContent(attr);
        this.inTextArea = false;
        this.replaceEntities = replaceEntitiesOld;
    }

    @Override
    public void write() throws IOException, BadLocationException {
        this.replaceEntities = false;
        super.write();
    }

    @Override
    protected void writeLineSeparator() throws IOException {
        boolean pre = this.replaceEntities;
        this.replaceEntities = false;
        super.writeLineSeparator();
        this.replaceEntities = pre;
    }

    @Override
    protected void indent() throws IOException {
        if (this.inTextArea) {
            return;
        }
        boolean pre = this.replaceEntities;
        this.replaceEntities = false;
        super.indent();
        this.replaceEntities = pre;
    }

    synchronized void write(Element element) throws IOException, BadLocationException {
        this.element = element;
        try {
            this.write();
        }
        catch (BadLocationException e) {
            element = null;
            throw e;
        }
        catch (IOException e) {
            element = null;
            throw e;
        }
    }

    public void writeChildElements(Element parentElement) throws IOException, BadLocationException {
        for (int i = 0; i < parentElement.getElementCount(); ++i) {
            Element childElement = parentElement.getElement(i);
            this.write(childElement);
        }
    }

    @Override
    protected boolean inRange(Element next) {
        Document document = next.getDocument();
        if (document instanceof SHTMLDocument && next.getStartOffset() >= ((SHTMLDocument)document).getLastDocumentPosition()) {
            return false;
        }
        return super.inRange(next);
    }

    private static void convertStyleToHTMLStyle(AttributeSet source, MutableAttributeSet target) {
        if (source == null) {
            return;
        }
        Enumeration<?> sourceAttributeNames = source.getAttributeNames();
        String value = "";
        while (sourceAttributeNames.hasMoreElements()) {
            Object sourceAttributeName = sourceAttributeNames.nextElement();
            if (sourceAttributeName instanceof CSS.Attribute) {
                if (value.length() > 0) {
                    value = value + "; ";
                }
                value = value + sourceAttributeName + ": " + source.getAttribute(sourceAttributeName);
                continue;
            }
            target.addAttribute(sourceAttributeName, source.getAttribute(sourceAttributeName));
        }
        if (value.length() > 0) {
            target.addAttribute(HTML.Attribute.STYLE, value);
        }
    }

    @Override
    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Element element;
        Object endTag;
        Object nameTag = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
        Object object = endTag = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
        if (nameTag != null && endTag != null && endTag instanceof String && ((String)endTag).equals("true")) {
            return;
        }
        if (attributeSet instanceof Element && ((element = (Element)((Object)attributeSet)).isLeaf() || element.getName().equalsIgnoreCase("p-implied"))) {
            super.writeAttributes(attributeSet);
            return;
        }
        SimpleAttributeSet convertedAttributeSet = new SimpleAttributeSet();
        SHTMLWriter.convertStyleToHTMLStyle(attributeSet, convertedAttributeSet);
        Enumeration<?> attributeNames = convertedAttributeSet.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attributeName = attributeNames.nextElement();
            if (attributeName instanceof HTML.Tag || attributeName instanceof StyleConstants || attributeName == HTML.Attribute.ENDTAG) continue;
            this.write(" " + attributeName + "=\"" + convertedAttributeSet.getAttribute(attributeName) + "\"");
        }
    }

    private void writeElementsUntil(Element e, Element end) throws IOException, BadLocationException {
        if (e.isLeaf()) {
            this.write(e);
        } else if (e != end) {
            this.startTag(e);
            int childCount = e.getElementCount();
            for (int index = 0; index < childCount; ++index) {
                this.writeElementsUntil(e.getElement(index), end);
            }
            this.endTag(e);
        }
    }

    void write(Element startElement, Element endElement) throws IOException, BadLocationException {
        Element parentElement = startElement.getParentElement();
        int count = parentElement.getElementCount();
        int i = 0;
        Element e = parentElement.getElement(i);
        while (i < count && e != startElement) {
            e = parentElement.getElement(i++);
        }
        while (i < count) {
            this.writeElementsUntil(e, endElement);
            e = parentElement.getElement(i++);
        }
    }

    void writeStartTag(Element elem) throws IOException, BadLocationException {
        super.startTag(elem);
    }

    void writeEndTag(Element elem) throws IOException {
        super.endTag(elem);
    }

    void writeEndTag(String elementName) throws IOException {
        this.indent();
        this.write('<');
        this.write('/');
        this.write(elementName);
        this.write('>');
        this.writeLineSeparator();
    }

    void writeStartTag(String elementName, AttributeSet attributes) throws IOException {
        this.indent();
        this.write('<');
        this.write(elementName);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        this.write('>');
        this.writeLineSeparator();
    }

    @Override
    public void write(String string) throws IOException {
        this.writer.write(string);
    }

    public String toString() {
        if (this.writer instanceof StringWriter) {
            StringWriter stringWriter = (StringWriter)this.writer;
            return stringWriter.getBuffer().toString();
        }
        return super.toString();
    }

    String getWrittenString() {
        if (this.writer instanceof StringWriter) {
            StringWriter stringWriter = (StringWriter)this.writer;
            return stringWriter.getBuffer().toString();
        }
        return null;
    }

    void removeLastWrittenNewline() {
        if (this.writer instanceof StringWriter) {
            StringWriter stringWriter = (StringWriter)this.writer;
            int charIdx = stringWriter.getBuffer().length();
            while (stringWriter.getBuffer().charAt(--charIdx) <= '\r') {
                stringWriter.getBuffer().deleteCharAt(charIdx);
            }
        }
    }
}

