/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import java.util.List;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.plugin.script.FormulaCache;
import org.freeplane.plugin.script.FormulaDependencies;
import org.freeplane.plugin.script.FormulaUtils;

public class FormulaUpdateChangeListener
implements INodeChangeListener,
IMapChangeListener,
IMapLifeCycleListener {
    public void nodeChanged(NodeChangeEvent event) {
        Object property = event.getProperty();
        if ("node_text".equals(property) || NodeAttributeTableModel.class.equals(property) || "note_text".equals(property) || "icon".equals(property) || LogicalStyleModel.class.equals(property) || DetailModel.class.equals(property)) {
            this.nodeChangedImpl(false, event.getNode());
        }
    }

    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        this.nodeChangedImpl(true, nodeDeletionEvent.parent);
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        this.nodeChangedImpl(true, parent);
    }

    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
        this.nodeChangedImpl(true, nodeMoveEvent.oldParent, nodeMoveEvent.newParent);
    }

    public void mapChanged(MapChangeEvent event) {
        if ("map_url".equals(event.getProperty())) {
            FormulaUtils.clearCache((MapModel)event.getMap());
        }
        if ("GLOBAL_NODES".equals(event.getProperty())) {
            this.globalNodesChanged(event.getMap());
        }
    }

    private void globalNodesChanged(MapModel map) {
        List dependencies = FormulaDependencies.manageChangeAndReturnGlobalDependencies((MapModel)map);
        this.refresh(dependencies);
    }

    private void refresh(List<NodeModel> dependencies) {
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel dependentNode : dependencies) {
            modeController.getMapController().delayedNodeRefresh(dependentNode, FormulaCache.class, null, null);
        }
    }

    private void nodeChangedImpl(boolean includeChanged, NodeModel ... nodes) {
        List dependencies = FormulaDependencies.manageChangeAndReturnDependencies((boolean)includeChanged, (NodeModel[])nodes);
        this.refresh(dependencies);
    }

    public void onRemove(MapModel map) {
        List dependencies = FormulaDependencies.removeAndReturnMapDependencies((MapModel)map);
        this.refresh(dependencies);
    }
}

