/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.mindmapmode.INodeSelector;

class GlassPaneNodeSelector
extends MouseAdapter
implements IMouseListener {
    private final INodeSelector nodeSelector;
    private Component activeComponent;

    GlassPaneNodeSelector(INodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Component component = this.findMapComponent(e);
        if (this.canRedispatchEventFor(component)) {
            this.redispatchMouseEvent(e, component);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Component component = this.findMapComponent(e);
        if (component instanceof JTable) {
            this.mouseClickedOnTable((JTable)component, e);
        } else if (component instanceof MainView) {
            this.mouseClickedOnNode(e, (MainView)component);
        }
    }

    private void mouseClickedOnNode(MouseEvent e, MainView mainView) {
        NodeView nodeView = mainView.getNodeView();
        NodeModel node = nodeView.getModel();
        switch (e.getClickCount()) {
            case 1: {
                MapController mapController = Controller.getCurrentModeController().getMapController();
                mapController.toggleFolded(node);
                break;
            }
            case 2: {
                this.nodeSelector.nodeSelected(node);
            }
        }
    }

    private void mouseClickedOnTable(JTable table, MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, table);
        if (nodeView == null) {
            return;
        }
        Point pointAtTable = this.getPointAtComponent(e, table);
        int selectedRow = table.rowAtPoint(pointAtTable);
        if (selectedRow < 0 || selectedRow >= table.getRowCount()) {
            return;
        }
        String rowName = (String)table.getValueAt(selectedRow, 0);
        NodeModel node = nodeView.getModel();
        this.nodeSelector.tableRowSelected(node, rowName);
    }

    public boolean canRedispatchEventFor(Component component) {
        if (component instanceof MapView) {
            return true;
        }
        return component instanceof JScrollBar || SwingUtilities.getAncestorOfClass(JScrollBar.class, component) != null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Component component = this.findMapComponent(e);
        if (this.canRedispatchEventFor(component)) {
            this.redispatchMouseEvent(e, component);
            this.activeComponent = component;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.activeComponent != null) {
            this.redispatchMouseEvent(e, this.activeComponent);
            this.activeComponent = null;
        }
    }

    private Component findMapComponent(MouseEvent e) {
        Component glassPane = e.getComponent();
        Point glassPanePoint = e.getPoint();
        Container container = SwingUtilities.getRootPane(glassPane).getContentPane();
        Point containerPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, container);
        Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
        if (component instanceof MainView || component instanceof JTable || component instanceof MapView || component instanceof JScrollBar) {
            return component;
        }
        Container table = SwingUtilities.getAncestorOfClass(JTable.class, component);
        if (table != null) {
            return table;
        }
        return SwingUtilities.getAncestorOfClass(MapView.class, component);
    }

    private void redispatchMouseEvent(MouseEvent e, Component component) {
        MouseEvent componentEvent = this.convertToComponentEvent(e, component);
        component.dispatchEvent(componentEvent);
    }

    private MouseEvent convertToComponentEvent(MouseEvent e, Component component) {
        Point componentPoint = this.getPointAtComponent(e, component);
        MouseEvent componentEvent = new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger());
        return componentEvent;
    }

    private Point getPointAtComponent(MouseEvent e, Component component) {
        Component glassPane = e.getComponent();
        Point glassPanePoint = e.getPoint();
        Point componentPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, component);
        return componentPoint;
    }
}

