/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.SetAcceleratorOnNextClickAction;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.CollapseableBoxBuilder;
import org.freeplane.core.ui.components.resizer.JResizer;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.clipboard.mindmapmode.MClipboardControllers;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.styles.mindmapmode.ShowFormatPanelAction;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StyleEditorPanel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.mindmapmode.stylemode.DeleteLevelStyleAction;
import org.freeplane.main.mindmapmode.stylemode.DeleteUserStyleAction;
import org.freeplane.main.mindmapmode.stylemode.DialogController;
import org.freeplane.main.mindmapmode.stylemode.EditStylesAction;
import org.freeplane.main.mindmapmode.stylemode.ExtensionInstaller;
import org.freeplane.main.mindmapmode.stylemode.NewLevelStyleAction;
import org.freeplane.main.mindmapmode.stylemode.NewUserStyleAction;
import org.freeplane.main.mindmapmode.stylemode.SModeController;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;
import org.freeplane.view.swing.map.attribute.EditAttributesAction;
import org.freeplane.view.swing.map.mindmapmode.MMapViewController;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;
import org.freeplane.view.swing.ui.UserInputListenerFactory;
import org.freeplane.view.swing.ui.mindmapmode.MMapMouseListener;
import org.freeplane.view.swing.ui.mindmapmode.MNodeMouseWheelListener;

public class SModeControllerFactory {
    private static SModeControllerFactory instance;
    private SModeController modeController;
    private ExtensionInstaller extentionInstaller;

    public static SModeControllerFactory getInstance() {
        if (instance == null) {
            instance = new SModeControllerFactory();
        }
        return instance;
    }

    Controller createController(JDialog dialog) {
        Controller currentController = Controller.getCurrentController();
        final Controller controller = new Controller(ResourceController.getResourceController());
        Controller.setCurrentController((Controller)controller);
        MMapViewController mapViewController = new MMapViewController(controller);
        DialogController viewController = new DialogController(controller, (IMapViewManager)mapViewController, dialog);
        controller.setViewController((ViewController)viewController);
        controller.addExtension(HighlightController.class, (IExtension)new HighlightController());
        controller.addAction(currentController.getAction("AboutAction"));
        FilterController.install();
        TextController.install();
        controller.addAction((AFreeplaneAction)new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
        controller.addAction((AFreeplaneAction)new ShowSelectionAsRectangleAction());
        this.modeController = new SModeController(controller);
        controller.selectModeForBuild((ModeController)this.modeController);
        ClipboardControllers.install((ClipboardControllers)new MClipboardControllers());
        this.modeController.addAction(new NewUserStyleAction(false));
        this.modeController.addAction(new NewUserStyleAction(true));
        this.modeController.addAction(new DeleteUserStyleAction());
        this.modeController.addAction(new NewLevelStyleAction());
        this.modeController.addAction(new DeleteLevelStyleAction());
        this.modeController.addAction((AFreeplaneAction)new SetAcceleratorOnNextClickAction());
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory((ModeController)this.modeController);
        userInputListenerFactory.setNodeMouseMotionListener((IMouseListener)new DefaultNodeMouseMotionListener());
        userInputListenerFactory.setNodeMouseWheelListener((MouseWheelListener)((Object)new MNodeMouseWheelListener(userInputListenerFactory.getMapMouseWheelListener())));
        this.modeController.setUserInputListenerFactory((IUserInputListenerFactory)userInputListenerFactory);
        controller.addExtension(ModelessAttributeController.class, (IExtension)new ModelessAttributeController());
        new MMapController(this.modeController);
        ModelessAttributeController.installConditions();
        new MTextController(this.modeController).install(this.modeController);
        SpellCheckerController.install(this.modeController);
        new MIconController(this.modeController).install(this.modeController);
        NodeStyleController.install((NodeStyleController)new MNodeStyleController(this.modeController));
        LocationController.install((LocationController)new MLocationController());
        EdgeController.install((EdgeController)new MEdgeController(this.modeController));
        CloudController.install((CloudController)new MCloudController(this.modeController));
        NoteController.install((NoteController)new MNoteController(this.modeController));
        LinkController.install((LinkController)new MLinkController(this.modeController));
        MFileManager.install((UrlManager)new MFileManager());
        MLogicalStyleController logicalStyleController = new MLogicalStyleController(this.modeController);
        logicalStyleController.initS();
        LogicalStyleController.install((LogicalStyleController)logicalStyleController);
        AttributeController.install((AttributeController)new MAttributeController(this.modeController));
        FormatController.install((FormatController)new FormatController());
        IconController.installConditionControllers();
        ScannerController scannerController = new ScannerController();
        ScannerController.install((ScannerController)scannerController);
        scannerController.addParsersForStandardFormats();
        this.modeController.addAction((AFreeplaneAction)new EditAttributesAction());
        userInputListenerFactory.setMapMouseListener((IMouseListener)new MMapMouseListener());
        JPopupMenu popupmenu = new JPopupMenu();
        userInputListenerFactory.setNodePopupMenu(popupmenu);
        FreeplaneToolBar toolBar = new FreeplaneToolBar("main_toolbar", 0);
        UIComponentVisibilityDispatcher.install((JComponent)toolBar, (String)"dialog_toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, (JComponent)toolBar);
        userInputListenerFactory.addToolBar("/icon_toolbar", 1, ((MIconController)IconController.getController()).getIconToolBarScrollPane());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        Box closingButtons = Box.createHorizontalBox();
        closingButtons.add(Box.createHorizontalGlue());
        JButton okButton = TranslatedElementFactory.createButton((Action)controller.getAction("styledialog.ok"), (String)"styledialog.ok.text");
        closingButtons.add(okButton);
        closingButtons.add(Box.createHorizontalStrut(10));
        JButton cancelButton = TranslatedElementFactory.createButton((Action)controller.getAction("styledialog.cancel"), (String)"styledialog.cancel.text");
        closingButtons.add(cancelButton);
        closingButtons.add(Box.createHorizontalGlue());
        userInputListenerFactory.addToolBar("/closingbuttons", 3, (JComponent)closingButtons);
        this.modeController.addAction((AFreeplaneAction)new ToggleToolbarAction("ToggleLeftToolbarAction", "/icon_toolbar"));
        MapStyle.install((boolean)false);
        controller.addModeController((ModeController)this.modeController);
        controller.selectModeForBuild((ModeController)this.modeController);
        if (this.extentionInstaller != null) {
            this.extentionInstaller.installExtensions(controller);
        }
        SModeController modeController = this.modeController;
        StyleEditorPanel styleEditorPanel = new StyleEditorPanel(modeController, null, false);
        modeController.addAction((AFreeplaneAction)new ShowFormatPanelAction());
        final MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                final IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                if (selection.size() == 1 && node.depth() >= 2) {
                    return;
                }
                final NodeModel nextSelection = node.depth() < 2 ? (node.depth() == 1 && node.hasChildren() ? node.getChildAt(0) : node.getMap().getRootNode().getChildAt(0).getChildAt(0)) : node;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        selection.selectAsTheOnlyOneSelected(nextSelection);
                    }
                });
            }

            public void onDeselect(NodeModel node) {
            }
        });
        mapController.addUINodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (MapStyleModel.isPredefinedStyleNode((NodeModel)node)) {
                    mapController.fireMapChanged(new MapChangeEvent((Object)this, node.getMap(), (Object)"MAP_STYLES", null, null));
                }
            }
        });
        JScrollPane styleScrollPane = new JScrollPane(styleEditorPanel, 22, 31);
        UITools.setScrollbarIncrement((JScrollPane)styleScrollPane);
        Box resisableTabs = new CollapseableBoxBuilder("dialog_styleScrollPaneVisible").createBox((Component)styleScrollPane, JResizer.Direction.RIGHT);
        userInputListenerFactory.addToolBar("/format", 2, (JComponent)resisableTabs);
        modeController.addExtension(MUIFactory.class, new MUIFactory());
        Set emptySet = Collections.emptySet();
        modeController.updateMenus("/xml/stylemodemenu.xml", emptySet);
        this.modeController = null;
        return controller;
    }

    public static void install() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new EditStylesAction());
    }

    public void setExtensionInstaller(ExtensionInstaller extentionInstaller) {
        this.extentionInstaller = extentionInstaller;
    }
}

