/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.filemode;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.JToolbarComponentBuilder;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.filemode.CenterAction;
import org.freeplane.features.map.filemode.FMapController;
import org.freeplane.features.map.filemode.OpenPathAction;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.filemode.FModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.text.TextController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.ui.UserInputListenerFactory;

public class FModeControllerFactory {
    private static FModeController modeController;

    public static FModeController createModeController() {
        final Controller controller = Controller.getCurrentController();
        modeController = new FModeController(controller);
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory((ModeController)modeController);
        modeController.setUserInputListenerFactory((IUserInputListenerFactory)userInputListenerFactory);
        controller.addModeController((ModeController)modeController);
        controller.selectModeForBuild((ModeController)modeController);
        ClipboardControllers.install((ClipboardControllers)new ClipboardControllers());
        new FMapController(modeController);
        UrlManager.install((UrlManager)new UrlManager());
        MapIO.install((ModeController)modeController);
        new IconController((ModeController)modeController).install((ModeController)modeController);
        NodeStyleController.install((NodeStyleController)new NodeStyleController((ModeController)modeController));
        EdgeController.install((EdgeController)new EdgeController((ModeController)modeController));
        new TextController((ModeController)modeController).install((ModeController)modeController);
        LinkController.install((LinkController)new LinkController((ModeController)modeController));
        CloudController.install((CloudController)new CloudController((ModeController)modeController));
        LocationController.install((LocationController)new LocationController());
        LogicalStyleController.install((LogicalStyleController)new LogicalStyleController((ModeController)modeController));
        MapStyle.install((boolean)true);
        NodeStyleController.getController().shapeHandlers.addGetter(new Integer(0), (IPropertyHandler)new IPropertyHandler<NodeGeometryModel, NodeModel>(){

            public NodeGeometryModel getProperty(NodeModel node, LogicalStyleController.StyleOption option, NodeGeometryModel currentValue) {
                return NodeGeometryModel.FORK;
            }
        });
        modeController.addAction(new CenterAction());
        modeController.addAction(new OpenPathAction());
        userInputListenerFactory.setNodePopupMenu(new JPopupMenu());
        FreeplaneToolBar toolBar = new FreeplaneToolBar("main_toolbar", 0);
        UIComponentVisibilityDispatcher.install((JComponent)toolBar, (String)"toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, (JComponent)toolBar);
        userInputListenerFactory.addToolBar("/filter_toolbar", FilterController.TOOLBAR_SIDE, FilterController.getCurrentFilterController().getFilterToolbar());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        modeController.addUiBuilder(PhaseProcessor.Phase.UI, "main_toolbar_zoom", (EntryVisitor)new JToolbarComponentBuilder(new ComponentProvider(){

            public Component createComponent(Entry entry) {
                return controller.getMapViewManager().createZoomBox();
            }
        }));
        NodeHistory.install((ModeController)modeController);
        return modeController;
    }
}

