/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EnumToStringMapper;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class EdgeStyleControlGroup
implements ControlGroup {
    private static final String EDGE_STYLE = "edgestyle";
    private static final String[] EDGE_STYLES = EnumToStringMapper.getStringValuesOf(EdgeStyle.class, EdgeStyle.values().length - 1);
    private RevertingProperty mSetEdgeStyle;
    private ComboProperty mEdgeStyle;
    private EdgeStyleChangeListener propertyChangeListener;

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetEdgeStyle = new RevertingProperty();
        this.mEdgeStyle = new ComboProperty(EDGE_STYLE, EDGE_STYLES);
        this.propertyChangeListener = new EdgeStyleChangeListener(this.mSetEdgeStyle, (IPropertyControl)this.mEdgeStyle);
        this.mSetEdgeStyle.addPropertyChangeListener(this.propertyChangeListener);
        this.mEdgeStyle.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mEdgeStyle.appendToForm(formBuilder);
        this.mSetEdgeStyle.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class EdgeStyleChangeListener
    extends ControlGroupChangeListener {
        public EdgeStyleChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setStyle(node, enabled ? EdgeStyle.getStyle((String)EdgeStyleControlGroup.this.mEdgeStyle.getValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            EdgeController edgeController = EdgeController.getController();
            EdgeModel edgeModel = EdgeModel.getModel((NodeModel)node);
            EdgeStyle style = edgeModel != null ? edgeModel.getStyle() : null;
            EdgeStyle viewStyle = edgeController.getStyle(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            EdgeStyleControlGroup.this.mSetEdgeStyle.setValue(style != null);
            EdgeStyleControlGroup.this.mEdgeStyle.setValue(viewStyle.toString());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, EdgeStyleControlGroup.this.mSetEdgeStyle);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)EdgeStyleControlGroup.this.mEdgeStyle);
        }
    }
}

