/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.NextLineProperty;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.CloudShape;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class CloudColorShapeControlGroup
implements ControlGroup {
    static final String REVERT_CLOUD = "revert-cloud";
    static final String CLOUD_COLOR = "cloudcolor";
    static final String CLOUD_SHAPE = "cloudshape";
    private final RevertingProperty mSetCloud = new RevertingProperty("revert-cloud");
    private final ColorProperty mCloudColor = new ColorProperty("cloudcolor", ResourceController.getResourceController().getDefaultProperty("standardcloudcolor"), false);
    private final ComboProperty mCloudShape = ComboProperty.of((String)"cloudshape", CloudShape.class);
    private final CloudColorChangeListener mPropertyListener = new CloudColorChangeListener(this.mSetCloud, (IPropertyControl)this.mCloudColor, (IPropertyControl)this.mCloudShape);

    public CloudColorShapeControlGroup() {
        this.mSetCloud.addPropertyChangeListener(this.mPropertyListener);
        this.mCloudColor.addPropertyChangeListener((PropertyChangeListener)this.mPropertyListener);
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                IMapSelection selection;
                if ((propertyName.equals("standardcloudcolor") || propertyName.equals("standardcloudshape")) && (selection = Controller.getCurrentController().getSelection()) != null) {
                    NodeModel selected = selection.getSelected();
                    CloudColorShapeControlGroup.this.mPropertyListener.setStyle(selected);
                }
            }
        });
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.addCloudColorControl(formBuilder);
        new NextLineProperty().appendToForm(formBuilder);
        this.addCloudShapeControl(formBuilder);
    }

    private void addCloudColorControl(DefaultFormBuilder formBuilder) {
        this.mCloudColor.appendToForm(formBuilder);
        this.mSetCloud.appendToForm(formBuilder);
    }

    private void addCloudShapeControl(DefaultFormBuilder formBuilder) {
        this.mCloudShape.addPropertyChangeListener((PropertyChangeListener)this.mPropertyListener);
        this.mCloudShape.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.mPropertyListener.setStyle(node);
    }

    private class CloudColorChangeListener
    extends ControlGroupChangeListener {
        public CloudColorChangeListener(RevertingProperty mSet, IPropertyControl mProperty1, IPropertyControl mProperty2) {
            super(mSet, mProperty1, mProperty2);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MCloudController styleController = (MCloudController)Controller.getCurrentModeController().getExtension(CloudController.class);
            if (enabled) {
                styleController.setColor(node, CloudColorShapeControlGroup.this.mCloudColor.getColorValue());
                styleController.setShape(node, CloudShape.valueOf((String)CloudColorShapeControlGroup.this.mCloudShape.getValue()));
            } else {
                styleController.setCloud(node, false);
            }
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            CloudController cloudController = CloudController.getController();
            CloudModel cloudModel = CloudModel.getModel((NodeModel)node);
            Color viewCloudColor = cloudController.getColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            CloudColorShapeControlGroup.this.mSetCloud.setValue(cloudModel != null);
            CloudColorShapeControlGroup.this.mCloudColor.setColorValue(viewCloudColor);
            CloudShape viewCloudShape = cloudController.getShape(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            CloudColorShapeControlGroup.this.mCloudShape.setValue(viewCloudShape.name());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, CloudColorShapeControlGroup.this.mSetCloud);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)CloudColorShapeControlGroup.this.mCloudColor);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)CloudColorShapeControlGroup.this.mCloudShape);
        }
    }
}

