/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.SetBooleanMapPropertyAction;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.styles.mindmapmode.AssignStyleAction;
import org.freeplane.features.styles.mindmapmode.CopyMapStylesAction;
import org.freeplane.features.styles.mindmapmode.CopyStyleExtensionsAction;
import org.freeplane.features.styles.mindmapmode.ManageAssociatedMindMapsAction;
import org.freeplane.features.styles.mindmapmode.ManageMapConditionalStylesAction;
import org.freeplane.features.styles.mindmapmode.ManageNodeConditionalStylesAction;
import org.freeplane.features.styles.mindmapmode.MapBackgroundColorAction;
import org.freeplane.features.styles.mindmapmode.NewUserStyleFromSelectionAction;
import org.freeplane.features.styles.mindmapmode.RedefineStyleAction;
import org.freeplane.features.styles.mindmapmode.RedefineStyleUpdateTemplateAction;
import org.freeplane.features.styles.mindmapmode.ReplaceMapStylesAction;
import org.freeplane.features.styles.mindmapmode.ResetNewNodeStyleAction;
import org.freeplane.features.styles.mindmapmode.ResetStyleAction;
import org.freeplane.features.styles.mindmapmode.SetNewNodeStyleAction;
import org.freeplane.features.styles.mindmapmode.UseCurrentStyleForNewNodesAction;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.features.filepreview.MapBackgroundClearAction;
import org.freeplane.view.swing.features.filepreview.MapBackgroundImageAction;

public class MLogicalStyleController
extends LogicalStyleController {
    private static final String STYLE_ACTIONS = "styleActions";
    private static final String NEW_NODE_STYLE_ACTIONS = "newNodeStyleActions";
    private final List<AFreeplaneAction> actions;
    private final ModeController modeController;

    public MLogicalStyleController(final ModeController modeController) {
        super(modeController);
        this.modeController = modeController;
        modeController.getMapController().addUINodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                if (event.getProperty() == NodeProperty.CONDITIONAL_STYLES) {
                    return;
                }
                NodeModel node = event.getNode();
                ConditionalStyleModel mapStyles = MapStyleModel.getExtension((MapModel)node.getMap()).getConditionalStyleModel();
                if (mapStyles.dependsOnCondition(ICondition::checksDescendants)) {
                    this.delayedRefreshParent(node, true);
                } else if (mapStyles.dependsOnCondition(ICondition::checksChildren)) {
                    this.delayedRefreshParent(node, false);
                }
                if (mapStyles.dependsOnCondition(ICondition::checksAncestors)) {
                    this.delayedRefreshChildren(node, true);
                } else if (mapStyles.dependsOnCondition(ICondition::checksParent)) {
                    this.delayedRefreshChildren(node, false);
                } else {
                    for (NodeModel child : node.getChildren()) {
                        ConditionalStyleModel nodeStyles = (ConditionalStyleModel)node.getExtension(ConditionalStyleModel.class);
                        if (nodeStyles == null || !nodeStyles.dependsOnCondition(ICondition::checksParent)) continue;
                        modeController.getMapController().delayedNodeRefresh(child, (Object)NodeProperty.CONDITIONAL_STYLES, null, null);
                    }
                }
            }

            private void delayedRefreshChildren(NodeModel node, boolean withDescendants) {
                for (NodeModel child : node.getChildren()) {
                    if (!child.hasViewers()) continue;
                    MLogicalStyleController.this.modeController.getMapController().delayedNodeRefresh(child, (Object)NodeProperty.CONDITIONAL_STYLES, null, null);
                    if (!withDescendants) continue;
                    this.delayedRefreshChildren(child, true);
                }
            }

            private void delayedRefreshParent(NodeModel node, boolean withAncestors) {
                NodeModel parent = node.getParentNode();
                if (parent != null) {
                    if (withAncestors) {
                        this.delayedRefreshParent(parent, true);
                    }
                    if (parent.hasViewers()) {
                        MLogicalStyleController.this.modeController.getMapController().delayedNodeRefresh(parent, (Object)NodeProperty.CONDITIONAL_STYLES, null, null);
                    }
                }
            }
        });
        this.actions = new LinkedList<AFreeplaneAction>();
    }

    public void initS() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new ManageNodeConditionalStylesAction());
    }

    public void initM() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.getMapController().addUINodeChangeListener((INodeChangeListener)new StyleRemover());
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier());
        modeController.addAction((AFreeplaneAction)new RedefineStyleAction());
        modeController.addAction((AFreeplaneAction)new RedefineStyleUpdateTemplateAction());
        modeController.addAction((AFreeplaneAction)new NewUserStyleFromSelectionAction());
        modeController.addAction((AFreeplaneAction)new ManageMapConditionalStylesAction());
        modeController.addAction((AFreeplaneAction)new ManageNodeConditionalStylesAction());
        modeController.addAction((AFreeplaneAction)new CopyStyleExtensionsAction());
        if (modeController.getModeName().equals("MindMap")) {
            modeController.addAction((AFreeplaneAction)new MapBackgroundColorAction());
            modeController.addAction((AFreeplaneAction)new MapBackgroundImageAction());
            modeController.addAction((AFreeplaneAction)new MapBackgroundClearAction());
            modeController.addAction((AFreeplaneAction)new SetBooleanMapPropertyAction("fit_to_viewport"));
            modeController.addAction((AFreeplaneAction)new CopyMapStylesAction());
            modeController.addAction((AFreeplaneAction)new ReplaceMapStylesAction());
            modeController.addAction((AFreeplaneAction)new ManageAssociatedMindMapsAction());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            StyleMenuBuilder styleBuilder = new StyleMenuBuilder(AssignStyleAction::new);
            styleBuilder.addStyleAction((AFreeplaneAction)new ResetStyleAction());
            modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "style_actions", (EntryVisitor)styleBuilder, (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)modeController));
            StyleMenuBuilder newNodeStyleBuilder = new StyleMenuBuilder(SetNewNodeStyleAction::new);
            newNodeStyleBuilder.addStyleAction(new UseCurrentStyleForNewNodesAction());
            newNodeStyleBuilder.addStyleAction(new ResetNewNodeStyleAction());
            modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "new_node_style_actions", (EntryVisitor)newNodeStyleBuilder, (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)modeController));
            final IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            Controller.getCurrentController().getMapViewManager().addMapSelectionListener(new IMapSelectionListener(){

                public void afterMapChange(MapModel oldMap, MapModel newMap) {
                    userInputListenerFactory.rebuildMenus(MLogicalStyleController.STYLE_ACTIONS);
                    userInputListenerFactory.rebuildMenus(MLogicalStyleController.NEW_NODE_STYLE_ACTIONS);
                }
            });
            MapController mapController = modeController.getMapController();
            mapController.addUIMapChangeListener(new IMapChangeListener(){

                public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
                }

                public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
                }

                public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
                }

                public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
                }

                public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
                }

                public void mapChanged(MapChangeEvent event) {
                    if (event.getProperty().equals("MAP_STYLES")) {
                        userInputListenerFactory.rebuildMenus(MLogicalStyleController.STYLE_ACTIONS);
                        userInputListenerFactory.rebuildMenus(MLogicalStyleController.NEW_NODE_STYLE_ACTIONS);
                    }
                }
            });
            mapController.addNodeSelectionListener(new INodeSelectionListener(){

                public void onSelect(NodeModel node) {
                    MLogicalStyleController.this.selectActions();
                }

                public void onDeselect(NodeModel node) {
                }
            });
        }
    }

    public void setStyle(final NodeModel node, final IStyle style) {
        final ModeController modeController = Controller.getCurrentModeController();
        final IStyle oldStyle = LogicalStyleModel.getStyle((NodeModel)node);
        if (oldStyle != null && oldStyle.equals(style) || oldStyle == style) {
            modeController.getMapController().nodeChanged(node, LogicalStyleModel.class, (Object)oldStyle, (Object)style);
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setStyle";
            }

            public void act() {
                this.changeStyle(modeController, node, oldStyle, style);
            }

            public void undo() {
                this.changeStyle(modeController, node, style, oldStyle);
            }

            private void changeStyle(ModeController modeController2, NodeModel node2, IStyle oldStyle2, IStyle style2) {
                if (style2 != null) {
                    LogicalStyleModel model = LogicalStyleModel.createExtension((NodeModel)node2);
                    model.setStyle(style2);
                } else {
                    node2.removeExtension(LogicalStyleModel.class);
                }
                modeController2.getMapController().nodeChanged(node2, LogicalStyleModel.class, (Object)oldStyle2, (Object)style2);
                MLogicalStyleController.this.selectActions();
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void copyStyleExtensions(IStyle style, NodeModel target) {
        MTextController textController = MTextController.getController();
        MapStyleModel extension = MapStyleModel.getExtension((MapModel)target.getMap());
        NodeModel styleNode = extension.getStyleNode(style);
        if (styleNode != null) {
            String noteText;
            MAttributeController attributeController = MAttributeController.getController();
            attributeController.copyAttributesToNode(styleNode, target);
            String detailTextText = DetailModel.getDetailText((NodeModel)styleNode);
            if (detailTextText != null) {
                textController.setDetails(target, detailTextText);
            }
            if ((noteText = NoteModel.getNoteText((NodeModel)styleNode)) != null) {
                MNoteController noteController = (MNoteController)NoteController.getController();
                noteController.setNoteText(target, noteText);
            }
        }
    }

    void selectActions() {
        for (AFreeplaneAction action : this.actions) {
            action.setSelected();
        }
    }

    public void setStyle(IStyle style) {
        ModeController modeController = Controller.getCurrentModeController();
        if (MapStyleModel.NEW_STYLE.equals(style)) {
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (selection == null) {
                return;
            }
            IStyle newStyle = this.addNewUserStyle(false);
            if (newStyle == null) {
                NodeModel node = selection.getSelected();
                IStyle oldStyle = LogicalStyleModel.getStyle((NodeModel)node);
                modeController.getMapController().nodeChanged(node, LogicalStyleModel.class, (Object)oldStyle, (Object)oldStyle);
            } else {
                this.setStyle(newStyle);
            }
            return;
        }
        List selectedNodes = modeController.getMapController().getSelectedNodes();
        for (NodeModel selected : selectedNodes) {
            this.setStyle(selected, style);
        }
    }

    public void moveConditionalStyleDown(MapModel map, final ConditionalStyleModel conditionalStyleModel, final int index) {
        int maxIndex = conditionalStyleModel.getStyleCount() - 1;
        if (index < 0 || index >= maxIndex) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveConditionalStyleDown";
            }

            public void act() {
                MLogicalStyleController.super.moveConditionalStyleDown(conditionalStyleModel, index);
            }

            public void undo() {
                MLogicalStyleController.super.moveConditionalStyleUp(conditionalStyleModel, index + 1);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void moveConditionalStyleUp(MapModel map, final ConditionalStyleModel conditionalStyleModel, final int index) {
        int maxIndex = conditionalStyleModel.getStyleCount() - 1;
        if (index <= 0 || index > maxIndex) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveConditionalStyleUp";
            }

            public void act() {
                MLogicalStyleController.super.moveConditionalStyleUp(conditionalStyleModel, index);
            }

            public void undo() {
                MLogicalStyleController.super.moveConditionalStyleDown(conditionalStyleModel, index - 1);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public static MLogicalStyleController getController() {
        return (MLogicalStyleController)LogicalStyleController.getController();
    }

    public void addConditionalStyle(MapModel map, ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        AddConditionalStyleActor actor = new AddConditionalStyleActor(conditionalStyleModel, isActive, condition, style, isLast);
        Controller.getCurrentModeController().execute((IActor)actor, map);
    }

    public ConditionalStyleModel.Item removeConditionalStyle(MapModel map, ConditionalStyleModel conditionalStyleModel, int index) {
        RemoveConditionalStyleActor actor = new RemoveConditionalStyleActor(conditionalStyleModel, index);
        Controller.getCurrentModeController().execute((IActor)actor, map);
        return actor.item;
    }

    public TableModel getConditionalStyleModelAsTableModel(final MapModel map, final ConditionalStyleModel conditionalStyleModel) {
        return new TableModel(){
            private final TableModel tableModel;
            {
                this.tableModel = conditionalStyleModel.asTableModel();
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
                this.tableModel.addTableModelListener(l);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.tableModel.getColumnClass(columnIndex);
            }

            @Override
            public int getColumnCount() {
                return this.tableModel.getColumnCount();
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.tableModel.getColumnName(columnIndex);
            }

            @Override
            public int getRowCount() {
                return this.tableModel.getRowCount();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return this.tableModel.getValueAt(rowIndex, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.tableModel.isCellEditable(rowIndex, columnIndex);
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
                this.tableModel.removeTableModelListener(l);
            }

            @Override
            public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
                final Object oldValue = this.tableModel.getValueAt(rowIndex, columnIndex);
                if (aValue == oldValue || aValue != null && aValue.equals(oldValue)) {
                    return;
                }
                IActor actor = new IActor(){

                    public String getDescription() {
                        return "set conditional style table cell value";
                    }

                    public void act() {
                        tableModel.setValueAt(aValue, rowIndex, columnIndex);
                    }

                    public void undo() {
                        tableModel.setValueAt(oldValue, rowIndex, columnIndex);
                    }
                };
                Controller.getCurrentModeController().execute(actor, map);
            }
        };
    }

    IStyle addNewUserStyle(boolean copyStyleFromSelected) {
        NodeModel userStyleParentNode;
        String styleName = JOptionPane.showInputDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), TextUtils.getText((String)"enter_new_style_name"), "");
        if (styleName == null || styleName.isEmpty()) {
            return null;
        }
        final MapModel map = Controller.getCurrentController().getMap();
        final MapStyleModel styleModel = MapStyleModel.getExtension((MapModel)map);
        MapModel styleMap = styleModel.getStyleMap();
        IStyle newStyle = StyleFactory.create((String)styleName);
        if (null != styleModel.getStyleNode(newStyle)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"style_already_exists"));
            return null;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        final NodeModel newNode = new NodeModel(styleMap);
        newNode.setUserObject((Object)newStyle);
        if (copyStyleFromSelected) {
            NodeModel styleSourceNode = Controller.getCurrentController().getSelection().getSelected();
            ArrayList styles = new ArrayList(this.getStyles(styleSourceNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
            for (int i = styles.size() - 1; i >= 0; --i) {
                NodeModel styleNode;
                IStyle style = (IStyle)styles.get(i);
                if (MapStyleModel.DEFAULT_STYLE.equals(style) || (styleNode = styleModel.getStyleNode(style)) == null) continue;
                Controller.getCurrentModeController().copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, styleNode, newNode);
            }
            Controller.getCurrentModeController().copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, styleSourceNode, newNode);
            Controller.getCurrentModeController().copyExtensions((Object)MIconController.Keys.ICONS, styleSourceNode, newNode);
        }
        if ((userStyleParentNode = styleModel.getStyleNodeGroup(styleMap, "styles.user-defined")) == null) {
            userStyleParentNode = new NodeModel(styleMap);
            userStyleParentNode.setUserObject((Object)new StyleTranslatedObject("styles.user-defined"));
            mapController.insertNode(userStyleParentNode, styleMap.getRootNode(), false);
        }
        mapController.insertNode(newNode, userStyleParentNode, false);
        mapController.select(newNode);
        IActor actor = new IActor(){

            public void undo() {
                styleModel.removeStyleNode(newNode);
                MLogicalStyleController.this.refreshMap(map);
            }

            public String getDescription() {
                return "NewStyle";
            }

            public void act() {
                styleModel.addStyleNode(newNode);
                MLogicalStyleController.this.refreshMap(map);
            }
        };
        Controller.getCurrentModeController().execute(actor, styleMap);
        return newStyle;
    }

    private static class StyleRemover
    implements INodeChangeListener {
        public void nodeChanged(NodeChangeEvent event) {
            ModeController modeController = Controller.getCurrentModeController();
            NodeModel node = event.getNode();
            MapModel map = node.getMap();
            if (modeController == null || map.isUndoActionRunning()) {
                return;
            }
            if (!event.getProperty().equals(LogicalStyleModel.class)) {
                return;
            }
            IStyle styleKey = (IStyle)event.getNewValue();
            MapStyleModel mapStyles = MapStyleModel.getExtension((MapModel)map);
            NodeModel styleNode = mapStyles.getStyleNode(styleKey);
            if (styleNode == null) {
                return;
            }
            modeController.undoableRemoveExtensions((Object)LogicalStyleKeys.NODE_STYLE, node, styleNode);
        }
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            LogicalStyleModel fromStyle = (LogicalStyleModel)from.getExtension(LogicalStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            LogicalStyleModel toStyle = LogicalStyleModel.createExtension((NodeModel)to);
            toStyle.setStyle(fromStyle.getStyle());
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            from.removeExtension(LogicalStyleModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            LogicalStyleModel whichStyle = (LogicalStyleModel)which.getExtension(LogicalStyleModel.class);
            if (whichStyle == null) {
                return;
            }
            LogicalStyleModel fromStyle = (LogicalStyleModel)from.getExtension(LogicalStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension((IExtension)fromStyle);
        }
    }

    class StyleMenuBuilder
    implements EntryVisitor {
        private final Function<IStyle, AFreeplaneAction> styleActionFactory;
        private final List<AFreeplaneAction> additionalActions;

        StyleMenuBuilder(Function<IStyle, AFreeplaneAction> actionFactory) {
            this.styleActionFactory = actionFactory;
            this.additionalActions = new ArrayList<AFreeplaneAction>();
        }

        boolean addStyleAction(AFreeplaneAction e) {
            return this.additionalActions.add(e);
        }

        public void visit(Entry target) {
            this.addStyleMenu(target);
        }

        public boolean shouldSkipChildren(Entry entry) {
            return true;
        }

        private void addStyleMenu(Entry target) {
            MapModel map = Controller.getCurrentController().getMap();
            if (map == null) {
                return;
            }
            MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)map);
            if (mapStyleModel == null) {
                return;
            }
            MLogicalStyleController.this.actions.clear();
            EntryAccessor entryAccessor = new EntryAccessor();
            for (AFreeplaneAction action : this.additionalActions) {
                AFreeplaneAction addedAction;
                if (action == (addedAction = MLogicalStyleController.this.modeController.addActionIfNotAlreadySet(action))) {
                    MLogicalStyleController.this.actions.add(action);
                }
                entryAccessor.addChildAction(target, addedAction);
            }
            for (IStyle style : mapStyleModel.getNodeStyles()) {
                AFreeplaneAction action;
                AFreeplaneAction newAction = this.styleActionFactory.apply(style);
                if (newAction == (action = MLogicalStyleController.this.modeController.addActionIfNotAlreadySet(newAction))) {
                    MLogicalStyleController.this.actions.add(newAction);
                }
                entryAccessor.addChildAction(target, action);
            }
        }
    }

    private final class AddConditionalStyleActor
    implements IActor {
        private final ConditionalStyleModel conditionalStyleModel;
        private final boolean isActive;
        private final ASelectableCondition condition;
        private final IStyle style;
        private boolean isLast;

        public AddConditionalStyleActor(ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
            this.conditionalStyleModel = conditionalStyleModel;
            this.isActive = isActive;
            this.condition = condition;
            this.style = style;
            this.isLast = isLast;
        }

        public void undo() {
            int index = this.conditionalStyleModel.getStyleCount() - 1;
            MLogicalStyleController.super.removeConditionalStyle(this.conditionalStyleModel, index);
        }

        public String getDescription() {
            return "AddConditionalStyle";
        }

        public void act() {
            MLogicalStyleController.super.addConditionalStyle(this.conditionalStyleModel, this.isActive, this.condition, this.style, this.isLast);
        }
    }

    private final class RemoveConditionalStyleActor
    implements IActor {
        private final int index;
        private final ConditionalStyleModel conditionalStyleModel;
        ConditionalStyleModel.Item item = null;

        private RemoveConditionalStyleActor(ConditionalStyleModel conditionalStyleModel, int index) {
            this.index = index;
            this.conditionalStyleModel = conditionalStyleModel;
        }

        public void undo() {
            MLogicalStyleController.super.insertConditionalStyle(this.conditionalStyleModel, this.index, this.item.isActive(), this.item.getCondition(), this.item.getStyle(), this.item.isLast());
        }

        public String getDescription() {
            return "RemoveConditionalStyle";
        }

        public void act() {
            this.item = MLogicalStyleController.super.removeConditionalStyle(this.conditionalStyleModel, this.index);
        }
    }

    public static enum NodeProperty {
        CONDITIONAL_STYLES;

    }
}

