/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.note.mindmapmode.NotePanel;
import org.freeplane.features.text.TextController;

final class NoteManager
implements INodeSelectionListener,
IMapSelectionListener {
    private boolean ignoreEditorUpdate;
    NodeModel node;
    final MNoteController noteController;

    public NoteManager(MNoteController noteController) {
        this.noteController = noteController;
    }

    public void onDeselect(NodeModel node) {
        NotePanel notePanel = this.noteController.getNotePanel();
        if (notePanel == null) {
            return;
        }
        notePanel.removeDocumentListener();
        this.saveNote(node);
        notePanel.stopEditing();
        this.node = null;
    }

    public void onSelect(NodeModel node) {
        this.node = node;
        this.updateEditor();
    }

    void updateEditor() {
        block11: {
            final NotePanel notePanel = this.noteController.getNotePanel();
            if (notePanel == null) {
                return;
            }
            if (this.node == null) {
                return;
            }
            String note = this.node != null ? NoteModel.getNoteText((NodeModel)this.node) : null;
            TextController textController = TextController.getController();
            this.noteController.setDefaultStyle(this.node);
            notePanel.updateBaseUrl(this.node.getMap().getURL());
            if (note != null) {
                try {
                    Object transformedContent = textController.getTransformedObject(this.node, (Object)NoteModel.getNote((NodeModel)this.node), (Object)note);
                    Icon icon = textController.getIcon(transformedContent);
                    if (icon != null) {
                        notePanel.setViewedImage(icon);
                        break block11;
                    }
                    if (transformedContent == note) {
                        if (this.ignoreEditorUpdate) {
                            return;
                        }
                        notePanel.removeDocumentListener();
                        notePanel.setEditedContent(note);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                notePanel.installDocumentListener();
                            }
                        });
                        break block11;
                    }
                    notePanel.setViewedContent(transformedContent.toString());
                }
                catch (Throwable e) {
                    LogUtils.warn((String)e.getMessage());
                    notePanel.setViewedContent(TextUtils.format((String)"MainView.errorUpdateText", (Object[])new Object[]{note, e.getLocalizedMessage()}));
                }
            } else {
                String noteContentType = this.noteController.getNoteContentType(this.node);
                if ("auto".equals(noteContentType) || "html".equals(noteContentType)) {
                    notePanel.setEditedContent("");
                } else {
                    notePanel.setViewedContent("");
                }
            }
        }
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        if (newMap == null) {
            this.node = null;
            NotePanel notePanel = this.noteController.getNotePanel();
            if (notePanel != null) {
                notePanel.setViewedContent("");
            }
        }
    }

    void saveNote(NodeModel node) {
        if (this.node != node) {
            return;
        }
        this.saveNote();
    }

    void saveNote() {
        if (this.node == null) {
            return;
        }
        NotePanel notePanel = this.noteController.getNotePanel();
        if (notePanel != null) {
            notePanel.saveNote();
        }
    }

    NodeModel getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNote(String text) {
        boolean isHtml = HtmlUtils.isHtml((String)text);
        boolean editorContentEmpty = isHtml && HtmlUtils.isEmpty((String)text) || !isHtml && text.trim().isEmpty();
        Controller.getCurrentModeController().getMapController().removeNodeSelectionListener((INodeSelectionListener)this);
        try {
            this.ignoreEditorUpdate = true;
            if (editorContentEmpty) {
                this.noteController.setNoteText(this.node, null);
            } else {
                String oldText = this.noteController.getNoteText(this.node);
                if (null == oldText) {
                    this.noteController.setNoteText(this.node, text);
                } else if (isHtml) {
                    String oldTextWithoutHead = NotePanel.HEAD.matcher(oldText).replaceFirst("");
                    if (!oldTextWithoutHead.trim().equals(text.trim())) {
                        this.noteController.setNoteText(this.node, text);
                    }
                } else {
                    this.noteController.setNoteText(this.node, text);
                }
            }
        }
        finally {
            this.ignoreEditorUpdate = false;
        }
        Controller.getCurrentModeController().getMapController().addNodeSelectionListener((INodeSelectionListener)this);
    }
}

