/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode.clipboard;

import java.io.File;
import java.io.IOException;

class TargetFileCreator {
    TargetFileCreator() {
    }

    File createTargetFile(File mindmapFile, String prototypeName) throws IOException {
        String mapFileNameWithExtension = mindmapFile.getName();
        String mapFileName = this.removeExtension(mapFileNameWithExtension);
        File mindMapDirectory = mindmapFile.getParentFile();
        File mapFilesDirectory = new File(mindMapDirectory, mapFileName + "_files");
        if (!mapFilesDirectory.exists() || mapFilesDirectory.isDirectory()) {
            File target;
            if (prototypeName.contains(".") && !(target = new File(mapFilesDirectory, prototypeName)).exists()) {
                return target;
            }
            String sourceFileName = this.removeExtension(prototypeName);
            String fileNameTemplate = sourceFileName + "_";
            while (fileNameTemplate.length() < 3) {
                fileNameTemplate = fileNameTemplate + '_';
            }
            mapFilesDirectory.mkdir();
            File targetFile = File.createTempFile(fileNameTemplate, "." + this.getExtension(prototypeName), mapFilesDirectory);
            return targetFile;
        }
        String sourceFileName = this.removeExtension(prototypeName);
        String fileNameTemplate = mapFileName + "_" + sourceFileName + "_";
        while (fileNameTemplate.length() < 3) {
            fileNameTemplate = fileNameTemplate + '_';
        }
        File targetFile = File.createTempFile(fileNameTemplate, "." + this.getExtension(prototypeName), mindMapDirectory);
        return targetFile;
    }

    private String removeExtension(String fileNameWithExtension) {
        int extensionIndex = fileNameWithExtension.lastIndexOf(46);
        if (extensionIndex >= 0) {
            return fileNameWithExtension.substring(0, extensionIndex);
        }
        return fileNameWithExtension;
    }

    private String getExtension(String fileNameWithExtension) {
        return fileNameWithExtension.substring(fileNameWithExtension.lastIndexOf(46) + 1);
    }
}

