/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class ConnectorProxy
extends AbstractProxy<ConnectorModel>
implements Proxy.Connector {
    ConnectorProxy(ConnectorModel connector, ScriptContext scriptContext) {
        super(connector, scriptContext);
    }

    public String getShape() {
        return this.getLinkController().getShape(this.getConnector()).name();
    }

    public void setShape(String shapeName) {
        ConnectorShape shape = ConnectorShape.valueOf((String)shapeName);
        this.setShape(shape);
    }

    public void setShape(ConnectorShape shape) {
        this.getLinkController().setShape(this.getConnector(), Optional.of(shape));
    }

    public String getLabelFontFamily() {
        return this.getLinkController().getLabelFontFamily(this.getConnector());
    }

    public void setLabelFontFamily(String font) {
        this.getLinkController().setLabelFontFamily(this.getConnector(), Optional.of(font));
    }

    public int getLabelFontSize() {
        return this.getLinkController().getLabelFontSize(this.getConnector());
    }

    public void setLabelFontSize(int size) {
        this.getLinkController().setLabelFontSize(this.getConnector(), Optional.of(size));
    }

    public Color getColor() {
        return this.getLinkController().getColor(this.getConnector());
    }

    public void setColor(Color color) {
        this.getLinkController().setConnectorColor(this.getConnector(), Optional.of(color));
    }

    public int getOpacity() {
        return this.getLinkController().getOpacity(this.getConnector());
    }

    public void setOpacity(int opacity) {
        this.getLinkController().setOpacity(this.getConnector(), Optional.of(opacity));
    }

    public int getWidth() {
        return this.getLinkController().getWidth(this.getConnector());
    }

    public void setWidth(int width) {
        this.getLinkController().setWidth(this.getConnector(), Optional.of(width));
    }

    public int[] getDashArray() {
        return this.getLinkController().getDashArray(this.getConnector());
    }

    public void setDashArray(int[] dashArray) {
        this.getLinkController().setConnectorDashArray(this.getConnector(), Optional.of(dashArray != null ? dashArray : new int[]{}));
    }

    public String getColorCode() {
        return ColorUtils.colorToString((Color)this.getColor());
    }

    public void setColorCode(String rgbString) {
        this.setColor(ColorUtils.stringToColor((String)rgbString));
    }

    ConnectorModel getConnector() {
        return (ConnectorModel)this.getDelegate();
    }

    public boolean hasEndArrow() {
        return this.getEndArrow() == ArrowType.DEFAULT;
    }

    @Override
    @Deprecated
    public ArrowType getEndArrow() {
        return this.getLinkController().getArrows((ConnectorModel)this.getConnector()).end;
    }

    private MLinkController getLinkController() {
        return (MLinkController)LinkController.getController();
    }

    public String getMiddleLabel() {
        return this.getConnector().getMiddleLabel().orElse(null);
    }

    public Proxy.Node getSource() {
        return new NodeProxy(this.getConnector().getSource(), this.getScriptContext());
    }

    public String getSourceLabel() {
        return this.getConnector().getSourceLabel().orElse(null);
    }

    public boolean hasStartArrow() {
        return this.getStartArrow() == ArrowType.DEFAULT;
    }

    @Override
    @Deprecated
    public ArrowType getStartArrow() {
        return this.getLinkController().getArrows((ConnectorModel)this.getConnector()).start;
    }

    public Proxy.Node getTarget() {
        return new NodeProxy(this.getConnector().getTarget(), this.getScriptContext());
    }

    public String getTargetLabel() {
        return this.getConnector().getTargetLabel().orElse(null);
    }

    private void setEndArrowImpl(ArrowType arrowType) {
        ConnectorModel connector = this.getConnector();
        MLinkController linkController = this.getLinkController();
        linkController.changeArrowsOfArrowLink(connector, ConnectorArrows.of((ArrowType)linkController.getArrows((ConnectorModel)connector).start, (ArrowType)arrowType));
    }

    public void setEndArrow(boolean showArrow) {
        this.setEndArrowImpl(showArrow ? ArrowType.DEFAULT : ArrowType.NONE);
    }

    @Override
    @Deprecated
    public void setEndArrow(ArrowType arrowType) {
        this.setEndArrowImpl(arrowType);
    }

    public void setMiddleLabel(String label) {
        this.getLinkController().setMiddleLabel(this.getConnector(), label);
    }

    @Deprecated
    public void setSimulatesEdge(boolean simulatesEdge) {
        this.setShape(simulatesEdge ? ConnectorShape.EDGE_LIKE : ConnectorShape.CUBIC_CURVE);
    }

    public void setSourceLabel(String label) {
        this.getLinkController().setSourceLabel(this.getConnector(), label);
    }

    public void setStartArrow(boolean showArrow) {
        this.setStartArrowImpl(showArrow ? ArrowType.DEFAULT : ArrowType.NONE);
    }

    private void setStartArrowImpl(ArrowType arrowType) {
        ConnectorModel connector = this.getConnector();
        MLinkController linkController = this.getLinkController();
        linkController.changeArrowsOfArrowLink(connector, ConnectorArrows.of((ArrowType)arrowType, (ArrowType)linkController.getArrows((ConnectorModel)connector).end));
    }

    @Override
    @Deprecated
    public void setStartArrow(ArrowType arrowType) {
        this.setStartArrowImpl(arrowType);
    }

    public void setTargetLabel(String label) {
        this.getLinkController().setTargetLabel(this.getConnector(), label);
    }

    public boolean simulatesEdge() {
        return ConnectorShape.EDGE_LIKE.equals((Object)this.getConnector().getShape());
    }

    public List<Integer> getStartInclination() {
        Point startInclination = this.getConnector().getStartInclination();
        return startInclination != null ? ConnectorProxy.pointToList(startInclination) : null;
    }

    public void setInclination(List<Integer> startPoint, List<Integer> endPoint) {
        if (startPoint == null || startPoint.size() != 2 || endPoint == null || endPoint.size() != 2) {
            throw new IllegalArgumentException("start and end points must have 2 elements");
        }
        this.getLinkController().setArrowLinkEndPoints(this.getConnector(), this.listToPoint(startPoint), this.listToPoint(endPoint));
    }

    public List<Integer> getEndInclination() {
        Point endInclination = this.getConnector().getEndInclination();
        return endInclination != null ? ConnectorProxy.pointToList(endInclination) : null;
    }

    private Point listToPoint(List<Integer> point) {
        return new Point(point.get(0), point.get(1));
    }

    private static List<Integer> pointToList(Point point) {
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(point.x);
        result.add(point.y);
        return result;
    }
}

