/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.protocol.data;

import com.github.robtimus.net.protocol.data.Messages;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

final class MediaType {
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private static final String DEFAULT_MEDIA_TYPE = "text/plain;charset=US-ASCII";
    private static final Map<String, String> DEFAULT_PARAMETERS = Collections.singletonMap("charset", "US-ASCII");
    static final MediaType DEFAULT = new MediaType("text/plain;charset=US-ASCII", "text/plain", DEFAULT_PARAMETERS);
    private final String mediaType;
    private final String mimeType;
    private final Map<String, String> parameters;
    private final Map<String, String> parameterLookup;
    private static final String TOKEN = "[!-~&&[^()<>@,;:\\\\\"/\\[\\]?=]]";
    private static final Pattern MIME_TYPE_PATTERN = Pattern.compile("[!-~&&[^()<>@,;:\\\\\"/\\[\\]?=]]+/[!-~&&[^()<>@,;:\\\\\"/\\[\\]?=]]+");

    private MediaType(String mediaType, String mimeType, Map<String, String> parameters) {
        this.mediaType = mediaType;
        this.mimeType = mimeType;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.parameterLookup = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.parameterLookup.putAll(parameters);
    }

    static MediaType create(String mimeType, Map<String, String> parameters) {
        MediaType.validateMimeType(mimeType, 0, mimeType.length());
        String mediaType = MediaType.buildMediaType(mimeType, parameters);
        return new MediaType(mediaType, mimeType, new LinkedHashMap<String, String>(parameters));
    }

    private static String buildMediaType(String mimeType, Map<String, String> parameters) {
        StringBuilder mediaType = new StringBuilder();
        mediaType.append(mimeType);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            boolean containsSemicolon;
            mediaType.append(';').append(entry.getKey()).append('=');
            String value = entry.getValue();
            if (value == null) continue;
            boolean bl = containsSemicolon = value.indexOf(59) != -1;
            if (containsSemicolon) {
                mediaType.append('\"');
            }
            MediaType.appendValue(value, mediaType);
            if (!containsSemicolon) continue;
            mediaType.append('\"');
        }
        return mediaType.toString();
    }

    private static void appendValue(String value, StringBuilder mediaType) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\') {
                mediaType.append('\\');
            }
            mediaType.append(c);
        }
    }

    static MediaType parse(String type) {
        return MediaType.parse(type, 0, type.length());
    }

    static MediaType parse(String type, int start, int end) {
        int index = type.indexOf(59, start);
        if (MediaType.isNotFound(index, end)) {
            MediaType.validateMimeType(type, start, end);
            String mimeType = type.substring(start, end);
            return new MediaType(mimeType, mimeType, Collections.emptyMap());
        }
        int mimeTypeStart = start;
        int mimeTypeEnd = index;
        MediaType.validateMimeType(type, mimeTypeStart, mimeTypeEnd);
        int paramStart = MediaType.skipStartingWhitespace(type, index + 1, end);
        int paramEnd = end;
        Map<String, String> parameters = MediaType.parseParameters(type, paramStart, paramEnd);
        String mimeType = type.substring(mimeTypeStart, mimeTypeEnd);
        return new MediaType(type, mimeType, parameters);
    }

    private static void validateMimeType(String mimeType, int start, int end) {
        if (!MIME_TYPE_PATTERN.matcher(mimeType).region(start, end).matches()) {
            throw new IllegalArgumentException(Messages.mediaType.invalidMimeType.get(mimeType));
        }
    }

    private static Map<String, String> parseParameters(String paramString, int start, int end) {
        if (start == end) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        int index = start;
        while (index < end) {
            index = MediaType.parseNextParameter(paramString, index, end, parameters);
            index = MediaType.skipStartingWhitespace(paramString, index, end);
        }
        return parameters;
    }

    private static int parseNextParameter(String paramString, int start, int end, Map<String, String> parameters) {
        boolean quote = false;
        boolean backslash = false;
        int nameEnd = MediaType.getNameEnd(paramString, start, end);
        String name = paramString.substring(start, nameEnd);
        int valueStart = nameEnd;
        if (valueStart < end && paramString.charAt(valueStart) == '=') {
            ++valueStart;
        }
        StringBuilder value = new StringBuilder(end - valueStart);
        block5: for (int i = valueStart; i < end; ++i) {
            char c = paramString.charAt(i);
            switch (c) {
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        value.append(c);
                        continue block5;
                    }
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (backslash) {
                        backslash = false;
                        value.append(c);
                        continue block5;
                    }
                    backslash = true;
                    continue block5;
                }
                case ';': {
                    if (!quote) {
                        parameters.put(name, value.toString());
                        return i + 1;
                    }
                    value.append(c);
                    continue block5;
                }
                default: {
                    value.append(c);
                }
            }
        }
        parameters.put(name, value.toString());
        return end;
    }

    private static int getNameEnd(String params, int start, int end) {
        int indexOfEquals = params.indexOf(61, start);
        int indexOfSemicolon = params.indexOf(59, start);
        if (MediaType.isNotFound(indexOfEquals, end) && MediaType.isNotFound(indexOfSemicolon, end)) {
            return end;
        }
        if (MediaType.isNotFound(indexOfEquals, end)) {
            return indexOfSemicolon;
        }
        if (MediaType.isNotFound(indexOfSemicolon, end)) {
            return indexOfEquals;
        }
        return Math.min(indexOfEquals, indexOfSemicolon);
    }

    private static boolean isNotFound(int index, int end) {
        return index == -1 || index >= end;
    }

    private static int skipStartingWhitespace(String s, int index, int end) {
        int i;
        for (i = index; i < end && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return i;
    }

    String getMimeType() {
        return this.mimeType;
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    String getCharset() {
        return this.parameterLookup.get("charset");
    }

    public String toString() {
        return this.mediaType;
    }
}

