/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.protocol.data;

import com.github.robtimus.net.protocol.data.MediaType;
import com.github.robtimus.net.protocol.data.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;

public class DataURLConnection
extends URLConnection {
    private final MediaType mediaType;
    private final byte[] data;
    private InputStream inputStream;

    DataURLConnection(URL url, MediaType mediaType, byte[] data) {
        super(url);
        this.mediaType = mediaType;
        this.data = data;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public int getContentLength() {
        return this.data.length;
    }

    @Override
    public long getContentLengthLong() {
        return this.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.mediaType.toString();
    }

    @Override
    public String getContentEncoding() {
        return this.mediaType.getCharset();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException(Messages.dataURLConnection.getInputStream.falseDoInput.get());
        }
        if (this.inputStream == null) {
            this.inputStream = new ByteArrayInputStream(this.data);
        }
        return this.inputStream;
    }
}

