/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class AssignTradeRouteMessage
extends AttributeMessage {
    public static final String TAG = "assignTradeRoute";
    private static final String TRADE_ROUTE_TAG = "tradeRoute";
    private static final String UNIT_TAG = "unit";

    public AssignTradeRouteMessage(Unit unit, TradeRoute tradeRoute) {
        super(TAG, UNIT_TAG, unit.getId(), TRADE_ROUTE_TAG, tradeRoute == null ? null : tradeRoute.getId());
    }

    public AssignTradeRouteMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, TRADE_ROUTE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        TradeRoute tradeRoute;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String tradeRouteId = this.getStringAttribute(TRADE_ROUTE_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (tradeRouteId == null) {
            tradeRoute = null;
        } else {
            try {
                tradeRoute = serverPlayer.getOurFreeColGameObject(tradeRouteId, TradeRoute.class);
            }
            catch (Exception e) {
                return serverPlayer.clientError(e.getMessage());
            }
        }
        return this.igc(freeColServer).assignTradeRoute(serverPlayer, unit, tradeRoute);
    }
}

