/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.filechooser.FileSystemView;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.OSUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class FreeColDirectories {
    private static final Comparator<File> fileModificationComparator = Comparator.comparingLong(File::lastModified);
    private static final Comparator<File> fileNameComparator = Comparator.comparing(File::getName);
    private static final String AUTOSAVE_DIRECTORY = "autosave";
    private static final String BASE_DIRECTORY = "base";
    private static final String CLASSIC_DIRECTORY = "classic";
    private static final String DATA_DIRECTORY = "data";
    private static final String FREECOL_DIRECTORY = "freecol";
    private static final String HIGH_SCORE_FILE = "HighScores.xml";
    private static final String I18N_DIRECTORY = "strings";
    private static final String LOG_FILE = "FreeCol.log";
    private static final String LOG_COMMS_FILE_NAME = "FreeColComms.log";
    private static final String MAPS_DIRECTORY = "maps";
    private static final String MESSAGE_FILE_PREFIX = "FreeColMessages";
    private static final String MESSAGE_FILE_SUFFIX = ".properties";
    private static final String MODS_DIRECTORY = "mods";
    private static final String MOD_FILE_SUFFIX = ".fmd";
    private static final String MOD_MESSAGE_FILE_PREFIX = "ModMessages";
    private static final String PLURALS_FILE_NAME = "plurals.xml";
    private static final String RESOURCE_FILE_PREFIX = "resources";
    private static final String RESOURCE_FILE_SUFFIX = ".properties";
    private static final String RULES_DIRECTORY = "rules";
    private static final String SAVE_DIRECTORY = "save";
    private static final String SPECIFICATION_FILE_NAME = "specification.xml";
    private static final String START_MAP_NAME = "startMap.fsg";
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String USER_MAPS_DIRECTORY = "maps";
    private static final String ZIP_FILE_SUFFIX = ".zip";
    private static final String XDG_CONFIG_HOME_ENV = "XDG_CONFIG_HOME";
    private static final String XDG_CONFIG_HOME_DEFAULT = ".config";
    private static final String XDG_DATA_HOME_ENV = "XDG_DATA_HOME";
    private static final String XDG_DATA_HOME_DEFAULT = ".local/share";
    private static final String XDG_CACHE_HOME_ENV = "XDG_CACHE_HOME";
    private static final String XDG_CACHE_HOME_DEFAULT = ".cache";
    public static final String BASE_CLIENT_OPTIONS_FILE_NAME = "client-options.xml";
    public static final String CLIENT_OPTIONS_FILE_NAME = "options.xml";
    public static final String CUSTOM_DIFFICULTY_FILE_NAME = "custom.xml";
    public static final String GAME_OPTIONS_FILE_NAME = "game_options.xml";
    public static final String MAP_FILE_NAME = "my_map.fsg";
    public static final String MAP_EDITOR_FILE_NAME = "my_map.fsm";
    public static final String MAP_GENERATOR_OPTIONS_FILE_NAME = "map_generator_options.xml";
    public static final String MOD_DESCRIPTOR_FILE_NAME = "mod.xml";
    private static final Predicate<File> modFileFilter = f -> Utils.fileAnySuffix(f, MOD_FILE_SUFFIX, ZIP_FILE_SUFFIX) || Utils.directoryAllPresent(f, MOD_DESCRIPTOR_FILE_NAME);
    public static final Predicate<File> saveGameFilter = f -> f.isFile() && f.canRead() && f.getName().endsWith(".fsg");
    private static final Predicate<File> mapFilter = f -> f.isFile() && f.canRead() && f.getName().endsWith(".fsm");
    private static final Predicate<File> rulesFileFilter = f -> Utils.fileAnySuffix(f, ZIP_FILE_SUFFIX) || Utils.directoryAllPresent(f, MOD_DESCRIPTOR_FILE_NAME, SPECIFICATION_FILE_NAME);
    private static final Set<PosixFilePermission> mode0700 = CollectionUtils.makeUnmodifiableSet(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    private static File autosaveDirectory = null;
    private static File clientOptionsFile = null;
    private static File dataDirectory = new File("data");
    private static String logFilePath = null;
    private static File saveDirectory = null;
    private static File savegameFile = null;
    private static File userCacheDirectory = null;
    private static File userConfigDirectory = null;
    private static File userDataDirectory = null;
    private static File userModsDirectory = null;
    private static AtomicReference<Writer> commsWriter = new AtomicReference<Object>(null);

    private static File getUserDefaultDirectory() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public static String checkDir(File dir) {
        return dir == null || !dir.exists() ? "cli.error.home.notExists" : (!dir.isDirectory() ? "cli.error.home.notDir" : (!dir.canRead() ? "cli.error.home.noRead" : (!dir.canWrite() ? "cli.error.home.noWrite" : null)));
    }

    private static boolean isGoodDirectory(File f) {
        return f != null && f.exists() && f.isDirectory() && f.canWrite();
    }

    private static File requireDirectory(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory() && dir.canWrite()) {
                return dir;
            }
        } else if (dir.mkdir()) {
            try {
                Files.setPosixFilePermissions(dir.toPath(), mode0700);
            }
            catch (IOException | UnsupportedOperationException ex) {
                System.err.println("Failed to change permissions of " + dir.getPath());
            }
            return dir;
        }
        return null;
    }

    private static StringTemplate bad() {
        return StringTemplate.key("main.userDir.fail");
    }

    private static StringTemplate badHome() {
        return StringTemplate.key("main.userDir.noHome");
    }

    private static StringTemplate badDir(File d) {
        return StringTemplate.template("main.userDir.badDir").addName("%name%", d.getPath());
    }

    private static StringTemplate badConfig(File f) {
        return StringTemplate.template("main.userDir.badConfig").addName("%name%", f.getPath());
    }

    private static StringTemplate badData(File f) {
        return StringTemplate.template("main.userDir.badData").addName("%name%", f.getPath());
    }

    private static StringTemplate badCache(File f) {
        return StringTemplate.template("main.userDir.badCache").addName("%name%", f.getPath());
    }

    private static StringTemplate getXDGDirs(File[] dirs) {
        File home = FreeColDirectories.getUserDefaultDirectory();
        if (home == null) {
            return FreeColDirectories.badHome();
        }
        String env = System.getenv(XDG_CONFIG_HOME_ENV);
        File d = env != null ? new File(env) : new File(home, XDG_CONFIG_HOME_DEFAULT);
        File xd = FreeColDirectories.requireDirectory(d);
        if (xd == null) {
            return FreeColDirectories.badDir(d);
        }
        File f = new File(xd, FREECOL_DIRECTORY);
        d = FreeColDirectories.requireDirectory(f);
        if (d == null) {
            return FreeColDirectories.badConfig(f);
        }
        dirs[0] = d;
        env = System.getenv(XDG_DATA_HOME_ENV);
        d = env != null ? new File(env) : new File(home, XDG_DATA_HOME_DEFAULT);
        xd = FreeColDirectories.requireDirectory(d);
        if (xd == null) {
            return FreeColDirectories.badDir(d);
        }
        f = new File(xd, FREECOL_DIRECTORY);
        d = FreeColDirectories.requireDirectory(f);
        if (d == null) {
            return FreeColDirectories.badData(f);
        }
        dirs[1] = d;
        env = System.getenv(XDG_CACHE_HOME_ENV);
        d = env != null ? new File(env) : new File(home, XDG_CACHE_HOME_DEFAULT);
        xd = FreeColDirectories.requireDirectory(d);
        if (xd == null) {
            return FreeColDirectories.badDir(d);
        }
        f = new File(xd, FREECOL_DIRECTORY);
        d = FreeColDirectories.requireDirectory(f);
        if (d == null) {
            return FreeColDirectories.badCache(f);
        }
        dirs[2] = d;
        return null;
    }

    private static StringTemplate getMacOSXDirs(File[] dirs) {
        File home = FreeColDirectories.getUserDefaultDirectory();
        if (home == null) {
            return FreeColDirectories.badHome();
        }
        File libDir = new File(home, "Library");
        if (!FreeColDirectories.isGoodDirectory(libDir)) {
            return FreeColDirectories.badDir(libDir);
        }
        File prefsDir = new File(libDir, "Preferences");
        if (!FreeColDirectories.isGoodDirectory(prefsDir)) {
            return FreeColDirectories.badDir(prefsDir);
        }
        File d = new File(prefsDir, FREECOL_DIRECTORY);
        File d2 = FreeColDirectories.requireDirectory(d);
        if (d2 == null) {
            return FreeColDirectories.badConfig(d);
        }
        dirs[0] = d2;
        File appsDir = new File(libDir, "Application Support");
        if (!FreeColDirectories.isGoodDirectory(appsDir)) {
            return FreeColDirectories.badDir(appsDir);
        }
        d = new File(appsDir, FREECOL_DIRECTORY);
        d2 = FreeColDirectories.requireDirectory(d);
        if (d2 == null) {
            return FreeColDirectories.badData(d);
        }
        dirs[1] = dirs[2] = d2;
        return null;
    }

    private static StringTemplate getWindowsDirs(File[] dirs) {
        File home = FreeColDirectories.getUserDefaultDirectory();
        if (home == null) {
            return FreeColDirectories.badHome();
        }
        File d = new File(home, FREECOL_DIRECTORY);
        File d2 = FreeColDirectories.requireDirectory(d);
        if (d2 == null) {
            return FreeColDirectories.badDir(d);
        }
        dirs[1] = dirs[2] = d;
        dirs[0] = dirs[2];
        return null;
    }

    private static boolean insistDirectory(File file) {
        boolean ret;
        if (file.exists()) {
            ret = file.isDirectory();
            if (!ret) {
                System.err.println("Could not create directory " + file.getPath() + " because a non-directory with that name is already there.");
            }
        } else {
            try {
                ret = file.mkdir();
            }
            catch (Exception e) {
                ret = false;
                System.err.println("Could not make directory " + file.getPath() + ": " + e.getMessage());
            }
        }
        return ret;
    }

    private static File deriveDirectory(File root, String subdir) {
        File dir;
        return FreeColDirectories.isGoodDirectory(root) && FreeColDirectories.insistDirectory(dir = new File(root, subdir)) ? dir : null;
    }

    private static File deriveAutosaveDirectory() {
        return FreeColDirectories.deriveDirectory(saveDirectory, AUTOSAVE_DIRECTORY);
    }

    private static List<File> collectFiles(File dir, Predicate<File> pred) {
        return CollectionUtils.transform(CollectionUtils.fileStream(dir), pred, Function.identity(), fileNameComparator);
    }

    public static String setDataDirectory(String path) {
        File dir;
        if (path == null) {
            path = DATA_DIRECTORY;
        }
        if (!(dir = new File(path)).isDirectory()) {
            return "Not a directory: " + path;
        }
        if (!dir.canRead()) {
            return "Can not read directory: " + path;
        }
        dataDirectory = dir;
        if (!FreeColDirectories.getBaseDirectory().exists()) {
            return "Base data directory missing from: " + path;
        }
        return null;
    }

    public static synchronized StringTemplate setUserDirectories() {
        StringTemplate err;
        File[] dirs = new File[]{null, null, null};
        StringTemplate stringTemplate = OSUtils.onMacOSX() ? FreeColDirectories.getMacOSXDirs(dirs) : (OSUtils.onUnix() ? FreeColDirectories.getXDGDirs(dirs) : (err = OSUtils.onWindows() ? FreeColDirectories.getWindowsDirs(dirs) : FreeColDirectories.bad()));
        if (err != null) {
            return err;
        }
        if (userConfigDirectory == null || !FreeColDirectories.isGoodDirectory(userConfigDirectory)) {
            userConfigDirectory = dirs[0];
        }
        if (userDataDirectory == null || !FreeColDirectories.isGoodDirectory(userDataDirectory)) {
            userDataDirectory = dirs[1];
        }
        if (userCacheDirectory == null || !FreeColDirectories.isGoodDirectory(userCacheDirectory)) {
            userCacheDirectory = dirs[2];
        }
        if (logFilePath == null) {
            logFilePath = FreeColDirectories.getUserCacheDirectory() + SEPARATOR + LOG_FILE;
        }
        if (saveDirectory == null && !FreeColDirectories.insistDirectory(saveDirectory = new File(FreeColDirectories.getUserDataDirectory(), SAVE_DIRECTORY))) {
            return FreeColDirectories.badDir(saveDirectory);
        }
        File dir = FreeColDirectories.deriveAutosaveDirectory();
        System.err.println("Autosave directory initialized to " + dir);
        FreeColDirectories.setAutosaveDirectory(dir);
        userModsDirectory = new File(FreeColDirectories.getUserDataDirectory(), MODS_DIRECTORY);
        if (!FreeColDirectories.insistDirectory(userModsDirectory)) {
            userModsDirectory = null;
        }
        return null;
    }

    private static String sanitize(String fileName) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < fileName.length(); ++i) {
            String s = fileName.substring(i, i + 1);
            if (SEPARATOR.equals(s)) continue;
            strings.add(s);
        }
        return StringUtils.join("", strings);
    }

    public static File getAutosaveDirectory() {
        if (!FreeColDirectories.isGoodDirectory(autosaveDirectory)) {
            File dir = FreeColDirectories.deriveAutosaveDirectory();
            System.err.println("Autosave directory " + autosaveDirectory + " is broken, replacing with " + dir);
            FreeColDirectories.setAutosaveDirectory(dir);
        }
        return autosaveDirectory;
    }

    private static void setAutosaveDirectory(File dir) {
        autosaveDirectory = dir;
    }

    public static File getAutosaveFile(String fileName) {
        File dir = FreeColDirectories.getAutosaveDirectory();
        return dir == null ? null : new File(dir, FreeColDirectories.sanitize(fileName));
    }

    private static List<File> getAutosaveFiles(String prefix, Predicate<File> pred) {
        String suffix = ".fsg";
        File asd = FreeColDirectories.getAutosaveDirectory();
        Predicate<File> fullPred = pred.and(f -> f.getName().startsWith(prefix) && f.getName().endsWith(".fsg"));
        return asd == null ? Collections.emptyList() : FreeColDirectories.collectFiles(asd, fullPred);
    }

    public static String removeOutdatedAutosaves(String prefix, List<String> excludeSuffixes, long validDays) {
        if (validDays <= 0L) {
            return null;
        }
        long validMS = 86400000L * validDays;
        long timeNow = Utils.now();
        Predicate<File> outdatedPred = f -> f.lastModified() + validMS < timeNow;
        String extension = ".fsg";
        List<String> ex = CollectionUtils.transform(excludeSuffixes, CollectionUtils.alwaysTrue(), s -> FreeColDirectories.sanitize(s));
        Predicate<File> suffixPred = f -> ex.stream().noneMatch(suf -> f.getName().endsWith(suf + ".fsg"));
        List<File> files = FreeColDirectories.getAutosaveFiles(FreeColDirectories.sanitize(prefix), outdatedPred.and(suffixPred));
        if (files.isEmpty()) {
            return null;
        }
        Utils.deleteFiles(files);
        StringBuilder sb = new StringBuilder();
        sb.append("Deleted outdated (> ").append(validDays).append(" old) autosave/s: ");
        for (File f2 : files) {
            sb.append(' ').append(f2.getPath());
        }
        return sb.toString();
    }

    public static String removeAutosaves(String prefix) {
        List<File> files = FreeColDirectories.getAutosaveFiles(FreeColDirectories.sanitize(prefix), CollectionUtils.alwaysTrue());
        if (files.isEmpty()) {
            return null;
        }
        Utils.deleteFiles(files);
        StringBuilder sb = new StringBuilder();
        sb.append("Deleted autosave/s: ");
        for (File f : files) {
            sb.append(' ').append(f.getPath());
        }
        return sb.toString();
    }

    public static File getBaseDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), BASE_DIRECTORY);
    }

    public static File getBaseClientOptionsFile() {
        return new File(FreeColDirectories.getBaseDirectory(), BASE_CLIENT_OPTIONS_FILE_NAME);
    }

    public static File getClientOptionsFile() {
        return clientOptionsFile != null ? clientOptionsFile : FreeColDirectories.getOptionsFile(CLIENT_OPTIONS_FILE_NAME);
    }

    public static boolean setClientOptionsFile(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile() && file.canRead()) {
            clientOptionsFile = file;
            return true;
        }
        return false;
    }

    public static File getCompatibilityFile(String fileName) {
        return new File(FreeColDirectories.getBaseDirectory(), fileName);
    }

    public static File getDataDirectory() {
        return dataDirectory;
    }

    public static File getDebugRunSaveFile() {
        return new File(System.getProperty("user.dir"), FreeColDebugger.getDebugRunSave());
    }

    public static File getHighScoreFile() {
        return new File(FreeColDirectories.getUserDataDirectory(), HIGH_SCORE_FILE);
    }

    public static File getI18nDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), I18N_DIRECTORY);
    }

    public static String getLogFileContents() {
        return Utils.getUTF8Contents(new File(FreeColDirectories.getLogFilePath()));
    }

    public static List<File> getI18nMessageFileList(Locale locale) {
        ArrayList<File> result = new ArrayList<File>();
        File i18nDirectory = FreeColDirectories.getI18nDirectory();
        for (String name : FreeColDirectories.getMessageFileNameList(locale)) {
            File f = new File(i18nDirectory, name);
            if (!f.canRead()) continue;
            result.add(f);
        }
        return result;
    }

    public static File getI18nPluralsFile() {
        return new File(FreeColDirectories.getI18nDirectory(), PLURALS_FILE_NAME);
    }

    public static List<String> getLanguageIdList() {
        File[] files = FreeColDirectories.getI18nDirectory().listFiles();
        return files == null ? Collections.emptyList() : CollectionUtils.transform(files, File::canRead, f -> FreeColDirectories.getLanguageId(f));
    }

    public static String getLanguageId(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        if (name == null || !name.startsWith(MESSAGE_FILE_PREFIX) || !name.endsWith(".properties")) {
            return null;
        }
        String languageId = name.substring(MESSAGE_FILE_PREFIX.length(), name.length() - ".properties".length());
        return "".equals(languageId) ? "en" : ("_qqq".equals(languageId) ? null : (languageId.startsWith("_") ? languageId.substring(1) : languageId));
    }

    public static List<String> getLocaleFileNames(String prefix, String suffix, Locale locale) {
        Object language = locale.getLanguage();
        Object country = locale.getCountry();
        Object variant = locale.getVariant();
        ArrayList<String> result = new ArrayList<String>(4);
        if (!((String)language).isEmpty()) {
            language = "_" + (String)language;
        }
        if (!((String)country).isEmpty()) {
            country = "_" + (String)country;
        }
        if (!((String)variant).isEmpty()) {
            variant = "_" + (String)variant;
        }
        result.add(prefix + suffix);
        String filename = prefix + (String)language + suffix;
        if (!result.contains(filename)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + (String)language + (String)country + suffix)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + (String)language + (String)country + (String)variant + suffix)) {
            result.add(filename);
        }
        return result;
    }

    public static String getLogFilePath() {
        return logFilePath;
    }

    public static void setLogFilePath(String path) {
        logFilePath = path;
    }

    public static Writer getLogWriter() throws FreeColException {
        String path = FreeColDirectories.getLogFilePath();
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FreeColException("Log file \"" + path + "\" could not be created.");
            }
            if (file.isFile()) {
                Utils.deleteFile(file);
            }
        }
        try {
            if (!file.createNewFile()) {
                throw new FreeColException("Log file \"" + path + "\" creation failed.");
            }
        }
        catch (IOException | SecurityException e) {
            throw new FreeColException("Log file \"" + path + "\" could not be created.", e);
        }
        if (!file.canWrite()) {
            throw new FreeColException("Can not write in log file \"" + path + "\".");
        }
        Writer writer = Utils.getFileUTF8Writer(file);
        if (writer == null) {
            throw new FreeColException("Can not create writer for log file \"" + path + "\".");
        }
        return writer;
    }

    public static Writer getLogCommsWriter() throws FreeColException {
        Writer writer = commsWriter.get();
        if (writer == null) {
            File file = new File(FreeColDirectories.getUserCacheDirectory(), FreeCol.getName() + "-FreeColComms.log");
            if (file.exists()) {
                Utils.deleteFile(file);
            }
            if ((writer = Utils.getFileUTF8AppendWriter(file)) == null) {
                throw new FreeColException("Can not create writer for comms log file: " + file.getPath());
            }
            commsWriter.set(writer);
        }
        return writer;
    }

    public static File getMapsDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), "maps");
    }

    public static List<File> getMapFileList() {
        ArrayList<File> ret = new ArrayList<File>();
        for (File f : new File[]{FreeColDirectories.getMapsDirectory(), FreeColDirectories.getUserMapsDirectory()}) {
            if (f == null || !f.isDirectory()) continue;
            ret.addAll(FreeColDirectories.collectFiles(f, mapFilter));
        }
        return ret;
    }

    public static List<String> getMessageFileNameList(Locale locale) {
        return FreeColDirectories.getLocaleFileNames(MESSAGE_FILE_PREFIX, ".properties", locale);
    }

    public static List<String> getModMessageFileNames(Locale locale) {
        return FreeColDirectories.getLocaleFileNames(MOD_MESSAGE_FILE_PREFIX, ".properties", locale);
    }

    public static List<File> getModFileList() {
        ArrayList<File> ret = new ArrayList<File>();
        ret.addAll(FreeColDirectories.collectFiles(FreeColDirectories.getStandardModsDirectory(), modFileFilter));
        ret.addAll(FreeColDirectories.collectFiles(FreeColDirectories.getUserModsDirectory(), modFileFilter));
        return ret;
    }

    public static File getOptionsDirectory() {
        File dir = new File(FreeColDirectories.getUserConfigDirectory(), FreeCol.getRules());
        return FreeColDirectories.insistDirectory(dir) ? dir : null;
    }

    public static File getOptionsFile(String fileName) {
        File dir = FreeColDirectories.getOptionsDirectory();
        return dir == null ? null : new File(dir, FreeColDirectories.sanitize(fileName));
    }

    public static List<String> getResourceFileNames() {
        return FreeColDirectories.getLocaleFileNames(RESOURCE_FILE_PREFIX, ".properties", Locale.getDefault());
    }

    public static File getRulesClassicDirectory() {
        return new File(FreeColDirectories.getRulesDirectory(), CLASSIC_DIRECTORY);
    }

    public static File getRulesDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), RULES_DIRECTORY);
    }

    public static File getSaveDirectory() {
        return saveDirectory;
    }

    public static File getSavegameFile() {
        return savegameFile;
    }

    public static Stream<File> getSavegameFiles(File directory) {
        return directory == null ? CollectionUtils.flatten(Stream.of(FreeColDirectories.getSaveDirectory(), FreeColDirectories.getAutosaveDirectory()), d -> CollectionUtils.fileStream(d, saveGameFilter)) : CollectionUtils.fileStream(directory, saveGameFilter);
    }

    public static List<File> getSavegameFileList(File directory) {
        return CollectionUtils.toList(FreeColDirectories.getSavegameFiles(directory));
    }

    public static boolean setSavegameFile(String path) {
        File file = new File(path);
        if (!(file.exists() && file.isFile() && file.canRead() || (file = new File(FreeColDirectories.getSaveDirectory(), path)).exists() && file.isFile() && file.canRead())) {
            return false;
        }
        savegameFile = file;
        File parent = file.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        saveDirectory = parent;
        File dir = FreeColDirectories.deriveAutosaveDirectory();
        System.err.println("Autosave directory " + autosaveDirectory + " follows saveDirectory change to " + dir);
        FreeColDirectories.setAutosaveDirectory(dir);
        return true;
    }

    public static File getLastSaveGameFile() {
        return CollectionUtils.maximize(FreeColDirectories.getSavegameFiles(null), fileModificationComparator);
    }

    public static File getStandardModsDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), MODS_DIRECTORY);
    }

    public static File getStartMapFile() {
        File dir = FreeColDirectories.getAutosaveDirectory();
        return dir == null ? null : new File(dir, START_MAP_NAME);
    }

    public static List<File> getRulesFileList() {
        return FreeColDirectories.collectFiles(FreeColDirectories.getRulesDirectory(), rulesFileFilter);
    }

    public static File getUserCacheDirectory() {
        return userCacheDirectory;
    }

    public static String setUserCacheDirectory(String path) {
        File dir = new File(path);
        String ret = FreeColDirectories.checkDir(dir);
        if (ret == null) {
            userCacheDirectory = dir;
        }
        return ret;
    }

    public static File getUserConfigDirectory() {
        return userConfigDirectory;
    }

    public static String setUserConfigDirectory(String path) {
        File dir = new File(path);
        String ret = FreeColDirectories.checkDir(dir);
        if (ret == null) {
            userConfigDirectory = dir;
        }
        return ret;
    }

    public static File getUserDataDirectory() {
        return userDataDirectory;
    }

    public static String setUserDataDirectory(String path) {
        File dir = new File(path);
        String ret = FreeColDirectories.checkDir(dir);
        if (ret == null) {
            userDataDirectory = dir;
        }
        return ret;
    }

    public static File getUserMapsDirectory() {
        return FreeColDirectories.deriveDirectory(FreeColDirectories.getUserDataDirectory(), "maps");
    }

    public static File getUserModsDirectory() {
        return userModsDirectory;
    }
}

