/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public class NewUnitPanel
extends FreeColPanel {
    private final JLabel question;
    private final List<JButton> buttons = new ArrayList<JButton>();
    private final List<UnitType> units = new ArrayList<UnitType>();
    private final Comparator<UnitType> priceComparator;
    private boolean shouldEnable = false;

    protected NewUnitPanel(FreeColClient freeColClient, LayoutManager layout, String label, List<UnitType> units) {
        super(freeColClient, null, layout);
        this.question = new JLabel(label);
        this.units.addAll(units);
        Europe europe = this.getMyPlayer().getEurope();
        this.priceComparator = Comparator.comparingInt(ut -> europe.getUnitPrice((UnitType)ut));
        this.okButton.setText(Messages.message("close"));
    }

    public void update() {
        this.removeAll();
        Player player = this.getMyPlayer();
        Europe europe = player.getEurope();
        this.add((Component)this.question, "span, wrap 20");
        this.buttons.clear();
        for (UnitType ut : CollectionUtils.sort(this.units, this.priceComparator)) {
            int price = europe.getUnitPrice(ut);
            boolean enable = player.checkGold(price);
            JButton newButton = new JButton();
            newButton.setLayout(new MigLayout("wrap 2", "[60]", "[30][30]"));
            ImageIcon icon = new ImageIcon(this.getImageLibrary().getSmallUnitTypeImage(ut, !enable));
            JLabel name = Utility.localizedLabel(ut);
            name.setEnabled(enable);
            JLabel gold = Utility.localizedLabel(StringTemplate.template("goldAmount").addAmount("%amount%", price));
            gold.setEnabled(enable);
            newButton.setEnabled(enable);
            newButton.add((Component)new JLabel(icon), "span 1 2");
            newButton.add(name);
            newButton.add(gold);
            newButton.setActionCommand(ut.getId());
            newButton.addActionListener(this);
            this.buttons.add(newButton);
            this.add((Component)newButton, "grow");
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setSize(this.getPreferredSize());
        this.revalidate();
        this.shouldEnable = player.checkGold(europe.getUnitPrice(CollectionUtils.first(this.units)));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(ae);
        } else {
            UnitType unitType = this.getSpecification().getUnitType(command);
            this.igc().trainUnitInEurope(unitType);
            this.getGUI().updateEuropeanSubpanels();
            if (!this.shouldEnable) {
                this.getGUI().removeComponent(this);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        for (JButton jb : this.buttons) {
            if (jb == null) continue;
            jb.setLayout(null);
        }
        this.buttons.clear();
    }
}

