define(["exports","../utils/logger.js","./amf-parser.js","./demux-errors.js","../core/media-info.js","../utils/exception.js","./exp-golomb.js"],function(_exports,_logger,_amfParser,_demuxErrors,_mediaInfo,_exception,_expGolomb){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var FLVDemuxer=function(){function FLVDemuxer(probeData,config){babelHelpers.classCallCheck(this,FLVDemuxer),this.TAG="FLVDemuxer",this._config=config,this._onError=null,this._onMediaInfo=null,this._onMetaDataArrived=null,this._onScriptDataArrived=null,this._onTrackMetadata=null,this._onDataAvailable=null,this._dataOffset=probeData.dataOffset,this._firstParse=!0,this._dispatch=!1,this._hasAudio=probeData.hasAudioTrack,this._hasVideo=probeData.hasVideoTrack,this._audioInitialMetadataDispatched=!1,this._videoInitialMetadataDispatched=!1,this._mediaInfo=new _mediaInfo.default,this._mediaInfo.hasAudio=this._hasAudio,this._mediaInfo.hasVideo=this._hasVideo,this._metadata=null,this._audioMetadata=null,this._videoMetadata=null,this._naluLengthSize=4,this._timestampBase=0,this._timescale=1e3,this._duration=0,this._referenceFrameRate={fixed:!0,fps:23.976,fps_num:23976,fps_den:1e3},this._flvSoundRateTable=[5500,11025,22050,44100,48e3],this._mpegSamplingRates=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],this._mpegAudioV10SampleRateTable=[44100,48e3,32e3,0],this._mpegAudioV20SampleRateTable=[22050,24e3,16e3,0],this._mpegAudioV25SampleRateTable=[11025,12e3,8e3,0],this._mpegAudioL1BitRateTable=[0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,-1],this._mpegAudioL2BitRateTable=[0,32,48,56,64,80,96,112,128,160,192,224,256,320,384,-1],this._mpegAudioL3BitRateTable=[0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,-1],this._videoTrack={type:"video",id:1,sequenceNumber:0,samples:[],length:0},this._audioTrack={type:"audio",id:2,sequenceNumber:0,samples:[],length:0},this._littleEndian=!1}return babelHelpers.createClass(FLVDemuxer,[{key:"destroy",value:function(){this._mediaInfo=null,this._metadata=null,this._audioMetadata=null,this._videoMetadata=null,this._videoTrack=null,this._audioTrack=null,this._onError=null,this._onMediaInfo=null,this._onMetaDataArrived=null,this._onScriptDataArrived=null,this._onTrackMetadata=null,this._onDataAvailable=null}},{key:"bindDataSource",value:function(loader){return loader.onDataArrival=this.parseChunks.bind(this),this}},{key:"onTrackMetadata",get:function(){return this._onTrackMetadata},set:function(callback){this._onTrackMetadata=callback}},{key:"onMediaInfo",get:function(){return this._onMediaInfo},set:function(callback){this._onMediaInfo=callback}},{key:"onMetaDataArrived",get:function(){return this._onMetaDataArrived},set:function(callback){this._onMetaDataArrived=callback}},{key:"onScriptDataArrived",get:function(){return this._onScriptDataArrived},set:function(callback){this._onScriptDataArrived=callback}},{key:"onError",get:function(){return this._onError},set:function(callback){this._onError=callback}},{key:"onDataAvailable",get:function(){return this._onDataAvailable},set:function(callback){this._onDataAvailable=callback}},{key:"timestampBase",get:function(){return this._timestampBase},set:function(base){this._timestampBase=base}},{key:"resetMediaInfo",value:function(){this._mediaInfo=new _mediaInfo.default}},{key:"_isInitialMetadataDispatched",value:function(){return this._hasAudio&&this._hasVideo?this._audioInitialMetadataDispatched&&this._videoInitialMetadataDispatched:this._hasAudio&&!this._hasVideo?this._audioInitialMetadataDispatched:!(this._hasAudio||!this._hasVideo)&&this._videoInitialMetadataDispatched}},{key:"parseChunks",value:function(chunk,byteStart){if(!(this._onError&&this._onMediaInfo&&this._onTrackMetadata&&this._onDataAvailable))throw new _exception.IllegalStateException("Flv: onError & onMediaInfo & onTrackMetadata & onDataAvailable callback must be specified");var offset=0,le=this._littleEndian;if(0===byteStart){if(!(13<chunk.byteLength))return 0;offset=FLVDemuxer.probe(chunk).dataOffset}for(this._firstParse&&(this._firstParse=!1,byteStart+offset!==this._dataOffset&&_logger.default.w(this.TAG,"First time parsing but chunk byteStart invalid!"),0!==new DataView(chunk,offset).getUint32(0,le)&&_logger.default.w(this.TAG,"PrevTagSize0 !== 0 !!!"),offset+=4);offset<chunk.byteLength;){this._dispatch=!0;var _v=new DataView(chunk,offset);if(offset+11+4>chunk.byteLength)break;var tagType=_v.getUint8(0),dataSize=16777215&_v.getUint32(0,le);if(offset+11+dataSize+4>chunk.byteLength)break;if(8!==tagType&&9!==tagType&&18!==tagType)_logger.default.w(this.TAG,"Unsupported tag type ".concat(tagType,", skipped")),offset+=11+dataSize+4;else{var ts2=_v.getUint8(4),ts1=_v.getUint8(5),timestamp=_v.getUint8(6)|ts1<<8|ts2<<16|_v.getUint8(7)<<24,dataOffset=(0!=(16777215&_v.getUint32(7,le))&&_logger.default.w(this.TAG,"Meet tag which has StreamID != 0!"),offset+11);switch(tagType){case 8:this._parseAudioData(chunk,dataOffset,dataSize,timestamp);break;case 9:this._parseVideoData(chunk,dataOffset,dataSize,timestamp,byteStart+offset);break;case 18:this._parseScriptData(chunk,dataOffset,dataSize)}ts1=_v.getUint32(11+dataSize,le);ts1!==11+dataSize&&_logger.default.w(this.TAG,"Invalid PrevTagSize ".concat(ts1)),offset+=11+dataSize+4}}return this._isInitialMetadataDispatched()&&this._dispatch&&(this._audioTrack.length||this._videoTrack.length)&&this._onDataAvailable(this._audioTrack,this._videoTrack),offset}},{key:"_parseScriptData",value:function(arrayBuffer,dataOffset,dataSize){arrayBuffer=_amfParser.default.parseScriptData(arrayBuffer,dataOffset,dataSize);if(arrayBuffer.hasOwnProperty("onMetaData")){if(null==arrayBuffer.onMetaData||"object"!=typeof arrayBuffer.onMetaData)return void _logger.default.w(this.TAG,"Invalid onMetaData structure!");this._metadata&&_logger.default.w(this.TAG,"Found another onMetaData tag!"),this._metadata=arrayBuffer;var fps,dataOffset=this._metadata.onMetaData;this._onMetaDataArrived&&this._onMetaDataArrived(Object.assign({},dataOffset)),"boolean"==typeof dataOffset.hasAudio&&(this._hasAudio=dataOffset.hasAudio,this._mediaInfo.hasAudio=this._hasAudio),"boolean"==typeof dataOffset.hasVideo&&(this._hasVideo=dataOffset.hasVideo,this._mediaInfo.hasVideo=this._hasVideo),"number"==typeof dataOffset.audiodatarate&&(this._mediaInfo.audioDataRate=dataOffset.audiodatarate),"number"==typeof dataOffset.videodatarate&&(this._mediaInfo.videoDataRate=dataOffset.videodatarate),"number"==typeof dataOffset.width&&(this._mediaInfo.width=dataOffset.width),"number"==typeof dataOffset.height&&(this._mediaInfo.height=dataOffset.height),"number"==typeof dataOffset.duration?(dataSize=Math.floor(dataOffset.duration*this._timescale),this._duration=dataSize,this._mediaInfo.duration=dataSize):this._mediaInfo.duration=0,"number"!=typeof dataOffset.framerate||0<(dataSize=Math.floor(1e3*dataOffset.framerate))&&(fps=dataSize/1e3,this._referenceFrameRate.fixed=!0,this._referenceFrameRate.fps=fps,this._referenceFrameRate.fps_num=dataSize,this._referenceFrameRate.fps_den=1e3,this._mediaInfo.fps=fps),"object"==typeof dataOffset.keyframes?(this._mediaInfo.hasKeyframesIndex=!0,dataSize=dataOffset.keyframes,this._mediaInfo.keyframesIndex=this._parseKeyframesIndex(dataSize),dataOffset.keyframes=null):this._mediaInfo.hasKeyframesIndex=!1,this._dispatch=!1,this._mediaInfo.metadata=dataOffset,_logger.default.v(this.TAG,"Parsed onMetaData"),this._mediaInfo.isComplete()&&this._onMediaInfo(this._mediaInfo)}0<Object.keys(arrayBuffer).length&&this._onScriptDataArrived&&this._onScriptDataArrived(Object.assign({},arrayBuffer))}},{key:"_parseKeyframesIndex",value:function(keyframes){for(var times=[],filepositions=[],i=1;i<keyframes.times.length;i++){var time=this._timestampBase+Math.floor(1e3*keyframes.times[i]);times.push(time),filepositions.push(keyframes.filepositions[i])}return{times:times,filepositions:filepositions}}},{key:"_parseAudioData",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp){if(dataSize<=1)_logger.default.w(this.TAG,"Flv: Invalid audio packet, missing SoundData payload!");else{this._littleEndian;var soundSpec=new DataView(arrayBuffer,dataOffset,dataSize).getUint8(0),soundFormat=soundSpec>>>4;if(2!=soundFormat&&10!=soundFormat)this._onError(_demuxErrors.default.CODEC_UNSUPPORTED,"Flv: Unsupported audio codec idx: "+soundFormat);else{var soundRate=0,soundRateIndex=(12&soundSpec)>>>2;if(0<=soundRateIndex&&soundRateIndex<=4){var soundRate=this._flvSoundRateTable[soundRateIndex],soundSpec=1&soundSpec,meta=this._audioMetadata,track=this._audioTrack;if(meta||(!1===this._hasAudio&&(this._hasAudio=!0,this._mediaInfo.hasAudio=!0),(meta=this._audioMetadata={type:"audio"}).id=track.id,meta.timescale=this._timescale,meta.duration=this._duration,meta.audioSampleRate=soundRate,meta.channelCount=0==soundSpec?1:2),10==soundFormat){soundRate=this._parseAACAudioData(arrayBuffer,dataOffset+1,dataSize-1);null!=soundRate&&(0===soundRate.packetType?(meta.config&&_logger.default.w(this.TAG,"Found another AudioSpecificConfig!"),soundSpec=soundRate.data,meta.audioSampleRate=soundSpec.samplingRate,meta.channelCount=soundSpec.channelCount,meta.codec=soundSpec.codec,meta.originalCodec=soundSpec.originalCodec,meta.config=soundSpec.config,meta.refSampleDuration=1024/meta.audioSampleRate*meta.timescale,_logger.default.v(this.TAG,"Parsed AudioSpecificConfig"),this._isInitialMetadataDispatched()?this._dispatch&&(this._audioTrack.length||this._videoTrack.length)&&this._onDataAvailable(this._audioTrack,this._videoTrack):this._audioInitialMetadataDispatched=!0,this._dispatch=!1,this._onTrackMetadata("audio",meta),(soundSpec=this._mediaInfo).audioCodec=meta.originalCodec,soundSpec.audioSampleRate=meta.audioSampleRate,soundSpec.audioChannelCount=meta.channelCount,soundSpec.hasVideo?null!=soundSpec.videoCodec&&(soundSpec.mimeType='video/x-flv; codecs="'+soundSpec.videoCodec+","+soundSpec.audioCodec+'"'):soundSpec.mimeType='video/x-flv; codecs="'+soundSpec.audioCodec+'"',soundSpec.isComplete()&&this._onMediaInfo(soundSpec)):1===soundRate.packetType?(soundSpec=this._timestampBase+tagTimestamp,soundSpec={unit:soundRate.data,length:soundRate.data.byteLength,dts:soundSpec,pts:soundSpec},track.samples.push(soundSpec),track.length+=soundRate.data.length):_logger.default.e(this.TAG,"Flv: Unsupported AAC data type ".concat(soundRate.packetType)))}else if(2==soundFormat){if(!meta.codec){soundSpec=this._parseMP3AudioData(arrayBuffer,dataOffset+1,dataSize-1,!0);if(null==soundSpec)return;meta.audioSampleRate=soundSpec.samplingRate,meta.channelCount=soundSpec.channelCount,meta.codec=soundSpec.codec,meta.originalCodec=soundSpec.originalCodec,meta.refSampleDuration=1152/meta.audioSampleRate*meta.timescale,_logger.default.v(this.TAG,"Parsed MPEG Audio Frame Header"),this._audioInitialMetadataDispatched=!0,this._onTrackMetadata("audio",meta);soundRate=this._mediaInfo;soundRate.audioCodec=meta.codec,soundRate.audioSampleRate=meta.audioSampleRate,soundRate.audioChannelCount=meta.channelCount,soundRate.audioDataRate=soundSpec.bitRate,soundRate.hasVideo?null!=soundRate.videoCodec&&(soundRate.mimeType='video/x-flv; codecs="'+soundRate.videoCodec+","+soundRate.audioCodec+'"'):soundRate.mimeType='video/x-flv; codecs="'+soundRate.audioCodec+'"',soundRate.isComplete()&&this._onMediaInfo(soundRate)}soundFormat=this._parseMP3AudioData(arrayBuffer,dataOffset+1,dataSize-1,!1);null!=soundFormat&&(meta=this._timestampBase+tagTimestamp,soundSpec={unit:soundFormat,length:soundFormat.byteLength,dts:meta,pts:meta},track.samples.push(soundSpec),track.length+=soundFormat.length)}}else this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid audio sample rate idx: "+soundRateIndex)}}}},{key:"_parseAACAudioData",value:function(arrayBuffer,dataOffset,dataSize){var result,array;{if(!(dataSize<=1))return result={},array=new Uint8Array(arrayBuffer,dataOffset,dataSize),result.packetType=array[0],0===array[0]?result.data=this._parseAACAudioSpecificConfig(arrayBuffer,dataOffset+1,dataSize-1):result.data=array.subarray(1),result;_logger.default.w(this.TAG,"Flv: Invalid AAC packet, missing AACPacketType or/and Data!")}}},{key:"_parseAACAudioSpecificConfig",value:function(arrayBuffer,dataOffset,dataSize){var originalAudioObjectType,samplingIndex,arrayBuffer=new Uint8Array(arrayBuffer,dataOffset,dataSize),dataOffset=null,dataSize=0,extensionSamplingIndex=null,dataSize=originalAudioObjectType=arrayBuffer[0]>>>3;if((samplingIndex=(7&arrayBuffer[0])<<1|arrayBuffer[1]>>>7)<0||samplingIndex>=this._mpegSamplingRates.length)this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: AAC invalid sampling frequency index!");else{var samplingFrequence=this._mpegSamplingRates[samplingIndex],channelConfig=(120&arrayBuffer[1])>>>3;if(!(channelConfig<0||8<=channelConfig))return 5===dataSize&&(extensionSamplingIndex=(7&arrayBuffer[1])<<1|arrayBuffer[2]>>>7,arrayBuffer[2]),-1!==(arrayBuffer=self.navigator.userAgent.toLowerCase()).indexOf("firefox")?extensionSamplingIndex=6<=samplingIndex?(dataSize=5,dataOffset=new Array(4),samplingIndex-3):(dataSize=2,dataOffset=new Array(2),samplingIndex):-1!==arrayBuffer.indexOf("android")?(dataSize=2,dataOffset=new Array(2),extensionSamplingIndex=samplingIndex):(dataSize=5,extensionSamplingIndex=samplingIndex,dataOffset=new Array(4),6<=samplingIndex?extensionSamplingIndex=samplingIndex-3:1==channelConfig&&(dataSize=2,dataOffset=new Array(2),extensionSamplingIndex=samplingIndex)),dataOffset[0]=dataSize<<3,dataOffset[0]|=(15&samplingIndex)>>>1,dataOffset[1]=(15&samplingIndex)<<7,dataOffset[1]|=(15&channelConfig)<<3,5===dataSize&&(dataOffset[1]|=(15&extensionSamplingIndex)>>>1,dataOffset[2]=(1&extensionSamplingIndex)<<7,dataOffset[2]|=8,dataOffset[3]=0),{config:dataOffset,samplingRate:samplingFrequence,channelCount:channelConfig,codec:"mp4a.40."+dataSize,originalCodec:"mp4a.40."+originalAudioObjectType};this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: AAC invalid channel configuration")}}},{key:"_parseMP3AudioData",value:function(arrayBuffer,dataOffset,dataSize,requestHeader){if(!(dataSize<4)){this._littleEndian;arrayBuffer=new Uint8Array(arrayBuffer,dataOffset,dataSize),dataOffset=null;if(requestHeader){if(255!==arrayBuffer[0])return;var dataSize=arrayBuffer[1]>>>3&3,requestHeader=(6&arrayBuffer[1])>>1,bitrate_index=(240&arrayBuffer[2])>>>4,sampling_freq_index=(12&arrayBuffer[2])>>>2,channel_count=3!=(arrayBuffer[3]>>>6&3)?2:1,sample_rate=0,bit_rate=0;switch(dataSize){case 0:sample_rate=this._mpegAudioV25SampleRateTable[sampling_freq_index];break;case 2:sample_rate=this._mpegAudioV20SampleRateTable[sampling_freq_index];break;case 3:sample_rate=this._mpegAudioV10SampleRateTable[sampling_freq_index]}switch(requestHeader){case 1:bitrate_index<this._mpegAudioL3BitRateTable.length&&(bit_rate=this._mpegAudioL3BitRateTable[bitrate_index]);break;case 2:bitrate_index<this._mpegAudioL2BitRateTable.length&&(bit_rate=this._mpegAudioL2BitRateTable[bitrate_index]);break;case 3:bitrate_index<this._mpegAudioL1BitRateTable.length&&(bit_rate=this._mpegAudioL1BitRateTable[bitrate_index])}dataOffset={bitRate:bit_rate,samplingRate:sample_rate,channelCount:channel_count,codec:"mp3",originalCodec:"mp3"}}else dataOffset=arrayBuffer;return dataOffset}_logger.default.w(this.TAG,"Flv: Invalid MP3 packet, header missing!")}},{key:"_parseVideoData",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp,tagPosition){var frameType,spec;dataSize<=1?_logger.default.w(this.TAG,"Flv: Invalid video packet, missing VideoData payload!"):(frameType=(240&(spec=new Uint8Array(arrayBuffer,dataOffset,dataSize)[0]))>>>4,7!=(spec=15&spec)?this._onError(_demuxErrors.default.CODEC_UNSUPPORTED,"Flv: Unsupported codec in video frame: ".concat(spec)):this._parseAVCVideoPacket(arrayBuffer,dataOffset+1,dataSize-1,tagTimestamp,tagPosition,frameType))}},{key:"_parseAVCVideoPacket",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp,tagPosition,frameType){var le,packetType,v;dataSize<4?_logger.default.w(this.TAG,"Flv: Invalid AVC packet, missing AVCPacketType or/and CompositionTime"):(le=this._littleEndian,packetType=(v=new DataView(arrayBuffer,dataOffset,dataSize)).getUint8(0),v=(16777215&v.getUint32(0,le))<<8>>8,0===packetType?this._parseAVCDecoderConfigurationRecord(arrayBuffer,dataOffset+4,dataSize-4):1===packetType?this._parseAVCVideoData(arrayBuffer,dataOffset+4,dataSize-4,tagTimestamp,tagPosition,frameType,v):2!==packetType&&this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid video packet type ".concat(packetType)))}},{key:"_parseAVCDecoderConfigurationRecord",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<7)_logger.default.w(this.TAG,"Flv: Invalid AVCDecoderConfigurationRecord, lack of data!");else{var meta=this._videoMetadata,track=this._videoTrack,le=this._littleEndian,v=new DataView(arrayBuffer,dataOffset,dataSize),track=(meta?void 0!==meta.avcc&&_logger.default.w(this.TAG,"Found another AVCDecoderConfigurationRecord!"):(!1===this._hasVideo&&(this._hasVideo=!0,this._mediaInfo.hasVideo=!0),(meta=this._videoMetadata={type:"video"}).id=track.id,meta.timescale=this._timescale,meta.duration=this._duration),v.getUint8(0)),avcProfile=v.getUint8(1);v.getUint8(2),v.getUint8(3);if(1!==track||0===avcProfile)this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid AVCDecoderConfigurationRecord");else if(this._naluLengthSize=1+(3&v.getUint8(4)),3!==this._naluLengthSize&&4!==this._naluLengthSize)this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Strange NaluLengthSizeMinusOne: ".concat(this._naluLengthSize-1));else{var spsCount=31&v.getUint8(5);if(0==spsCount)this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid AVCDecoderConfigurationRecord: No SPS");else{1<spsCount&&_logger.default.w(this.TAG,"Flv: Strange AVCDecoderConfigurationRecord: SPS Count = ".concat(spsCount));for(var offset=6,i=0;i<spsCount;i++){var len=v.getUint16(offset,le);if(offset+=2,0!==len){var sps=new Uint8Array(arrayBuffer,dataOffset+offset,len);if(offset+=len,0===i){for(var len=function(uint8array){for(var src=uint8array,src_length=src.byteLength,dst=new Uint8Array(src_length),dst_idx=0,i=0;i<src_length;i++)2<=i&&3===src[i]&&0===src[i-1]&&0===src[i-2]||(dst[dst_idx]=src[i],dst_idx++);return new Uint8Array(dst.buffer,0,dst_idx)}(sps),expConfig=new _expGolomb.default(len).readSPS(),codecArray=(meta.sps=[len],meta.pps=sps,meta.pixelRatio=expConfig.pixelRatio,meta.width=expConfig.width,meta.height=expConfig.height,meta.codecWidth=expConfig.width,meta.codecHeight=expConfig.height,meta.presentWidth=expConfig.width,meta.presentHeight=expConfig.height,sps.subarray(1,4)),codecString="avc1.",j=0;j<3;j++){var h=codecArray[j].toString(16);codecString+=h=h.length<2?"0"+h:h}meta.codec=codecString;len=this._mediaInfo;len.width=meta.codecWidth,len.height=meta.codecHeight,len.videoCodec=codecString,len.hasAudio?null!=len.audioCodec&&(len.mimeType='video/x-flv; codecs="'+len.videoCodec+","+len.audioCodec+'"'):len.mimeType='video/x-flv; codecs="'+len.videoCodec+'"',len.isComplete()&&this._onMediaInfo(len)}}}var ppsCount=v.getUint8(offset);if(0===ppsCount)this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid AVCDecoderConfigurationRecord: No PPS");else{1<ppsCount&&_logger.default.w(this.TAG,"Flv: Strange AVCDecoderConfigurationRecord: PPS Count = ".concat(ppsCount)),offset++;for(var _i=0;_i<ppsCount;_i++){var _len=v.getUint16(offset,le);offset+=2,0!==_len&&(offset+=_len)}meta.avcc=new Uint8Array(dataSize),meta.avcc.set(new Uint8Array(arrayBuffer,dataOffset,dataSize),0),_logger.default.v(this.TAG,"Parsed AVCDecoderConfigurationRecord"),this._isInitialMetadataDispatched()?this._dispatch&&(this._audioTrack.length||this._videoTrack.length)&&this._onDataAvailable(this._audioTrack,this._videoTrack):this._videoInitialMetadataDispatched=!0,this._dispatch=!1,this._onTrackMetadata("video",meta)}}}}}},{key:"_parseAVCVideoData",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp,tagPosition,frameType,cts){for(var le=this._littleEndian,v=new DataView(arrayBuffer,dataOffset,dataSize),units=[],length=0,offset=0,lengthSize=this._naluLengthSize,dts=this._timestampBase+tagTimestamp,keyframe=1===frameType;offset<dataSize;){if(dataSize<=offset+4){_logger.default.w(this.TAG,"Malformed Nalu near timestamp ".concat(dts,", offset = ").concat(offset,", dataSize = ").concat(dataSize));break}var naluSize=v.getUint32(offset,le);if(3===lengthSize&&(naluSize>>>=8),dataSize-lengthSize<naluSize)return void _logger.default.w(this.TAG,"Malformed Nalus near timestamp ".concat(dts,", NaluSize > DataSize!"));var unitType=31&v.getUint8(offset+lengthSize),data=(5==unitType&&(keyframe=!0),new Uint8Array(arrayBuffer,dataOffset+offset,lengthSize+naluSize));units.push({type:unitType,data:data}),length+=data.byteLength,offset+=lengthSize+naluSize}units.length&&(tagTimestamp=this._videoTrack,frameType={units:units,length:length,isKeyframe:keyframe,dts:dts,cts:cts,pts:dts+cts},keyframe&&(frameType.fileposition=tagPosition),tagTimestamp.samples.push(frameType),tagTimestamp.length+=length)}}],[{key:"probe",value:function(buffer){var buffer=new Uint8Array(buffer),mismatch={match:!1};if(70!==buffer[0]||76!==buffer[1]||86!==buffer[2]||1!==buffer[3])return mismatch;var index,hasAudio=(4&buffer[4])>>>2!=0,hasVideo=0!=(1&buffer[4]),buffer=buffer[index=5]<<24|buffer[index+1]<<16|buffer[index+2]<<8|buffer[index+3];return buffer<9?mismatch:{match:!0,consumed:buffer,dataOffset:buffer,hasAudioTrack:hasAudio,hasVideoTrack:hasVideo}}}]),FLVDemuxer}();_exports.default=FLVDemuxer});