define(["exports","../utils/logger.js","../utils/utf8-conv.js","../utils/exception.js"],function(_exports,_logger,_utf8Conv,_exception){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var AMF=function(){function AMF(){babelHelpers.classCallCheck(this,AMF)}return babelHelpers.createClass(AMF,null,[{key:"parseScriptData",value:function(arrayBuffer,dataOffset,dataSize){var data={};try{var name=AMF.parseValue(arrayBuffer,dataOffset,dataSize),value=AMF.parseValue(arrayBuffer,dataOffset+name.size,dataSize-name.size);data[name.data]=value.data}catch(e){_logger.default.e("AMF",e.toString())}return data}},{key:"parseObject",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<3)throw new _exception.IllegalStateException("Data not enough when parse ScriptDataObject");var name=AMF.parseString(arrayBuffer,dataOffset,dataSize),arrayBuffer=AMF.parseValue(arrayBuffer,dataOffset+name.size,dataSize-name.size),dataOffset=arrayBuffer.objectEnd;return{data:{name:name.data,value:arrayBuffer.data},size:name.size+arrayBuffer.size,objectEnd:dataOffset}}},{key:"parseVariable",value:function(arrayBuffer,dataOffset,dataSize){return AMF.parseObject(arrayBuffer,dataOffset,dataSize)}},{key:"parseString",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<2)throw new _exception.IllegalStateException("Data not enough when parse String");dataSize=new DataView(arrayBuffer,dataOffset,dataSize).getUint16(0,!1),arrayBuffer=0<dataSize?(0,_utf8Conv.default)(new Uint8Array(arrayBuffer,dataOffset+2,dataSize)):"";return{data:arrayBuffer,size:2+dataSize}}},{key:"parseLongString",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<4)throw new _exception.IllegalStateException("Data not enough when parse LongString");dataSize=new DataView(arrayBuffer,dataOffset,dataSize).getUint32(0,!1),arrayBuffer=0<dataSize?(0,_utf8Conv.default)(new Uint8Array(arrayBuffer,dataOffset+4,dataSize)):"";return{data:arrayBuffer,size:4+dataSize}}},{key:"parseDate",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<10)throw new _exception.IllegalStateException("Data size invalid when parse Date");arrayBuffer=new DataView(arrayBuffer,dataOffset,dataSize),dataOffset=arrayBuffer.getFloat64(0,!1);return dataOffset+=60*arrayBuffer.getInt16(8,!1)*1e3,{data:new Date(dataOffset),size:10}}},{key:"parseValue",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<1)throw new _exception.IllegalStateException("Data not enough when parse Value");var v=new DataView(arrayBuffer,dataOffset,dataSize),offset=1,type=v.getUint8(0),objectEnd=!1;try{switch(type){case 0:value=v.getFloat64(1,!1),offset+=8;break;case 1:var value=!!v.getUint8(1);offset+=1;break;case 2:var amfstr=AMF.parseString(arrayBuffer,dataOffset+1,dataSize-1);value=amfstr.data,offset+=amfstr.size;break;case 3:value={};var terminal=0;for(9==(16777215&v.getUint32(dataSize-4,!1))&&(terminal=3);offset<dataSize-4;){var amfobj=AMF.parseObject(arrayBuffer,dataOffset+offset,dataSize-offset-terminal);if(amfobj.objectEnd)break;value[amfobj.data.name]=amfobj.data.value,offset+=amfobj.size}offset<=dataSize-3&&9==(16777215&v.getUint32(offset-1,!1))&&(offset+=3);break;case 8:value={},offset+=4;var _terminal=0;for(9==(16777215&v.getUint32(dataSize-4,!1))&&(_terminal=3);offset<dataSize-8;){var amfvar=AMF.parseVariable(arrayBuffer,dataOffset+offset,dataSize-offset-_terminal);if(amfvar.objectEnd)break;value[amfvar.data.name]=amfvar.data.value,offset+=amfvar.size}offset<=dataSize-3&&9==(16777215&v.getUint32(offset-1,!1))&&(offset+=3);break;case 9:offset=1,objectEnd=!(value=void 0);break;case 10:value=[];var strictArrayLength=v.getUint32(1,!1);offset+=4;for(var i=0;i<strictArrayLength;i++){var val=AMF.parseValue(arrayBuffer,dataOffset+offset,dataSize-offset);value.push(val.data),offset+=val.size}break;case 11:var date=AMF.parseDate(arrayBuffer,dataOffset+1,dataSize-1);value=date.data,offset+=date.size;break;case 12:var amfLongStr=AMF.parseString(arrayBuffer,dataOffset+1,dataSize-1);value=amfLongStr.data,offset+=amfLongStr.size;break;default:offset=dataSize,_logger.default.w("AMF","Unsupported AMF value type "+type)}}catch(e){_logger.default.e("AMF",e.toString())}return{data:value,size:offset,objectEnd:objectEnd}}}]),AMF}();_exports.default=AMF});