define(["exports","./emby-apiclient/events.js","./emby-apiclient/connectionmanager.js","./common/globalize.js","./common/itemhelper.js","./common/appsettings.js","./common/pluginmanager.js","./browser.js","./layoutmanager.js","./skinmanager.js","./common/usersettings/usersettings.js","./loading/loading.js","./common/servicelocator.js","./viewmanager/viewmanager.js","./backdrop/backdrop.js","./pagejs/page.js","./querystring/querystring.js"],function(_exports,_events,_connectionmanager,_globalize,_itemhelper,_appsettings,_pluginmanager,_browser,_layoutmanager,_skinmanager,_usersettings,_loading,_servicelocator,_viewmanager,_backdrop,_page,_querystring){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var appRouter={showLocalLogin:function(serverId,manualLogin){return show("/startup/"+(manualLogin?"manuallogin":"login")+".html?serverId="+serverId)},showSelectServer:function(){return show(getRouteUrl("selectserver"))},showWelcome:function(){return _servicelocator.appHost.supports("multiserver")?show("/startup/welcome.html"):show("/startup/login.html?serverId="+_connectionmanager.default.currentApiClient().serverId())},showConnectLogin:function(){return show(getRouteUrl("connectlogin"))},showSettings:function(){return show(getRouteUrl("settings",{serverId:_connectionmanager.default.currentApiClient().serverId()}))},showUserMenu:showBackMenuInternal,showSearch:function(){return show(getRouteUrl("search"))},showGuide:function(){return show(appRouter.getRouteUrl("livetv",{serverId:_connectionmanager.default.currentApiClient().serverId(),section:"guide"}))},showLiveTV:function(){return show(appRouter.getRouteUrl("livetv",{serverId:_connectionmanager.default.currentApiClient().serverId()}))},showRecordedTV:function(){return show(appRouter.getRouteUrl("recordedtv",{serverId:_connectionmanager.default.currentApiClient().serverId()}))},showFavorites:function(){return show(getHomeRoute()+"&tab=favorites")},showNowPlaying:function(){return showVideoOsd()}};function showLocalLoginFromApiClient(apiClient){return console.log("appRouter - showLocalLoginFromApiClient: "+apiClient.serverId()),apiClient.getPublicUsers().then(function(users){return users.length?appRouter.showLocalLogin(apiClient.serverId()):appRouter.showLocalLogin(apiClient.serverId(),!0)})}function beginConnectionWizard(){return _backdrop.default.clear(),_loading.default.show(),_servicelocator.appHost.supports("multiserver")?_connectionmanager.default.connect({enableAutoLogin:_appsettings.default.enableAutoLogin()}).then(function(result){return handleConnectionResult(result,!1,!0)}):showLocalLoginFromApiClient(_connectionmanager.default.currentApiClient())}function onRedirectToLocalServerNotNeeded(result){switch(result.State){case"SignedIn":_loading.default.hide(),_skinmanager.default.loadUserSkin();break;case"ServerSignIn":showLocalLoginFromApiClient(result.ApiClient)}}function hasConnectedToLocalServer(connectionResult){connectionResult=connectionResult.ApiClient;if(connectionResult&&_servicelocator.appHost.supports("redirecttolocalserver")){connectionResult=connectionResult.serverId();if(connectionResult)return"true"===_appsettings.default.get(connectionResult+"-haslocalconnection")}}function handleConnectionResult(result,allowServerUpdateNeedAlert,useWelcomeForConnectSignIn,logoutOnCancelledRedirect){switch(console.log("appRouter.handleConnectionResult: "+(result.State||"")),result.State){case"SignedIn":!function(result){var apiClient=result.ApiClient;if(apiClient&&_servicelocator.appHost.supports("redirecttolocalserver")&&_connectionmanager.default.isLoggedIntoConnect()&&!hasConnectedToLocalServer(result))return apiClient.getEndpointInfo().then(function(endpointInfo){return endpointInfo.IsInNetwork&&(endpointInfo=apiClient.serverId()+"-haslocalconnection",_appsettings.default.set(endpointInfo,"true")),onRedirectToLocalServerNotNeeded(result)},function(){return onRedirectToLocalServerNotNeeded(result)});onRedirectToLocalServerNotNeeded(result)}(result);break;case"ServerSignIn":showLocalLoginFromApiClient(result.ApiClient);break;case"ServerSelection":_servicelocator.appHost.supports("multiserver")?appRouter.showSelectServer():showLocalLoginFromApiClient(_connectionmanager.default.currentApiClient());break;case"ConnectSignIn":!0===useWelcomeForConnectSignIn?appRouter.showWelcome():appRouter.showConnectLogin();break;case"ServerUpdateNeeded":!1===allowServerUpdateNeedAlert?appRouter.showSelectServer():(_loading.default.hide(),require(["alert"],function(alert){alert(_globalize.default.translate("ServerUpdateNeeded",'<a href="https://emby.media">https://emby.media</a>')).then(function(){show("/startup/selectserver.html")})}));break;case"Unavailable":_loading.default.hide(),showAlert({text:_globalize.default.translate("MessageUnableToConnectToServer"),title:_globalize.default.translate("HeaderConnectionFailure")})}}var currentViewLoadRequest,isDummyBackToHome,connectionType,firstConnectionResult,loadedTranslations={};function loadPluginTranslations(pageName){if(loadedTranslations[pageName])return Promise.resolve();loadedTranslations[pageName]=!0;var apiClient=_connectionmanager.default.currentApiClient();return apiClient.getJSON(apiClient.getUrl("web/configurationpages",{Name:pageName})).then(function(configPages){if(configPages.length)return function(apiClient,configPage){var languages=configPage.Translations;return languages&&languages.length?(languages=(languages||[]).map(function(i){return{lang:i,path:apiClient.getUrl("web/strings",{PluginId:configPage.PluginId,Locale:i})}}),_globalize.default.loadStrings({name:"plugin-"+configPage.PluginId,translations:languages})):Promise.resolve()}(apiClient,configPages[0])})}function loadContentUrl(ctx,request,signal){var url=request.contentPath&&"function"==typeof request.contentPath?request.contentPath(ctx.querystring):request.contentPath||request.path,url=(url.includes("://")||(url.startsWith("/")||(url="/"+url),url=baseRoute+url),ctx.querystring&&request.enableContentQueryString&&(url+="?"+ctx.querystring),[require(["text!"+url])]);return request.isPluginPage=request.url.toLowerCase().includes("/configurationpage"),request.isPluginPage&&url.push(loadPluginTranslations(function(name,url){name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var name=new RegExp("[\\?&]"+name+"=([^&#]*)","i"),search=window.location.search,index=(search||-1!==(index=window.location.href.indexOf("?"))&&(search=window.location.href.substring(index)),name.exec(url||search));return null==index?"":decodeURIComponent(index[1].replace(/\+/g," "))}("name",request.url))),Promise.all(url).then(function(responses){responses=responses[0][0];return function(ctx,html,request,signal){return request.view=_globalize.default.translateDocument(html),ctx.handled=!0,_viewmanager.default.loadView(request,signal)}(ctx,responses,request,signal)})}function initRoute(ctx,route){function onInitComplete(controllerFactory){return function(ctx,route,controllerFactory){if(isDummyBackToHome&&"home"===route.type)return isDummyBackToHome=!1,Promise.resolve();(function(){var currentRequest=currentViewLoadRequest;currentRequest&&currentRequest.abortController.abort()})(),console.log("appRouter.sendRouteToViewManager - processing path: isBack: "+ctx.isBack);var isBackNav=ctx.isBack,currentRequest=Object.assign({},route),signal=(currentRequest.url=baseRoute+ctx.path,currentRequest.controllerFactory=controllerFactory,currentRequest.state=ctx.state,currentRequest.isBack=isBackNav,currentRequest.abortController=new AbortController,currentRequest.route=route,currentRequest.contextPath=ctx.path,(currentViewLoadRequest=currentRequest).abortController.signal);return isBackNav?_viewmanager.default.tryRestoreView(currentRequest,signal).catch(function(result){if(!signal.aborted)return loadContentUrl(ctx,currentRequest,signal)}):loadContentUrl(ctx,currentRequest,signal)}(ctx,route,controllerFactory)}route.controller?function(route){var url;return"module"===route.controllerType?((url=route.controller).includes("://")||(url="./"+url),Emby.importModule(url)):require([route.controller]).then(function(deps){return deps[0]})}(route).then(onInitComplete):onInitComplete()}function onBeforeExit(e){_browser.default.web0s&&_page.default.restorePreviousState()}function getMaxBandwidth(){var connection=navigator.connection;if(connection){var downlink=connection.downlink;if(downlink&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink=downlink*1e6*.7,downlink=parseInt(downlink);if((downlink=connection.downlinkMax)&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink=downlink*1e6*.7,downlink=parseInt(downlink)}return _browser.default.tv||_browser.default.chromecast?null:15e5}function onApiClientCreated(e,newApiClient){newApiClient.getMaxBandwidth=getMaxBandwidth}function initApiClients(){var currentApiClient=_connectionmanager.default.currentApiClient();currentApiClient&&onApiClientCreated(0,currentApiClient),_events.default.on(_connectionmanager.default,"apiclientcreated",onApiClientCreated)}function onAppResume(){_connectionmanager.default.onAppResume()}function handleRoute(ctx,route){var firstResult=firstConnectionResult;if(firstResult&&(firstConnectionResult=null,!route.anonymous)){if("SignedIn"!==firstResult.State)return void handleConnectionResult(firstResult,!1,!0);if(_servicelocator.appHost.supports("redirecttolocalserver")&&!hasConnectedToLocalServer(firstResult))return void handleConnectionResult(firstResult,!1,!0)}var firstResult=_connectionmanager.default.currentApiClient(),pathname=ctx.pathname.toLowerCase(),currentRouteInfo=(console.log("appRouter - processing path: "+pathname+", isBack: "+ctx.isBack),getCurrentRouteInfo()),currentRouteInfo=!currentRouteInfo||currentRouteInfo.route.startup,shouldExitApp=ctx.isBack&&route.isDefaultRoute&&currentRouteInfo;if(!(shouldExitApp||firstResult&&firstResult.isLoggedIn()||route.anonymous))return console.log("appRouter - route does not allow anonymous access, redirecting to login"),void beginConnectionWizard();if(shouldExitApp)return _servicelocator.appHost.supports("exit")?void _servicelocator.appHost.exit():void 0;if(firstResult&&firstResult.isLoggedIn()){if(console.log("appRouter - user is authenticated"),ctx.isBack&&(route.isDefaultRoute||route.startup)&&!currentRouteInfo)return _servicelocator.appHost.supports("exit")&&!_servicelocator.appHost.supports("exitmenu")?void _servicelocator.appHost.exit():(isDummyBackToHome=!0,_skinmanager.default.loadUserSkin(),_layoutmanager.default.tv?void showBackMenuInternal({}):void(_servicelocator.appHost.supports("exit")&&_servicelocator.appHost.exit()));if(route.isDefaultRoute)return console.log("appRouter - loading skin home page"),void function(ctx){ctx=_querystring.default.parse(ctx.querystring);_skinmanager.default.loadUserSkin({start:ctx.start})}(ctx);if(route.roles)return void function(apiClient,route){return route.roles?apiClient.getCurrentUser().then(function(user){return validateUserAccessToRoute(route,user)}):Promise.resolve()}(firstResult,route).then(function(){initRoute(ctx,route)},beginConnectionWizard)}console.log("appRouter - proceeding to "+pathname),initRoute(ctx,route)}function validateUserAccessToRoute(route,user,loggedInUser){route=(route.roles||"").split(",");return!(route.includes("admin")&&!user.Policy.IsAdministrator)&&!!(!route.includes("EnableUserPreferenceAccess")||user.Policy.EnableUserPreferenceAccess||loggedInUser&&loggedInUser.Policy.IsAdministrator)}function showBackMenuInternal(options){return require(["backMenu"]).then(function(responses){return responses[0](options)})}function getRequestFile(){console.log("router self.location.pathname: "+self.location.pathname);var path=self.location.pathname||"",index=path.lastIndexOf("/");return(path=-1!==index?path.substring(index):"/"+path)&&"/"!==path||(path="/index.html"),console.log("router getRequestFile() result: "+path),path}navigator.connection&&(connectionType=navigator.connection.type,_servicelocator.appHost.supports("multiserver")&&navigator.connection.addEventListener&&navigator.connection.addEventListener("change",function(){var newConnectionType=navigator.connection.type;connectionType&&newConnectionType===connectionType||(connectionType=newConnectionType,_connectionmanager.default.onNetworkChanged())})),console.log("router href: "+self.location.href);var resolveOnNextShow,backdropContainer,backgroundContainer,baseRoute=self.location.href.split("?")[0].replace(getRequestFile(),"");function baseUrl(){return baseRoute}function show(path,options){path.startsWith("/")||path.includes("://")||(path="/"+path);var baseRoute=baseUrl(),baseRoute=(path=path.replace(baseRoute,""),getCurrentRouteInfo());return baseRoute&&baseRoute.contextPath===path&&"home"!==baseRoute.route.type?Promise.resolve():new Promise(function(resolve,reject){resolveOnNextShow=resolve,_page.default.show(path,options)})}function getCurrentRouteInfo(){return _viewmanager.default.currentViewInfo()}function current(){var currentRouteInfo=getCurrentRouteInfo();return currentRouteInfo?currentRouteInfo.route:null}function getHomeRoute(){return _layoutmanager.default.tv&&"horizontal"===_usersettings.default.get("tvhome")?"/home_horiz/home.html":"/home"}function getRouteUrl(item,options){if(item.url)return item.url;var context=(options=options||{})?options.context:null,id=item.Id||item.ItemId,serverId=item.ServerId||options.serverId;if("home"===item)return getHomeRoute();if("search"===item)return _layoutmanager.default.tv?"/search":"/list/list.html?type=search";if("connectlogin"===item)return"/startup/connectlogin.html";if("selectserver"===item)return"/startup/selectserver.html";if("settings"===item)return serverId?"/settings?serverId="+serverId:"/settings";if("wizard"===item)return"/wizardstart.html";if("downloads"===item)return"/list/list.html?parentId=downloads";if("downloadsettings"===item)return"/settings/download.html";if("premiere"===item)return"/embypremiere";if("managedownloads"===item)return"/settings/managedownloads.html";if("manageserver"===item)return"/dashboard";if("recordedtv"===item)return"/livetv?tab=recordings&serverId="+serverId;if("nextup"===item)return"/list/list.html?type=nextup&serverId="+serverId;if("PluginCatalog"===item)return"/plugincatalog";if("LiveTVSetup"===item)return"/livetvsetup/livetvstatus.html";if("livetv"===item||"livetv"===item.CollectionType)return"programs"===options.section?"/livetv?tab=suggestions&serverId="+serverId:"guide"===options.section?"/livetv?tab=guide&serverId="+serverId:"movies"===options.section?"/list/list.html?type=Program&IsMovie=true&serverId="+serverId:"shows"===options.section?"/list/list.html?type=Program&IsSeries=true&IsMovie=false&IsNews=false&serverId="+serverId:"sports"===options.section?"/list/list.html?type=Program&IsSports=true&serverId="+serverId:"kids"===options.section?"/list/list.html?type=Program&IsKids=true&serverId="+serverId:"news"===options.section?"/list/list.html?type=Program&IsNews=true&serverId="+serverId:"onnow"===options.section?"/list/list.html?type=OnNow&serverId="+serverId:"dvrschedule"===options.section?"/livetv?tab=schedule&serverId="+serverId:"/livetv?serverId="+serverId;if("list"===item)return url="/list/list.html?serverId="+serverId+"&type="+options.itemTypes,options.isFavorite&&(url+="&IsFavorite=true"),options.artistId&&(url+="&artistId="+options.artistId),options.albumArtistId&&(url+="&albumArtistId="+options.albumArtistId),url;var url=item.Type||(options?options.itemType:null);if("ActiveSession"===url&&item.NowPlayingItem&&(url=(item=item.NowPlayingItem).Type,id=item.Id),"EmbyConnect"===url)return getRouteUrl("connectlogin");if("Downloads"===url)return getRouteUrl("downloads");if("SelectServer"===url)return getRouteUrl("selectserver");if("ForgotPassword"===url)return"/startup/forgotpassword.html?serverId="+serverId;if("ManualLogin"===url)return _url="/startup/manuallogin.html?serverId="+serverId,item.Username&&(_url+="&user="+encodeURIComponent(item.Username)),_url;if("SeriesTimer"===url)return"/item?seriesTimerId="+id+"&serverId="+serverId;if("Timer"===url)return item.ProgramId?"/item?id="+item.ProgramId+"&serverId="+serverId:"/item?timerId="+id+"&serverId="+serverId;if("Device"===url)return"/devices/device.html?id="+id;if("Log"===url)return"/log?name="+item.Name;if("AddServer"===url)return"/startup/manualserver.html";if("Plugin"===url)return _pluginmanager.default.allowPluginPages(item.Id)?"/"+item.ConfigPageUrl:null;if("User"===url)return"/users/user?userId="+id;if("LiveTVTunerDevice"===url){if(item.SetupUrl){var _url=item.SetupUrl;if(_url)return _url.includes("?")?_url+="&":_url+="?",_url+"id="+id}return"/livetvsetup/livetvtuner.html?id="+id}if("LiveTVGuideSource"===url)return function(url,name,value){return-1===url.indexOf("?")?url+"?"+name+"="+value:url+"&"+name+"="+value}(item.SetupUrl,"id",id);if("GameGenre"===url)return _url="/list/list.html?gameGenreId="+id+"&serverId="+serverId,options.parentId&&(_url+="&parentId="+options.parentId),_url;if("MusicGenre"===url)return _url="/list/list.html?musicGenreId="+id+"&serverId="+serverId,options.parentId&&(_url+="&parentId="+options.parentId),_url;if("Tag"===url||"Studio"===url||"Genre"===url)return _url="/list/list.html?"+item.Type.toLowerCase()+"Id="+id+"&serverId="+serverId,"livetv"===context&&(_url+="Tag"===url?"&type=TvChannel":"&type=Program"),options.parentId&&(_url+="&parentId="+options.parentId),options.itemTypes&&(_url+="&type="+options.itemTypes),_url;if("folders"!==context&&"GameSystem"===item.Type)return"/list/list.html?type=Game&serverId="+serverId+"&parentId="+id;if("folders"!==context&&!_itemhelper.default.isLocalItem(item)){if("games"===item.CollectionType)return"/games?serverId="+serverId+"&parentId="+id;if("musicvideos"===item.CollectionType||"homevideos"===item.CollectionType||"movies"===item.CollectionType||("CollectionFolder"===item.Type||"VirtualFolder"===item.Type)&&!item.CollectionType)return _url="/videos?serverId="+serverId+"&parentId="+id,"latest"===options.section&&"movies"===item.CollectionType&&(_url+="&tab=suggestions"),_url;if("tvshows"===item.CollectionType)return _url="/tv?serverId="+serverId+"&parentId="+id,"latest"===options.section&&(_url+="&tab=suggestions"),_url;if("music"===item.CollectionType||"audiobooks"===item.CollectionType)return"/music?serverId="+serverId+"&parentId="+id}return"PluginCatalogItem"===url?"plugins/install?name="+encodeURIComponent(item.Name)+"&guid="+item.Id:"Playlist"===url||"TvChannel"===url||"BoxSet"===url||"MusicAlbum"===url||"MusicGenre"===url||"Person"===url||"Recording"===url||"MusicArtist"===url?"/item?id="+id+"&serverId="+serverId:"Program"===url?item.AsSeries?"/item?id="+id+"&asSeries=true&serverId="+serverId:"/item?id="+id+"&serverId="+serverId:"Series"===url||"Season"===url||"Episode"===url?"/item?id="+id+(context?"&context="+context:"")+"&serverId="+serverId:item.IsFolder?id?"/list/list.html?parentId="+id+"&serverId="+serverId:"#":"/item?id="+id+"&serverId="+serverId}function showAlert(text){return require(["alert"]).then(function(responses){return responses[0](text)})}function showItem(item,serverId,options){var apiClient;if("string"==typeof item)return(apiClient=serverId?_connectionmanager.default.getApiClient(serverId):_connectionmanager.default.currentApiClient()).getItem(apiClient.getCurrentUserId(),item).then(function(item){return appRouter.showItem(item,options)});if("Plugin"===item.Type){if(!item.ConfigPageUrl)return showAlert(_globalize.default.translate("NoPluginConfigurationMessage"));if(!_pluginmanager.default.allowPluginPages(item.Id))return showAlert(_globalize.default.translate("MessagePluginConfigurationRequiresLocalAccess"))}else{if("ActiveSession"===item.Type)return Promise.reject();if("Server"===item.Type)return Promise.reject()}return 2===arguments.length&&(options=serverId),show(appRouter.getRouteUrl(item,options))}function showVideoOsd(options){return show("/videoosd/videoosd.html")}function addRoute(path,newRoute){path&&newRoute?(0,_page.default)(path,newRoute,handleRoute):function(newRoute){var baseRoute=baseUrl(),path=(path=newRoute.path).replace(baseRoute,"");console.log("Defining route: "+path),addRoute(path,newRoute)}(path)}(baseRoute=baseRoute.split("#")[0]).endsWith("/")&&!baseRoute.endsWith("://")&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.log("router baseUrl: "+baseRoute),document.addEventListener("viewbeforehide",function(){_events.default.trigger(appRouter,"navigate")}),document.addEventListener("viewshow",function(){var resolve=resolveOnNextShow;resolve&&(resolveOnNextShow=null,resolve())}),function(){var baseRoute=self.location.pathname.replace(getRequestFile(),"");baseRoute.lastIndexOf("/")===baseRoute.length-1&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.log("Setting page base to "+baseRoute),_page.default.base(baseRoute)}(),appRouter.addRoute=addRoute,appRouter.back=function(){_page.default.back()},appRouter.show=show,appRouter.start=function(options){return _loading.default.show(),initApiClients(),_events.default.on(_servicelocator.appHost,"beforeexit",onBeforeExit),_events.default.on(_servicelocator.appHost,"resume",onAppResume),_connectionmanager.default.connect({enableAutoLogin:_appsettings.default.enableAutoLogin()}).then(function(result){firstConnectionResult=result,_loading.default.hide(),options=options||{},(0,_page.default)({click:!1!==options.click,hashbang:!1!==options.hashbang})})},appRouter.baseUrl=baseUrl,appRouter.canGoBack=function(){var curr=current();return!!curr&&("home"!==curr.type&&_page.default.canGoBack())},appRouter.current=current,appRouter.beginConnectionWizard=beginConnectionWizard,appRouter.goHome=function(){return show(getHomeRoute())},appRouter.showItem=showItem,appRouter.setTitle=function(title){require(["appHeader"],function(appHeader){appHeader.setTitle(title)})},appRouter.setTransparency=function(level){backdropContainer=backdropContainer||document.querySelector(".backdropContainer"),backgroundContainer=backgroundContainer||document.querySelector(".backgroundContainer"),"full"===level||2===level?(_backdrop.default.externalBackdrop(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):"backdrop"===level||1===level?(_backdrop.default.externalBackdrop(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):(_backdrop.default.externalBackdrop(!1),document.documentElement.classList.remove("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.remove("hide"))},appRouter.getRoutes=function(){return _page.default.getRoutes()},appRouter.getRouteUrl=getRouteUrl,appRouter.getRouteInfo=function(url){return _page.default.getRoute(url)},appRouter.pushState=function(state,title,url){state.navigate=!1,_page.default.pushState(state,title,url)},appRouter.replaceState=function(path,state){_page.default.replace(path,state,!1),_viewmanager.default.replaceCurrentUrl(baseRoute+path)},appRouter.showVideoOsd=showVideoOsd,appRouter.handleAnchorClick=_page.default.handleAnchorClick,appRouter.TransparencyLevel={None:0,Backdrop:1,Full:2},appRouter.invokeShortcut=function(id){return id.startsWith("library-")?showItem((id=(id=id.replace("library-","")).split("_"))[0],id[1]):id.startsWith("item-")?showItem((id=(id=id.replace("item-","")).split("_"))[0],id[1]):(id=id.split("_"),show(appRouter.getRouteUrl(id[0],{serverId:id[1]})))},appRouter.logout=function(){require(["playbackManager"],function(playbackManager){_loading.default.show(),playbackManager.stop(),_connectionmanager.default.logout().then(beginConnectionWizard)})},appRouter.handleConnectionResult=handleConnectionResult,appRouter.validateUserAccessToRoute=validateUserAccessToRoute,appRouter.showServerLogin=showLocalLoginFromApiClient,self.Emby.Page=appRouter,self.Emby.TransparencyLevel=appRouter.TransparencyLevel,_exports.default=appRouter});