define(["tabbedView","connectionManager","registrationServices","require","globalize","userSettings","emby-itemscontainer","emby-button","emby-scroller","emby-linkbutton"],function(TabbedView,connectionManager,registrationServices,require,globalize,userSettings){"use strict";function getDefaultSubviews(){return["recordings","schedule","series"]}function hideShowAll(view,className,hide){for(var elems=view.querySelectorAll("."+className),i=0,length=elems.length;i<length;i++)hide?elems[i].classList.add("hide"):elems[i].classList.remove("hide")}function validateUnlock(view,showDialog){return registrationServices.validateFeature("livetv",{showDialog:showDialog,viewOnly:!0}).then(function(){hideShowAll(view,"tabContent",!1),view.querySelector(".unlockContainer").classList.add("hide")},function(){hideShowAll(view,"tabContent",!0),view.querySelector(".unlockContainer").classList.remove("hide"),view.querySelector(".btnUnlock").focus()})}function LiveTVView(view,params){TabbedView.call(this,view,params),view.querySelector(".unlockText").innerHTML=globalize.translate("LiveTvRequiresUnlock"),view.querySelector(".btnUnlockText").innerHTML=globalize.translate("HeaderBecomeProjectSupporter"),validateUnlock(view,!1),view.querySelector(".btnUnlock").addEventListener("click",function(){validateUnlock(view,!0)})}return Object.assign(LiveTVView.prototype,TabbedView.prototype),LiveTVView.prototype.getTabs=function(){var item=(item=this.item)&&item.Subviews||getDefaultSubviews();return[{name:globalize.translate("Programs"),id:"suggestions"},{name:globalize.translate("Guide"),id:"guide"},{name:globalize.translate("Channels"),id:"channels"},{name:globalize.translate("Tags"),id:"tags",enabled:item.includes("tags")},{name:globalize.translate("Recordings"),id:"recordings"},{name:globalize.translate("Schedule"),id:"schedule"},{name:globalize.translate("Series"),id:"series"}]},LiveTVView.prototype.validateTabLoad=function(index){return validateUnlock(this.view,!1)},LiveTVView.prototype.getDefaultTabUserSettingsValue=function(folderId){return userSettings.get("landing-livetv")},LiveTVView.prototype.getTitle=function(){return{Name:globalize.translate("LiveTV"),CollectionType:"livetv",Id:"livetv",ServerId:this.params.serverId}},LiveTVView.prototype.loadTabController=function(id){switch(id){case"suggestions":return require(["./suggestions"]);case"guide":return require(["./guide"]);case"channels":return require(["./channels"]);case"recordings":return require(["./recordings"]);case"schedule":return require(["./schedule"]);case"collections":return require(["collectionsTab"]);case"tags":return require(["tagsTab"]);case"series":return require(["./series"]);default:throw new Error("tab not found: "+id)}},LiveTVView.prototype.getItem=function(){var params=this.params,params=connectionManager.getApiClient(params.serverId);return params.getJSON(params.getUrl("LiveTV/Folder"))},LiveTVView.prototype.getTabControllerOptions=function(id){var options=TabbedView.prototype.getTabControllerOptions.apply(this,arguments);return"tags"===id&&(options.tagsApiClientMethod="getLiveTvChannelTags",options.prefixesApiClientMethod="getLiveTvChannelTagPrefixes"),options},LiveTVView});