#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-3D8ZRgZcHlJAITx4gQroVY
key:                  dhall-1.41.2-3D8ZRgZcHlJAITx4gQroVY
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  c217dabc73cd1dc4ad88bc0b631e1da9
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.0.2/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-3D8ZRgZcHlJAITx4gQroVY
depends:
    Diff-0.4.1-2jMKpzJJQmAHzE6LyB7Qjk
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL
    atomic-write-0.2.0.7-8J2BzEZ0Zw2DkYNvrsyfpc base-4.15.1.0
    base16-bytestring-1.0.2.0-JAhsVwuAYUHf0LicTQmUd
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns
    cborg-0.2.8.0-7CnZXeqqwb6HAtO8qRWSoe
    cborg-json-0.2.5.0-1IyewkypEiPFJgqjxCCRNy containers-0.6.4.1
    contravariant-1.5.5-FtJyCLyWfutGN2UWoJs8qd
    cryptohash-sha256-0.11.102.1-8ZeO4nK1S0cB7jsEy9ybtK
    data-fix-0.3.2-LxCSJ0DXV5oBUng5yBCchq deepseq-1.4.5.0
    directory-1.3.6.2 dotgen-0.4.3-JbRUtf7kscIJibZz2RQNw
    either-5.0.2-CESQcB8iry59WM5GQWasBQ exceptions-0.10.4
    filepath-1.4.2.1 half-0.3.1-EPYmmhgK6855HBsjgKDFZS
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F haskeline-0.8.2
    http-client-0.7.13.1-IUPmZAWhHcS7Jd2UKXuikW
    http-client-tls-0.3.6.1-KvEPoRWqIbH3HwtuX8a907
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    lens-family-core-2.1.2-JgL24qTIUymKZLaMFOVhTK
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf
    mmorph-1.2.0-2iQgHTViuScASaZTADZaI1 mtl-2.2.2
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB
    parsers-0.12.11-AI6ghXXC7XpBDY10swIT2W
    pretty-simple-4.1.2.0-1OeFrj2zLl44a5ajMTxBMM
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP
    prettyprinter-ansi-terminal-1.1.3-1EdU9xpSi4b31RFlIAEoGC
    profunctors-5.6.2-3xiO6DN2a4J67KN3MHdaHJ
    repline-0.4.2.0-AbdnKl4MT5R8rpoSYZ99OS
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    serialise-0.2.6.0-7M0taRnX2M5IWZQAWPOVep template-haskell-2.17.0.0
    text-1.2.5.0 text-manipulate-0.3.1.0-HSMNFOM0ZUf7PNq7Mytxd4
    text-short-0.1.5-BpUmYQpnlq5B0lAlfuthm
    th-lift-instances-0.1.20-5NHl0zPpjKhEmiENmzVd0c time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    uri-encode-1.5.0.7-2ALaduS9gfJKuBSGycHVVs
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

