/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.image;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.imageview.ImageEditor;

public class ImageEditorPart
extends EditorPart
implements IRefreshablePart {
    private static final Log log = Log.getLog(ImageEditorPart.class);
    private ImageEditor imageViewer;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.imageViewer = new ImageEditor(parent, 0);
        this.loadImage();
    }

    private void loadImage() {
        block13: {
            if (this.imageViewer == null || this.imageViewer.isDisposed()) {
                return;
            }
            if (this.getEditorInput() instanceof IPathEditorInput) {
                try {
                    IPath absolutePath = ((IPathEditorInput)this.getEditorInput()).getPath();
                    File localFile = absolutePath.toFile();
                    if (!localFile.exists()) break block13;
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (FileInputStream inputStream = new FileInputStream(localFile);){
                        this.imageViewer.loadImage(inputStream);
                        this.imageViewer.update();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't load image contents", (Throwable)e);
                }
            }
        }
    }

    public void setFocus() {
        this.imageViewer.setFocus();
    }

    public String getTitle() {
        return "Image";
    }

    public Image getTitleImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_IMAGE);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        this.refreshImage();
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    private void refreshImage() {
        UIUtils.asyncExec(this::loadImage);
    }
}

