/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.IOException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementation;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;

public class SSHTunnelImpl
implements DBWTunnel {
    private static final Log log = Log.getLog(SSHTunnelImpl.class);
    private static final String DEF_IMPLEMENTATION = "jsch";
    private DBWHandlerConfiguration configuration;
    private SSHImplementation implementation;

    public SSHImplementation getImplementation() {
        return this.implementation;
    }

    public DBPConnectionConfiguration initializeHandler(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        this.configuration = configuration;
        String implId = configuration.getStringProperty("implementation");
        if (CommonUtils.isEmpty((String)implId)) {
            implId = DEF_IMPLEMENTATION;
        }
        try {
            SSHImplementationDescriptor implDesc = SSHImplementationRegistry.getInstance().getDescriptor(implId);
            if (implDesc == null) {
                implDesc = SSHImplementationRegistry.getInstance().getDescriptor(DEF_IMPLEMENTATION);
            }
            if (implDesc == null) {
                throw new DBException("Can't find SSH tunnel implementation '" + implId + "'");
            }
            if (this.implementation == null || this.implementation.getClass() != implDesc.getImplClass().getObjectClass()) {
                this.implementation = implDesc.createImplementation();
            }
        }
        catch (Throwable e) {
            throw new DBException("Can't create SSH tunnel implementation '" + implId + "'", e);
        }
        return this.implementation.initTunnel(monitor, configuration, connectionInfo);
    }

    public void closeTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.implementation != null) {
            this.implementation.closeTunnel(monitor);
        }
    }

    public boolean matchesParameters(String host, int port) {
        if (host.equals(this.configuration.getStringProperty("host"))) {
            int sshPort = this.configuration.getIntProperty("port");
            return sshPort == port;
        }
        return false;
    }

    public DBWTunnel.AuthCredentials getRequiredCredentials(DBWHandlerConfiguration configuration) {
        return this.getRequiredCredentials(configuration, null);
    }

    public DBWTunnel.AuthCredentials getRequiredCredentials(DBWHandlerConfiguration configuration, @Nullable String prefix) {
        String start = prefix;
        if (start == null) {
            start = "";
        }
        if (!configuration.isEnabled() || !configuration.isSecured()) {
            return DBWTunnel.AuthCredentials.NONE;
        }
        if (configuration.getBooleanProperty(String.valueOf(start) + "save-password")) {
            return DBWTunnel.AuthCredentials.NONE;
        }
        String sshAuthType = configuration.getStringProperty(String.valueOf(start) + "authType");
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        if (sshAuthType != null) {
            authType = SSHConstants.AuthType.valueOf(sshAuthType);
        }
        if (authType == SSHConstants.AuthType.PUBLIC_KEY) {
            byte[] pkBinary;
            String privKeyValue = configuration.getSecureProperty(String.valueOf(start) + "keyValue");
            if (privKeyValue != null && SSHUtils.isKeyEncrypted(pkBinary = Base64.decode((String)privKeyValue))) {
                return DBWTunnel.AuthCredentials.PASSWORD;
            }
            String privKeyPath = configuration.getStringProperty(String.valueOf(start) + "keyPath");
            if (!CommonUtils.isEmpty((String)privKeyPath) && SSHUtils.isKeyFileEncrypted(privKeyPath)) {
                return DBWTunnel.AuthCredentials.PASSWORD;
            }
            return DBWTunnel.AuthCredentials.NONE;
        }
        if (authType == SSHConstants.AuthType.AGENT) {
            return DBWTunnel.AuthCredentials.NONE;
        }
        return DBWTunnel.AuthCredentials.CREDENTIALS;
    }

    public void invalidateHandler(DBRProgressMonitor monitor, DBPDataSource dataSource) throws DBException, IOException {
        if (this.implementation != null) {
            RuntimeUtils.runTask(monitor1 -> {
                monitor1.beginTask("Invalidate SSH tunnel", 1);
                try {
                    try {
                        this.implementation.invalidateTunnel(monitor1);
                    }
                    catch (Exception e) {
                        log.debug((Object)"Error invalidating SSH tunnel. Closing.", (Throwable)e);
                        try {
                            this.closeTunnel(monitor);
                        }
                        catch (Exception e1) {
                            log.error((Object)"Error closing broken tunnel", (Throwable)e1);
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }, (String)("Ping SSH tunnel " + dataSource.getContainer().getName()), (long)dataSource.getContainer().getPreferenceStore().getInt("connection.validation.timeout"));
        }
    }
}

