/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalViewer;
import org.eclipse.gef3.internal.GEFMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class SelectAllAction
extends Action {
    private IWorkbenchPart part;

    public SelectAllAction(IWorkbenchPart part) {
        this.part = part;
        this.setText(GEFMessages.SelectAllAction_Label);
        this.setToolTipText(GEFMessages.SelectAllAction_Tooltip);
        this.setId(ActionFactory.SELECT_ALL.getId());
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection(this.getSelectableEditParts(viewer)));
        }
    }

    private List getSelectableEditParts(GraphicalViewer viewer) {
        ArrayList<EditPart> selectableChildren = new ArrayList<EditPart>();
        List children = viewer.getContents().getChildren();
        for (Object child : children) {
            EditPart childPart;
            if (!(child instanceof EditPart) || !(childPart = (EditPart)child).isSelectable()) continue;
            selectableChildren.add(childPart);
        }
        return selectableChildren;
    }
}

