/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.ChopboxAnchor;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.PolylineConnection;
import org.eclipse.draw2dl.XYAnchor;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.AccessibleAnchorProvider;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.LayerConstants;
import org.eclipse.gef3.NodeEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef3.tools.SelectEditPartTracker;

public abstract class AbstractConnectionEditPart
extends AbstractGraphicalEditPart
implements ConnectionEditPart,
LayerConstants {
    private static final ConnectionAnchor DEFAULT_SOURCE_ANCHOR = new XYAnchor(new Point(10, 10));
    private static final ConnectionAnchor DEFAULT_TARGET_ANCHOR = new XYAnchor(new Point(100, 100));
    private EditPart sourceEditPart;
    private EditPart targetEditPart;

    protected void activateFigure() {
        this.getLayer("Connection Layer").add(this.getFigure());
    }

    @Override
    public void addNotify() {
        this.activateFigure();
        super.addNotify();
    }

    @Override
    protected IFigure createFigure() {
        return new PolylineConnection();
    }

    protected void deactivateFigure() {
        this.getLayer("Connection Layer").remove(this.getFigure());
        this.getConnectionFigure().setSourceAnchor(null);
        this.getConnectionFigure().setTargetAnchor(null);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == AccessibleAnchorProvider.class) {
            return new DefaultAccessibleAnchorProvider();
        }
        return super.getAdapter(adapter);
    }

    public Connection getConnectionFigure() {
        return (Connection)this.getFigure();
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker(this);
    }

    @Override
    public EditPart getSource() {
        return this.sourceEditPart;
    }

    @Override
    public EditPart getTarget() {
        return this.targetEditPart;
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        if (this.getSource() != null) {
            if (this.getSource() instanceof NodeEditPart) {
                NodeEditPart editPart = (NodeEditPart)this.getSource();
                return editPart.getSourceConnectionAnchor(this);
            }
            IFigure f = ((GraphicalEditPart)this.getSource()).getFigure();
            return new ChopboxAnchor(f);
        }
        return DEFAULT_SOURCE_ANCHOR;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        if (this.getTarget() != null) {
            if (this.getTarget() instanceof NodeEditPart) {
                NodeEditPart editPart = (NodeEditPart)this.getTarget();
                return editPart.getTargetConnectionAnchor(this);
            }
            IFigure f = ((GraphicalEditPart)this.getTarget()).getFigure();
            return new ChopboxAnchor(f);
        }
        return DEFAULT_TARGET_ANCHOR;
    }

    @Override
    public void refresh() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refresh();
    }

    protected void refreshSourceAnchor() {
        this.getConnectionFigure().setSourceAnchor(this.getSourceConnectionAnchor());
    }

    protected void refreshTargetAnchor() {
        this.getConnectionFigure().setTargetAnchor(this.getTargetConnectionAnchor());
    }

    @Override
    public void removeNotify() {
        this.deactivateFigure();
        super.removeNotify();
    }

    @Override
    public void setParent(EditPart parent) {
        boolean becomingNull;
        boolean wasNull = this.getParent() == null;
        boolean bl = becomingNull = parent == null;
        if (becomingNull && !wasNull) {
            this.removeNotify();
        }
        super.setParent(parent);
        if (wasNull && !becomingNull) {
            this.addNotify();
        }
    }

    @Override
    public void setSource(EditPart editPart) {
        if (this.sourceEditPart == editPart) {
            return;
        }
        this.sourceEditPart = editPart;
        if (this.sourceEditPart != null) {
            this.setParent(this.sourceEditPart.getRoot());
        } else if (this.getTarget() == null) {
            this.setParent(null);
        }
        if (this.sourceEditPart != null && this.targetEditPart != null) {
            this.refresh();
        }
    }

    @Override
    public void setTarget(EditPart editPart) {
        if (this.targetEditPart == editPart) {
            return;
        }
        this.targetEditPart = editPart;
        if (editPart != null) {
            this.setParent(editPart.getRoot());
        } else if (this.getSource() == null) {
            this.setParent(null);
        }
        if (this.sourceEditPart != null && this.targetEditPart != null) {
            this.refresh();
        }
    }

    protected final class DefaultAccessibleAnchorProvider
    implements AccessibleAnchorProvider {
        DefaultAccessibleAnchorProvider() {
        }

        @Override
        public List getSourceAnchorLocations() {
            ArrayList<Point> list = new ArrayList<Point>();
            if (AbstractConnectionEditPart.this.getFigure() instanceof Connection) {
                Point p = ((Connection)AbstractConnectionEditPart.this.getFigure()).getPoints().getMidpoint();
                AbstractConnectionEditPart.this.getFigure().translateToAbsolute((Translatable)p);
                list.add(p);
            }
            return list;
        }

        @Override
        public List getTargetAnchorLocations() {
            return this.getSourceAnchorLocations();
        }
    }
}

