/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.app;

import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.secret.DBPSecretHolder;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;

public interface DBPDataSourceRegistry
extends DBPObject,
DBPSecretHolder {
    public static final String LEGACY_CONFIG_FILE_PREFIX = ".dbeaver-data-sources";
    public static final String LEGACY_CONFIG_FILE_EXT = ".xml";
    public static final String LEGACY_CONFIG_FILE_NAME = ".dbeaver-data-sources.xml";
    public static final String MODERN_CONFIG_FILE_PREFIX = "data-sources";
    public static final String MODERN_CONFIG_FILE_EXT = ".json";
    public static final String MODERN_CONFIG_FILE_NAME = "data-sources.json";
    public static final String CREDENTIALS_CONFIG_FILE_PREFIX = "credentials-config";
    public static final String CREDENTIALS_CONFIG_FILE_EXT = ".json";
    public static final String CREDENTIALS_CONFIG_FILE_NAME = "credentials-config.json";

    public DBPProject getProject();

    @Nullable
    public DBPDataSourceContainer getDataSource(String var1);

    @Nullable
    public DBPDataSourceContainer getDataSource(DBPDataSource var1);

    @Nullable
    public DBPDataSourceContainer findDataSourceByName(String var1);

    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSourcesByProfile(@NotNull DBWNetworkProfile var1);

    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSources();

    @NotNull
    public DBPDataSourceContainer createDataSource(DBPDriver var1, DBPConnectionConfiguration var2);

    @NotNull
    public DBPDataSourceContainer createDataSource(DBPDataSourceContainer var1);

    public void addDataSourceListener(@NotNull DBPEventListener var1);

    public boolean removeDataSourceListener(@NotNull DBPEventListener var1);

    public void addDataSource(@NotNull DBPDataSourceContainer var1) throws DBException;

    public void removeDataSource(@NotNull DBPDataSourceContainer var1);

    public void updateDataSource(@NotNull DBPDataSourceContainer var1) throws DBException;

    @NotNull
    public List<? extends DBPDataSourceFolder> getAllFolders();

    @NotNull
    public List<? extends DBPDataSourceFolder> getRootFolders();

    public DBPDataSourceFolder getFolder(String var1);

    public DBPDataSourceFolder addFolder(DBPDataSourceFolder var1, String var2);

    public void removeFolder(DBPDataSourceFolder var1, boolean var2);

    @Nullable
    public DBSObjectFilter getSavedFilter(String var1);

    @NotNull
    public List<DBSObjectFilter> getSavedFilters();

    public void updateSavedFilter(DBSObjectFilter var1);

    public void removeSavedFilter(String var1);

    @Nullable
    public DBWNetworkProfile getNetworkProfile(String var1);

    @NotNull
    public List<DBWNetworkProfile> getNetworkProfiles();

    public void updateNetworkProfile(DBWNetworkProfile var1);

    public void removeNetworkProfile(DBWNetworkProfile var1);

    @Nullable
    public DBAAuthProfile getAuthProfile(String var1);

    @NotNull
    public List<DBAAuthProfile> getAllAuthProfiles();

    @NotNull
    public List<DBAAuthProfile> getApplicableAuthProfiles(@Nullable DBPDriver var1);

    public void updateAuthProfile(DBAAuthProfile var1);

    public void removeAuthProfile(DBAAuthProfile var1);

    public void flushConfig();

    public void refreshConfig();

    public Throwable getLastError();

    public boolean hasError();

    public void checkForErrors() throws DBException;

    public void notifyDataSourceListeners(DBPEvent var1);

    @Nullable
    public DBACredentialsProvider getAuthCredentialsProvider();

    public void setAuthCredentialsProvider(DBACredentialsProvider var1);

    public Set<DBPDataSourceFolder> getTemporaryFolders();

    public void dispose();
}

