/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.utils.CommonUtils;

public final class DBInfoUtils {
    public static final Gson SECRET_GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().create();

    public static String makeObjectDescription(@NotNull DBRProgressMonitor monitor, DBPNamedObject object, boolean html) {
        StringBuilder info = new StringBuilder();
        DBPNamedObject targetObject = object;
        if (object instanceof DBSObjectReference) {
            try {
                targetObject = ((DBSObjectReference)object).resolveObject(monitor);
            }
            catch (DBException e) {
                StringWriter buf = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)buf, true));
                info.append(buf.toString());
            }
        }
        PropertyCollector collector = new PropertyCollector(targetObject, false);
        collector.collectProperties();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = collector.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propString;
            DBPPropertyDescriptor descriptor = dBPPropertyDescriptorArray[n2];
            Object propValue = collector.getPropertyValue(null, descriptor.getId());
            if (propValue != null && !CommonUtils.isEmpty((String)(propString = propValue instanceof DBPNamedObject ? ((DBPNamedObject)propValue).getName() : DBValueFormatting.getDefaultValueDisplayString(propValue, DBDDisplayFormat.UI)))) {
                if (html) {
                    info.append("<b>").append(descriptor.getDisplayName()).append(":  </b>");
                    info.append(propString);
                    info.append("<br>");
                } else {
                    info.append(descriptor.getDisplayName()).append(": ").append(propString).append("\n");
                }
            }
            ++n2;
        }
        return info.toString();
    }
}

