/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingConfigDialog;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.utils.CommonUtils;

public class GroupingPanel
implements IResultSetPanel {
    private static final String PANEL_ID = "results-grouping";
    private static final String SETTINGS_SECTION_GROUPING = "panel-results-grouping";
    private IResultSetPresentation presentation;
    private IDialogSettings panelSettings;
    private GroupingResultsContainer resultsContainer;
    private Composite groupingPlaceholder;
    private IResultSetListener ownerListener;

    @Override
    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_GROUPING);
        this.loadSettings();
        this.groupingPlaceholder = new Composite(parent, 0);
        this.groupingPlaceholder.setLayout((Layout)new FillLayout());
        this.ownerListener = new ResultSetListenerAdapter(){

            @Override
            public void handleResultSetLoad() {
                GroupingPanel.this.refresh(true);
            }
        };
        return this.groupingPlaceholder;
    }

    private GroupingResultsContainer getGroupingResultsContainer() {
        if (this.resultsContainer == null) {
            this.resultsContainer = new GroupingResultsContainer(this.groupingPlaceholder, this.presentation);
            IResultSetController groupingViewer = this.resultsContainer.getResultSetController();
            groupingViewer.getControl().addDisposeListener(e -> this.presentation.getController().removeListener(this.ownerListener));
            ResultSetListenerAdapter groupingResultsListener = new ResultSetListenerAdapter(){

                @Override
                public void handleResultSetLoad() {
                    GroupingPanel.this.updateControls();
                }

                @Override
                public void handleResultSetSelectionChange(SelectionChangedEvent event) {
                    GroupingPanel.this.updateControls();
                }
            };
            groupingViewer.addListener(groupingResultsListener);
        }
        return this.resultsContainer;
    }

    @Override
    public boolean isDirty() {
        return !this.getGroupingResultsContainer().getGroupAttributes().isEmpty();
    }

    private void updateControls() {
        this.presentation.getController().updatePanelActions();
    }

    private void loadSettings() {
        this.panelSettings.getSection("groups");
    }

    private void saveSettings() {
        UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"groups");
    }

    @Override
    public void activatePanel() {
        this.getGroupingResultsContainer();
        this.refresh(false);
        this.groupingPlaceholder.layout(true, true);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void refresh(boolean force) {
        if (!force) {
            return;
        }
        GroupingResultsContainer groupingResultsContainer = this.getGroupingResultsContainer();
        if (this.presentation.getController().getModel().isMetadataChanged()) {
            groupingResultsContainer.clearGrouping();
        } else {
            try {
                groupingResultsContainer.rebuildGrouping();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Grouping error", "Can't refresh grouping query", (Throwable)e);
            }
        }
        this.groupingPlaceholder.layout(true, true);
    }

    public void contributeActions(IContributionManager manager) {
        this.fillToolBar(manager);
    }

    private void fillToolBar(IContributionManager contributionManager) {
        contributionManager.add((IAction)new DefaultSortingAction());
        contributionManager.add((IAction)new DuplicatesOnlyAction());
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new EditColumnsAction(this.getGroupingResultsContainer()));
        contributionManager.add((IAction)new DeleteColumnAction(this.getGroupingResultsContainer()));
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new ClearGroupingAction(this.getGroupingResultsContainer()));
    }

    class ChangeSortingAction
    extends Action {
        private final Boolean descending;

        ChangeSortingAction(Boolean descending) {
            super(descending == null ? ResultSetMessages.grouping_panel_sorting_action_unsorted : (descending != false ? ResultSetMessages.grouping_panel_sorting_action_decending : ResultSetMessages.grouping_panel_sorting_action_ascending), 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)(descending == null ? UIIcon.SORT_UNKNOWN : (descending != false ? UIIcon.SORT_INCREASE : UIIcon.SORT_DECREASE))));
            this.descending = descending;
        }

        public boolean isChecked() {
            DBPDataSource dataSource = GroupingPanel.this.getGroupingResultsContainer().getDataContainer().getDataSource();
            if (dataSource == null) {
                return false;
            }
            String defSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
            if (CommonUtils.isEmpty((String)defSorting)) {
                return this.descending == null;
            }
            if (defSorting.equals("ASC")) {
                return Boolean.FALSE.equals(this.descending);
            }
            return Boolean.TRUE.equals(this.descending);
        }

        public void run() {
            String newValue = this.descending == null ? "" : (this.descending != false ? "DESC" : "ASC");
            DBPDataSource dataSource = GroupingPanel.this.getGroupingResultsContainer().getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            dataSource.getContainer().getPreferenceStore().setValue("resultset.grouping.defaultSorting", newValue);
            dataSource.getContainer().persistConfiguration();
            try {
                GroupingPanel.this.getGroupingResultsContainer().rebuildGrouping();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(ResultSetMessages.grouping_panel_error_title, ResultSetMessages.grouping_panel_error_change_sort_message, (Throwable)e);
            }
        }
    }

    static class ClearGroupingAction
    extends GroupingAction {
        ClearGroupingAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, ResultSetMessages.controls_resultset_grouping_clear, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ERASE));
        }

        public boolean isEnabled() {
            return !this.groupingResultsContainer.getGroupAttributes().isEmpty();
        }

        public void run() {
            this.groupingResultsContainer.clearGrouping();
            this.groupingResultsContainer.getOwnerPresentation().getController().updatePanelActions();
        }
    }

    class DefaultSortingAction
    extends Action {
        DefaultSortingAction() {
            super(ResultSetMessages.controls_resultset_grouping_default_sorting, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SORT_CONFIG));
        }

        public IMenuCreator getMenuCreator() {
            return new MenuCreator(control -> {
                MenuManager menuManager = new MenuManager();
                menuManager.add((IAction)new ChangeSortingAction(null));
                menuManager.add((IAction)new ChangeSortingAction(Boolean.FALSE));
                menuManager.add((IAction)new ChangeSortingAction(Boolean.TRUE));
                return menuManager;
            });
        }
    }

    static class DeleteColumnAction
    extends GroupingAction {
        DeleteColumnAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, ResultSetMessages.controls_resultset_grouping_remove_column, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ACTION_OBJECT_DELETE));
        }

        public boolean isEnabled() {
            return !this.groupingResultsContainer.getResultSetController().getSelection().isEmpty();
        }

        public void run() {
            List<String> attributes;
            DBDAttributeBinding currentAttribute = this.groupingResultsContainer.getResultSetController().getActivePresentation().getCurrentAttribute();
            if (currentAttribute != null && (this.groupingResultsContainer.removeGroupingAttribute(attributes = Collections.singletonList(currentAttribute.getFullyQualifiedName(DBPEvaluationContext.UI))) || this.groupingResultsContainer.removeGroupingFunction(attributes))) {
                try {
                    this.groupingResultsContainer.rebuildGrouping();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Grouping error", "Can't change grouping query", (Throwable)e);
                }
            }
        }
    }

    class DuplicatesOnlyAction
    extends Action {
        DuplicatesOnlyAction() {
            super(ResultSetMessages.controls_resultset_grouping_show_duplicates_only, 2);
            this.updateImage();
        }

        private void updateImage() {
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DUPS_RESTRICTED));
        }

        public boolean isChecked() {
            DBPDataSource dataSource = GroupingPanel.this.getGroupingResultsContainer().getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showDuplicatesOnly");
        }

        public void run() {
            boolean newValue = !this.isChecked();
            DBPDataSource dataSource = GroupingPanel.this.getGroupingResultsContainer().getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            dataSource.getContainer().getPreferenceStore().setValue("resultset.grouping.showDuplicatesOnly", newValue);
            try {
                GroupingPanel.this.getGroupingResultsContainer().rebuildGrouping();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(ResultSetMessages.grouping_panel_error_title, ResultSetMessages.grouping_panel_error_change_duplicate_presentation_message, (Throwable)e);
            }
        }
    }

    static class EditColumnsAction
    extends GroupingAction {
        EditColumnsAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, ResultSetMessages.controls_resultset_grouping_edit, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_ADD));
        }

        public void run() {
            GroupingConfigDialog dialog = new GroupingConfigDialog(this.groupingResultsContainer.getResultSetController().getControl().getShell(), this.groupingResultsContainer);
            if (dialog.open() == 0) {
                try {
                    this.groupingResultsContainer.rebuildGrouping();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Grouping error", "Can't change grouping settings", (Throwable)e);
                }
            }
        }
    }

    static abstract class GroupingAction
    extends Action {
        final GroupingResultsContainer groupingResultsContainer;

        GroupingAction(GroupingResultsContainer groupingResultsContainer, String text, ImageDescriptor image) {
            super(text, image);
            this.groupingResultsContainer = groupingResultsContainer;
        }
    }

    private class PresentationToggleAction
    extends Action {
        private final ResultSetPresentationDescriptor presentationDescriptor;

        public PresentationToggleAction(ResultSetPresentationDescriptor presentationDescriptor) {
            super(presentationDescriptor.getLabel(), 8);
            this.presentationDescriptor = presentationDescriptor;
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)presentationDescriptor.getIcon()));
            this.setToolTipText(presentationDescriptor.getDescription());
        }

        public boolean isChecked() {
            return this.presentationDescriptor.matches(GroupingPanel.this.getGroupingResultsContainer().getResultSetController().getActivePresentation().getClass());
        }

        public void run() {
            ((ResultSetViewer)GroupingPanel.this.getGroupingResultsContainer().getResultSetController()).switchPresentation(this.presentationDescriptor);
        }
    }
}

