/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelDescriptor;
import org.jkiss.utils.CommonUtils;

public class ResultSetHandlerTogglePanel
extends AbstractHandler
implements IElementUpdater {
    public static final String CMD_TOGGLE_PANEL = "org.jkiss.dbeaver.core.resultset.grid.togglePanel";
    public static final String PARAM_PANEL_ID = "panelId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        String panelId = event.getParameter(PARAM_PANEL_ID);
        if (panelId == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.grid.togglePanel": {
                ResultSetHandlerTogglePanel.toggleResultsPanel(resultSet, panelId);
            }
        }
        return null;
    }

    private static void toggleResultsPanel(IResultSetController resultSet, String panelId) {
        boolean isVisible = ((ResultSetViewer)resultSet).isPanelVisible(panelId);
        if (isVisible) {
            ((ResultSetViewer)resultSet).closePanel(panelId);
        } else {
            resultSet.activatePanel(panelId, true, true);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        String panelId = (String)parameters.get(PARAM_PANEL_ID);
        if (panelId != null) {
            IResultSetController resultSet;
            IWorkbenchPart workbenchPart;
            ResultSetPanelDescriptor panel = ResultSetPresentationRegistry.getInstance().getPanel(panelId);
            if (panel != null) {
                element.setText(panel.getLabel());
                if (!CommonUtils.isEmpty((String)panel.getDescription())) {
                    element.setTooltip(panel.getDescription());
                }
            }
            if ((workbenchPart = (IWorkbenchPart)element.getServiceLocator().getService(IWorkbenchPart.class)) != null && (resultSet = ResultSetHandlerMain.getActiveResultSet(workbenchPart)) != null) {
                element.setChecked(((ResultSetViewer)resultSet).isPanelVisible(panelId));
            }
        }
    }

    public static class PanelIdParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            for (ResultSetPanelDescriptor pd : ResultSetPresentationRegistry.getInstance().getAllPanels()) {
                values.put(pd.getLabel(), pd.getId());
            }
            return values;
        }
    }
}

