/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLEditor
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageSQLEditor.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqleditor";
    private static final String TEXT_EDITOR_PAGE_ID = "org.eclipse.ui.preferencePages.GeneralTextEditor";
    private Combo editorSeparateConnectionCombo;
    private Button connectOnActivationCheck;
    private Button connectOnExecuteCheck;
    private Button autoSaveOnChange;
    private Button saveOnQueryExecution;
    private Button autoSaveOnClose;
    private Button autoSaveActiveSchema;
    private Button closeTabOnErrorCheck;
    private Combo resultsOrientationCombo;
    private Button autoOpenOutputView;
    private Button replaceCurrentTab;
    private static final List<ModelPreferences.SeparateConnectionBehavior> editorUseSeparateConnectionValues = List.of(ModelPreferences.SeparateConnectionBehavior.ALWAYS, ModelPreferences.SeparateConnectionBehavior.DEFAULT, ModelPreferences.SeparateConnectionBehavior.NEVER);

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.editor.separate.connection") || store.contains("database.editor.connect.on.activate") || store.contains("database.editor.connect.on.execute") || store.contains("SQLEditor.autoSaveOnClose") || store.contains("SQLEditor.autoSaveOnExecute") || store.contains("SQLEditor.autoSaveActiveSchema") || store.contains("SQLEditor.resultSet.closeOnError");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group connectionsGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_connections, (int)1, (int)770, (int)0);
        ((GridData)connectionsGroup.getLayoutData()).horizontalSpan = 2;
        this.editorSeparateConnectionCombo = UIUtils.createLabelCombo((Composite)UIUtils.createComposite((Composite)connectionsGroup, (int)3), (String)SQLEditorMessages.pref_page_sql_editor_label_separate_connection_each_editor, (int)12);
        ((GridData)this.editorSeparateConnectionCombo.getLayoutData()).grabExcessHorizontalSpace = false;
        this.editorSeparateConnectionCombo.setItems(editorUseSeparateConnectionValues.stream().map(s -> s.getTitle()).collect(Collectors.toList()).toArray(new String[0]));
        this.connectOnActivationCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_connect_on_editor_activation, (boolean)false);
        this.connectOnExecuteCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_connect_on_query_execute, (boolean)false);
        Group autoSaveGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_auto_save, (int)1, (int)770, (int)0);
        this.autoSaveOnChange = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_save_on_change, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_save_on_change_tip, (boolean)false, (int)1);
        this.autoSaveOnClose = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_save_on_close, (boolean)false);
        this.saveOnQueryExecution = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_save_on_query_execute, (String)SQLEditorMessages.pref_page_sql_editor_label_save_on_query_execute, (boolean)false, (int)1);
        this.autoSaveActiveSchema = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_save_active_schema, (boolean)false);
        Group layoutGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_result_view, (int)2, (int)768, (int)0);
        ((GridData)layoutGroup.getLayoutData()).horizontalSpan = 2;
        this.closeTabOnErrorCheck = UIUtils.createCheckbox((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_close_results_tab_on_error, null, (boolean)false, (int)2);
        this.replaceCurrentTab = UIUtils.createCheckbox((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_replace_on_single_query_exec_view, (String)SQLEditorMessages.pref_page_sql_editor_label_replace_on_single_query_exec_view_tip, (boolean)true, (int)2);
        this.resultsOrientationCombo = UIUtils.createLabelCombo((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_results_orientation, (String)SQLEditorMessages.pref_page_sql_editor_label_results_orientation_tip, (int)12);
        ((GridData)this.resultsOrientationCombo.getLayoutData()).grabExcessHorizontalSpace = false;
        SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
        int n = resultSetOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
            if (orientation.isSupported()) {
                this.resultsOrientationCombo.add(orientation.getLabel());
            }
            ++n2;
        }
        this.autoOpenOutputView = UIUtils.createCheckbox((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view_tip, (boolean)false, (int)2);
        Group linksGroup = UIUtils.createControlGroup((Composite)composite, (String)"", (int)1, (int)768, (int)0);
        new PreferenceLinkArea((Composite)linksGroup, 0, TEXT_EDITOR_PAGE_ID, "<a>''{0}''</a> " + SQLEditorMessages.pref_page_sql_editor_link_text_editor, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        new PreferenceLinkArea((Composite)linksGroup, 0, "org.eclipse.ui.preferencePages.ColorsAndFonts", SQLEditorMessages.pref_page_sql_editor_link_colors_and_fonts, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.editorSeparateConnectionCombo.select(editorUseSeparateConnectionValues.indexOf(ModelPreferences.SeparateConnectionBehavior.parse((String)store.getString("database.editor.separate.connection"))));
            this.connectOnActivationCheck.setSelection(store.getBoolean("database.editor.connect.on.activate"));
            this.connectOnExecuteCheck.setSelection(store.getBoolean("database.editor.connect.on.execute"));
            this.autoSaveOnChange.setSelection(store.getBoolean("SQLEditor.autoSaveOnChange"));
            this.autoSaveOnClose.setSelection(store.getBoolean("SQLEditor.autoSaveOnClose"));
            this.saveOnQueryExecution.setSelection(store.getBoolean("SQLEditor.autoSaveOnExecute"));
            this.autoSaveActiveSchema.setSelection(store.getBoolean("SQLEditor.autoSaveActiveSchema"));
            this.closeTabOnErrorCheck.setSelection(store.getBoolean("SQLEditor.resultSet.closeOnError"));
            this.replaceCurrentTab.setSelection(store.getBoolean("SQLEditor.resultSet.replaceCurrentTab"));
            SQLEditor.ResultSetOrientation orientation = SQLEditor.ResultSetOrientation.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.resultSet.orientation"));
            this.resultsOrientationCombo.setText(orientation.getLabel());
            this.autoOpenOutputView.setSelection(store.getBoolean("SQLEditor.outputPanel.autoShow"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("database.editor.separate.connection", editorUseSeparateConnectionValues.get(this.editorSeparateConnectionCombo.getSelectionIndex()).name());
            store.setValue("database.editor.connect.on.activate", this.connectOnActivationCheck.getSelection());
            store.setValue("database.editor.connect.on.execute", this.connectOnExecuteCheck.getSelection());
            store.setValue("SQLEditor.autoSaveOnChange", this.autoSaveOnChange.getSelection());
            store.setValue("SQLEditor.autoSaveOnClose", this.autoSaveOnClose.getSelection());
            store.setValue("SQLEditor.autoSaveOnExecute", this.saveOnQueryExecution.getSelection());
            store.setValue("SQLEditor.autoSaveActiveSchema", this.autoSaveActiveSchema.getSelection());
            store.setValue("SQLEditor.resultSet.closeOnError", this.closeTabOnErrorCheck.getSelection());
            store.setValue("SQLEditor.resultSet.replaceCurrentTab", this.replaceCurrentTab.getSelection());
            String orientationLabel = this.resultsOrientationCombo.getText();
            SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
            int n = resultSetOrientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
                if (orientationLabel.equals(orientation.getLabel())) {
                    DBWorkbench.getPlatform().getPreferenceStore().setValue("SQLEditor.resultSet.orientation", orientation.name());
                    break;
                }
                ++n2;
            }
            store.setValue("SQLEditor.outputPanel.autoShow", this.autoOpenOutputView.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.editor.separate.connection");
        store.setToDefault("database.editor.connect.on.activate");
        store.setToDefault("database.editor.connect.on.execute");
        store.setToDefault("SQLEditor.autoSaveOnChange");
        store.setToDefault("SQLEditor.autoSaveOnClose");
        store.setToDefault("SQLEditor.autoSaveOnExecute");
        store.setToDefault("SQLEditor.autoSaveActiveSchema");
        store.setToDefault("SQLEditor.resultSet.closeOnError");
        store.setToDefault("SQLEditor.resultSet.replaceCurrentTab");
        DBWorkbench.getPlatform().getPreferenceStore().setToDefault("SQLEditor.resultSet.orientation");
        store.setToDefault("SQLEditor.outputPanel.autoShow");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

