/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKeyColumn;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class PostgreTableInheritance
extends PostgreTableConstraintBase
implements DBSEntityAssociation {
    private final PostgreTableBase superTable;
    private int sequenceNum;

    public PostgreTableInheritance(@NotNull PostgreTableBase table, @NotNull PostgreTableBase superTable, int sequenceNum, boolean persisted) {
        super(table, String.valueOf(table.getFullyQualifiedName(DBPEvaluationContext.DDL)) + "->" + superTable.getFullyQualifiedName(DBPEvaluationContext.DDL), DBSEntityConstraintType.INHERITANCE);
        this.setPersisted(persisted);
        this.superTable = superTable;
        this.sequenceNum = sequenceNum;
    }

    @Override
    public boolean isInherited() {
        return false;
    }

    @Nullable
    public DBSEntityConstraint getReferencedConstraint() {
        return this;
    }

    @Property(viewable=true)
    public PostgreTableBase getAssociatedEntity() {
        return this.superTable;
    }

    @Property(viewable=true)
    public int getSequenceNum() {
        return this.sequenceNum;
    }

    @Nullable
    public List<PostgreTableForeignKeyColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    void cacheAttributes(DBRProgressMonitor monitor, List<? extends PostgreTableConstraintColumn> children, boolean secondPass) {
    }
}

