/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.parser.common.ParseResult;
import org.jkiss.dbeaver.parser.common.ParseTreeNode;
import org.jkiss.dbeaver.parser.common.TermPatternInfo;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaBuilder;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaOperation;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaState;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;
import org.jkiss.dbeaver.parser.common.grammar.nfa.ParseOperationKind;

public class Parser {
    private final GrammarInfo grammar;
    private final GrammarNfaBuilder.NfaFragment nfa;

    public Parser(GrammarInfo grammar, GrammarNfaBuilder.NfaFragment nfa) {
        this.grammar = grammar;
        this.nfa = nfa;
    }

    private static ImmList<ParsingStep> performPush(ImmList<ParsingStep> allPrevSteps, GrammarNfaTransition transition, int exprPosition) {
        return ImmList.of(new ParsingStep(allPrevSteps, transition, StackFrame.push(transition.getOperation().getExprId(), exprPosition, transition.getOperation().getRule(), allPrevSteps.map(s -> s.stack))));
    }

    private static ImmList<ParsingStep> performPop(ImmList<ParsingStep> allPrevSteps, GrammarNfaTransition transition, Predicate<StackFrame> condition) {
        ImmList<ParsingStep> prevSteps = allPrevSteps.filter(s -> s.stack.exprId == transition.getOperation().getExprId() && condition.test(s.stack));
        return prevSteps.flatMap(prevStep -> prevStep.stack.pop().map(stack -> new ParsingStep(ImmList.of(prevStep), transition, (StackFrame)stack)));
    }

    private static ImmList<ParsingStep> performPopAndPush(ImmList<ParsingStep> allPrevSteps, GrammarNfaTransition transition, Predicate<StackFrame> condition, IntFunction<Integer> exprPosition) {
        ImmList<ParsingStep> prevSteps = allPrevSteps.filter(s -> s.stack.exprId == transition.getOperation().getExprId() && condition.test(s.stack));
        int prevStepsCount = prevSteps.count();
        if (prevStepsCount == 1 || prevStepsCount > 1 && prevSteps.all(s -> s.stack.exprPosition == ((ParsingStep)immList.peek()).stack.exprPosition)) {
            return ImmList.of(new ParsingStep(prevSteps, transition, StackFrame.push(transition.getOperation().getExprId(), exprPosition.apply(prevSteps.peek().stack.exprPosition), transition.getOperation().getRule(), prevSteps.flatMap(prevStep -> prevStep.stack.pop()))));
        }
        return prevSteps.map(prevStep -> new ParsingStep(ImmList.of(prevStep), transition, StackFrame.push(transition.getOperation().getExprId(), (Integer)exprPosition.apply(prevStep.stack.exprPosition), transition.getOperation().getRule(), prevStep.stack.pop())));
    }

    private static ImmList<ParsingStep> evaluateOperation(ImmList<ParsingStep> prevSteps, GrammarNfaTransition transition) {
        ImmList<ParsingStep> result;
        GrammarNfaOperation op = transition.getOperation();
        switch (op.getKind()) {
            case CALL: 
            case RESUME: 
            case NONE: {
                result = prevSteps.map(s -> new ParsingStep(ImmList.of(s), transition, s.stack));
                break;
            }
            case RULE_START: 
            case LOOP_ENTER: 
            case SEQ_ENTER: {
                result = Parser.performPush(prevSteps, transition, 0);
                break;
            }
            case RULE_END: {
                result = Parser.performPop(prevSteps, transition, f -> f.getRule() == op.getRule());
                break;
            }
            case LOOP_INCREMENT: {
                result = Parser.performPopAndPush(prevSteps, transition, f -> f.getExprPosition() <= op.getMaxIterations(), p -> p + 1);
                break;
            }
            case LOOP_EXIT: {
                result = Parser.performPop(prevSteps, transition, f -> f.getExprPosition() <= op.getMaxIterations() && f.getExprPosition() >= op.getMinIterations());
                break;
            }
            case SEQ_STEP: {
                result = Parser.performPopAndPush(prevSteps, transition, f -> f.getExprPosition() <= op.getMaxIterations() && f.getExprPosition() + 1 == op.getExprPosition(), p -> op.getExprPosition());
                break;
            }
            case SEQ_EXIT: {
                result = Parser.performPop(prevSteps, transition, f -> f.getExprPosition() + 1 == op.getMaxIterations());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected parse operation kind " + (Object)((Object)op.getKind()));
            }
        }
        return result;
    }

    public ParseResult parse(String text) {
        return this.parse(text, false, () -> false);
    }

    public ParseResult parse(String text, boolean firstResult, BooleanSupplier cancellationChecker) {
        PositionsQueue queue = new PositionsQueue(text.length(), this.nfa.getFrom());
        ArrayList<ParserState> results = new ArrayList<ParserState>();
        ArrayDeque<LocalState> localStates = new ArrayDeque<LocalState>();
        while (queue.isNotEmpty()) {
            for (ParserState state : queue.dequeue()) {
                GrammarNfaState.DispatchResult dispatchResult;
                if (state.nfaState == this.nfa.getTo()) {
                    results.add(state);
                }
                if ((dispatchResult = state.nfaState.dispatch(text, state.position)) == null) continue;
                localStates.clear();
                for (GrammarNfaTransition t : dispatchResult.transitions) {
                    localStates.offer(new LocalState(state.paths, t));
                }
                while (!localStates.isEmpty()) {
                    LocalState localState = (LocalState)localStates.remove();
                    if (localState.transitionToGo.getOperation().getKind() == ParseOperationKind.TERM) {
                        queue.enqueue(state.makeNext(dispatchResult.end, localState.transitionToGo.getTo(), localState.prevSteps.map(s -> new ParsingStep(ImmList.of(s), localState.transitionToGo, s.stack))));
                        continue;
                    }
                    ImmList<ParsingStep> stepsDone = Parser.evaluateOperation(localState.prevSteps, localState.transitionToGo);
                    if (stepsDone.isEmpty()) continue;
                    for (GrammarNfaTransition t : localState.transitionToGo.getTo().getNextByTerm(dispatchResult.term)) {
                        if (t.getTo() == this.nfa.getTo()) {
                            ImmList<ParsingStep> finalSteps = stepsDone.filter(s -> s.stack.isRoot());
                            if (!finalSteps.isEmpty()) {
                                results.add(state.makeNext(dispatchResult.end, t.getTo(), finalSteps.map(s -> new ParsingStep(ImmList.of(s), t, s.stack))));
                                continue;
                            }
                            localStates.offer(new LocalState(stepsDone, t));
                            continue;
                        }
                        localStates.offer(new LocalState(stepsDone, t));
                    }
                }
            }
        }
        return new ParseResultImpl(results, text, queue.boundaryPosition, queue.getBoundaryStates());
    }

    private static class ImmList<T>
    implements Iterable<T> {
        private static final ImmList<?> SENTINEL = new ImmList<Object>(null, null);
        private final T data;
        private final ImmList<T> next;

        private ImmList(T data, ImmList<T> next) {
            this.data = data;
            this.next = next;
        }

        public static <T> ImmList<T> empty() {
            return SENTINEL;
        }

        public static <T> ImmList<T> of(T data) {
            return new ImmList<T>(data, ImmList.empty());
        }

        public ImmList<T> push(T data) {
            return new ImmList<T>(data, this);
        }

        public ImmList<T> merge(ImmList<T> other) {
            ImmList<T> result = this;
            ImmList<T> item = other;
            while (item != SENTINEL) {
                result = result.push(item.data);
                item = item.next;
            }
            return result;
        }

        public int count() {
            int result = 0;
            ImmList<T> item = this;
            while (item != SENTINEL) {
                ++result;
                item = item.next;
            }
            return result;
        }

        public <R> R aggregate(R initial, BiFunction<R, T, R> action) {
            R result = initial;
            ImmList<T> item = this;
            while (item != SENTINEL) {
                result = action.apply(result, item.data);
                item = item.next;
            }
            return result;
        }

        public <R> ImmList<R> map(Function<T, R> action) {
            ImmList<R> result = ImmList.empty();
            ImmList<T> item = this;
            while (item != SENTINEL) {
                result = result.push(action.apply(item.data));
                item = item.next;
            }
            return result;
        }

        public ImmList<T> filter(Predicate<T> action) {
            ImmList<T> result = ImmList.empty();
            ImmList<T> item = this;
            while (item != SENTINEL) {
                if (action.test(item.data)) {
                    result = result.push(item.data);
                }
                item = item.next;
            }
            return result;
        }

        public boolean all(Predicate<T> action) {
            ImmList<T> item = this;
            while (item != SENTINEL) {
                if (!action.test(item.data)) {
                    return false;
                }
                item = item.next;
            }
            return true;
        }

        public boolean any(Predicate<T> action) {
            ImmList<T> item = this;
            while (item != SENTINEL) {
                if (action.test(item.data)) {
                    return true;
                }
                item = item.next;
            }
            return false;
        }

        public <R> ImmList<R> flatMap(Function<T, ImmList<R>> action) {
            ImmList<R> result = ImmList.empty();
            ImmList<T> item = this;
            while (item != SENTINEL) {
                result = result.merge(action.apply(item.data));
                item = item.next;
            }
            return result;
        }

        public boolean isEmpty() {
            return this == SENTINEL;
        }

        public ImmList<T> pop() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        public T peek() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.data;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private ImmList<T> expected;
                {
                    this.expected = immList;
                }

                @Override
                public boolean hasNext() {
                    return this.expected != SENTINEL;
                }

                @Override
                public T next() {
                    if (this.expected == SENTINEL) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.expected.data;
                    this.expected = this.expected.next;
                    return result;
                }
            };
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ImmList[");
            if (this != SENTINEL) {
                sb.append(this.data == null ? "<NULL>" : this.data.toString());
                int count = 0;
                ImmList<T> item = this.next;
                while (item != SENTINEL) {
                    if (++count > 20) {
                        sb.append(", ...");
                        break;
                    }
                    sb.append(", ").append(item.data == null ? "<NULL>" : item.data.toString());
                    item = item.next;
                }
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class LocalState {
        public final ImmList<ParsingStep> prevSteps;
        public final GrammarNfaTransition transitionToGo;

        public LocalState(ImmList<ParsingStep> prevSteps, GrammarNfaTransition transitionToGo) {
            this.prevSteps = prevSteps;
            this.transitionToGo = transitionToGo;
        }
    }

    private class ParseResultImpl
    implements ParseResult {
        private final ArrayList<ParserState> results;
        private final String text;
        private final int boundaryPosition;
        private final Collection<ParserState> boundaryStates;

        public ParseResultImpl(ArrayList<ParserState> results, String text, int boundaryPosition, Collection<ParserState> boundaryStates) {
            this.results = results;
            this.text = text;
            this.boundaryPosition = boundaryPosition;
            this.boundaryStates = boundaryStates;
        }

        @Override
        public boolean isSuccess() {
            return this.results.size() > 0;
        }

        @Override
        public int getBoundaryPosition() {
            return this.boundaryPosition;
        }

        @Override
        public String[] getBoundaryExpectedContinuations() {
            ArrayDeque<LocalState> localStates = new ArrayDeque<LocalState>();
            HashSet<TermPatternInfo> expectedTerms = new HashSet<TermPatternInfo>();
            for (ParserState state : this.boundaryStates) {
                for (Map.Entry<TermPatternInfo, List<GrammarNfaTransition>> nextByTerm : state.nfaState.getAllNextByTerms().entrySet()) {
                    TermPatternInfo term = nextByTerm.getKey();
                    for (GrammarNfaTransition t2 : nextByTerm.getValue()) {
                        localStates.offer(new LocalState(state.paths, t2));
                    }
                    while (!localStates.isEmpty()) {
                        LocalState localState = (LocalState)localStates.remove();
                        if (localState.transitionToGo.getOperation().getKind() == ParseOperationKind.TERM) {
                            expectedTerms.add(localState.transitionToGo.getOperation().getPattern());
                            continue;
                        }
                        ImmList<ParsingStep> stepsDone = Parser.evaluateOperation(localState.prevSteps, localState.transitionToGo);
                        if (stepsDone.isEmpty()) continue;
                        for (GrammarNfaTransition t3 : localState.transitionToGo.getTo().getNextByTerm(term)) {
                            if (t3.getTo() == Parser.this.nfa.getTo()) {
                                ImmList<ParsingStep> finalSteps = stepsDone.filter(s -> s.stack.isRoot());
                                if (!finalSteps.isEmpty()) {
                                    expectedTerms.add(TermPatternInfo.EOF);
                                    continue;
                                }
                                localStates.offer(new LocalState(stepsDone, t3));
                                continue;
                            }
                            localStates.offer(new LocalState(stepsDone, t3));
                        }
                    }
                }
            }
            if (expectedTerms.size() > 0) {
                return (String[])expectedTerms.stream().map(t -> t.pattern).distinct().toArray(String[]::new);
            }
            return (String[])this.boundaryStates.stream().flatMap(s -> s.nfaState.getExpectedTerms().stream()).map(t -> t.pattern).distinct().toArray(String[]::new);
        }

        @Override
        public List<ParseTreeNode> getTrees(boolean withWhitespaces) {
            ImmList<ParseTreeNode> trees = ImmList.empty();
            for (ParserState state : this.results) {
                trees = trees.merge(this.findTreePath(state).map(path -> this.reconstructTree((PathStep)path, withWhitespaces)));
            }
            return StreamSupport.stream(trees.spliterator(), false).collect(Collectors.toUnmodifiableList());
        }

        private ImmList<PathStep> findTreePath(ParserState lastState) {
            ImmList<PathStep> queue = ImmList.of(PathStep.initial(lastState));
            ImmList<PathStep> results = ImmList.empty();
            while (!queue.isEmpty()) {
                PathStep pathStep = queue.peek();
                queue = queue.pop();
                if (pathStep.step == null) {
                    for (ParsingStep step : pathStep.state.paths) {
                        queue = this.applyStep(queue, pathStep, step);
                    }
                    continue;
                }
                for (ParsingStep step : pathStep.step.prev) {
                    if (step.prev.isEmpty()) {
                        results = results.push(pathStep.enterStep(step, pathStep.stack));
                        return results;
                    }
                    ImmList<ParserState> prevStates = pathStep.state.prev.filter(ps -> ps.paths.any(s -> s == step));
                    if (prevStates.isEmpty()) {
                        queue = this.applyStep(queue, pathStep, step);
                        continue;
                    }
                    for (ParserState prevState : prevStates) {
                        queue = queue.push(pathStep.enterState(prevState, pathStep.stack));
                    }
                }
            }
            if (results.count() > 1) {
                throw new IllegalStateException("too many trees per path");
            }
            return results;
        }

        private ImmList<PathStep> applyStep(ImmList<PathStep> queue, PathStep pathStep, ParsingStep step) {
            GrammarNfaOperation op = step.transition.getOperation();
            StackFrame f = pathStep.stack;
            switch (op.getKind()) {
                case CALL: 
                case RESUME: 
                case TERM: 
                case NONE: {
                    queue = queue.push(pathStep.enterStep(step, f));
                    break;
                }
                case RULE_END: {
                    queue = queue.push(pathStep.enterStep(step, StackFrame.push(op.getExprId(), 0, op.getRule(), ImmList.of(f))));
                    break;
                }
                case RULE_START: {
                    if (f.getExprId() != op.getExprId() || f.getRule() != op.getRule()) break;
                    queue = queue.push(pathStep.enterStep(step, f.pop().peek()));
                    break;
                }
                case SEQ_EXIT: {
                    queue = queue.push(pathStep.enterStep(step, StackFrame.push(op.getExprId(), op.getExprPosition(), op.getRule(), ImmList.of(f))));
                    break;
                }
                case SEQ_STEP: {
                    if (f.getExprId() != op.getExprId() || f.getExprPosition() <= 0 || f.getExprPosition() - 1 != op.getExprPosition()) break;
                    queue = queue.push(pathStep.enterStep(step, StackFrame.push(op.getExprId(), f.getExprPosition() - 1, op.getRule(), f.pop())));
                    break;
                }
                case SEQ_ENTER: {
                    if (f.getExprId() != op.getExprId() || f.getExprPosition() - 1 != 0) break;
                    queue = queue.push(pathStep.enterStep(step, f.pop().peek()));
                    break;
                }
                case LOOP_EXIT: {
                    queue = queue.push(pathStep.enterStep(step, StackFrame.push(op.getExprId(), 0, op.getRule(), ImmList.of(f))));
                    break;
                }
                case LOOP_INCREMENT: {
                    if (f.getExprId() != op.getExprId() || f.getExprPosition() > op.getMaxIterations()) break;
                    queue = queue.push(pathStep.enterStep(step, StackFrame.push(op.getExprId(), f.getExprPosition() + 1, op.getRule(), f.pop())));
                    break;
                }
                case LOOP_ENTER: {
                    if (f.getExprId() != op.getExprId() || f.getExprPosition() > op.getMaxIterations() || f.getExprPosition() < op.getMinIterations()) break;
                    queue = queue.push(pathStep.enterStep(step, f.pop().peek()));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return queue;
        }

        private ParseTreeNode reconstructTree(PathStep treePath, boolean withWhitespaces) {
            ParseTreeNode treeRoot;
            GrammarRule skipRule = Parser.this.grammar.getSkipRuleName() == null ? null : Parser.this.grammar.getRule(Parser.this.grammar.getSkipRuleName());
            ParseTreeNode current = treeRoot = new ParseTreeNode(null, null, 0, this.text.length(), null, new ArrayList<ParseTreeNode>());
            int pos = 0;
            int skipDepth = 0;
            treePath.state.prev.peek();
            PathStep pathStep = treePath;
            while (pathStep != null) {
                ParsingStep step = pathStep.step;
                if (step != null && step.transition != null) {
                    String currentTag = null;
                    GrammarNfaOperation op = step.transition.getOperation();
                    switch (op.getKind()) {
                        case CALL: {
                            currentTag = op.getTag();
                            break;
                        }
                        case RULE_START: {
                            if (skipDepth == 0) {
                                if (!withWhitespaces && op.getRule() == skipRule && skipRule != null) {
                                    ++skipDepth;
                                } else {
                                    ParseTreeNode newNode = new ParseTreeNode(op.getRule(), currentTag, pos, -1, current, new ArrayList<ParseTreeNode>());
                                    current.getChildren().add(newNode);
                                    current = newNode;
                                }
                            } else {
                                ++skipDepth;
                            }
                            currentTag = null;
                            break;
                        }
                        case RULE_END: {
                            if (skipDepth == 0) {
                                int endPos = pos;
                                if (current.getChildren().size() > 0) {
                                    endPos = current.getChildren().get(current.getChildren().size() - 1).getEndPosition();
                                }
                                current.setEndPosition(endPos);
                                current = current.getParent();
                                break;
                            }
                            --skipDepth;
                            break;
                        }
                        case TERM: {
                            if (skipDepth == 0) {
                                current.getChildren().add(new ParseTreeNode(null, null, pos, pathStep.state.position, current, new ArrayList<ParseTreeNode>()));
                            }
                            pos = pathStep.state.position;
                            break;
                        }
                    }
                }
                pathStep = pathStep.next;
            }
            return treeRoot;
        }
    }

    private static class ParserState {
        public final ImmList<ParserState> prev;
        public final int position;
        public final GrammarNfaState nfaState;
        public final ImmList<ParsingStep> paths;

        private ParserState(ImmList<ParserState> prev, int position, GrammarNfaState nfaState, ImmList<ParsingStep> paths) {
            this.prev = prev;
            this.position = position;
            this.nfaState = nfaState;
            this.paths = paths;
            ImmList<Object> q = this.paths.flatMap(p -> p.prev);
            while (!q.isEmpty()) {
                ParsingStep s = (ParsingStep)q.peek();
                q = q.pop();
                if (s.stack == null) continue;
                s.stack = null;
                for (ParsingStep ps : s.prev) {
                    q = q.push(ps);
                }
            }
        }

        public static ParserState initial(GrammarNfaState initialState) {
            return new ParserState(ImmList.empty(), 0, initialState, ImmList.of(new ParsingStep(ImmList.empty(), null, StackFrame.initial())));
        }

        public ParserState makeNext(int position, GrammarNfaState nfaState, ImmList<ParsingStep> path) {
            return new ParserState(ImmList.of(this), position, nfaState, path);
        }

        public ParserState merge(ParserState other) {
            if (other == null) {
                return this;
            }
            if (other.position == this.position && other.nfaState == this.nfaState) {
                return new ParserState(this.prev.merge(other.prev), this.position, this.nfaState, this.paths.merge(other.paths));
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return "ParserState[pos: " + this.position + ", state:" + this.nfaState + "]";
        }
    }

    private static class ParsingStep {
        public final ImmList<ParsingStep> prev;
        public final GrammarNfaTransition transition;
        public StackFrame stack;

        public ParsingStep(ImmList<ParsingStep> prev, GrammarNfaTransition transition, StackFrame stack) {
            this.prev = prev;
            this.transition = transition;
            this.stack = stack;
        }

        private void formatTo(StringBuilder sb) {
            sb.append("[");
            sb.append(this.transition);
            ImmList<ParsingStep> steps = this.prev;
            while (!steps.isEmpty() && steps.pop().isEmpty()) {
                if (sb.length() > 100) {
                    sb.append(", ...]");
                    return;
                }
                sb.append(", ").append(steps.peek().transition);
                steps = steps.peek().prev;
            }
            if (sb.length() > 100) {
                sb.append(", ...]");
                return;
            }
            if (!steps.isEmpty()) {
                steps.forEach(f -> f.formatTo(sb));
            }
            sb.append("]");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ParsingStep");
            this.formatTo(sb);
            return sb.toString();
        }
    }

    private static class PathStep {
        public final PathStep next;
        public final ParserState state;
        public final ParsingStep step;
        public final StackFrame stack;

        private PathStep(PathStep next, ParserState state, ParsingStep step, StackFrame stack) {
            this.next = next;
            this.state = state;
            this.step = step;
            this.stack = stack;
        }

        public static PathStep initial(ParserState state) {
            return new PathStep(null, state, null, StackFrame.initial());
        }

        public PathStep enterState(ParserState state, StackFrame stack) {
            return new PathStep(this, state, null, stack);
        }

        public PathStep enterStep(ParsingStep step, StackFrame stack) {
            return new PathStep(this, this.state, step, stack);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PathStep[");
            sb.append(this.step.transition);
            PathStep step = this.next;
            while (step != null) {
                sb.append(", ");
                sb.append(step.step == null ? "<NULL>" : step.step.transition);
                step = step.next;
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class PositionsQueue {
        private final PriorityQueue<Integer> queueOfPositions = new PriorityQueue();
        private final List<HashMap<GrammarNfaState, ParserState>> localStatesByPos;
        private int currentPosition = 0;
        private int boundaryPosition = 0;

        public PositionsQueue(int positions, GrammarNfaState initialState) {
            this.localStatesByPos = Arrays.asList(new HashMap[positions + 1]);
            HashMap<GrammarNfaState, ParserState> states = new HashMap<GrammarNfaState, ParserState>();
            states.put(initialState, ParserState.initial(initialState));
            this.localStatesByPos.set(0, states);
            this.queueOfPositions.offer(0);
        }

        public void enqueue(ParserState state) {
            if (state.position <= this.currentPosition) {
                throw new IllegalStateException("");
            }
            HashMap<GrammarNfaState, ParserState> states = this.localStatesByPos.get(state.position);
            if (states == null) {
                states = new HashMap();
                states.put(state.nfaState, state);
                this.localStatesByPos.set(state.position, states);
                this.queueOfPositions.offer(state.position);
            } else {
                states.compute(state.nfaState, (k, oldState) -> state.merge((ParserState)oldState));
            }
            if (state.position > this.boundaryPosition) {
                this.boundaryPosition = state.position;
            }
        }

        public boolean isNotEmpty() {
            return this.queueOfPositions.size() > 0;
        }

        public Iterable<ParserState> dequeue() {
            Integer position = this.queueOfPositions.poll();
            if (position == null) {
                return Collections.emptyList();
            }
            this.currentPosition = position;
            HashMap<GrammarNfaState, ParserState> states = this.localStatesByPos.get(position);
            if (states == null) {
                return Collections.emptyList();
            }
            return states.values();
        }

        public Collection<ParserState> getBoundaryStates() {
            return Collections.unmodifiableCollection(this.localStatesByPos.get(this.boundaryPosition).values());
        }
    }

    private static class StackFrame {
        private final int exprId;
        private final int exprPosition;
        private final GrammarRule rule;
        private final ImmList<StackFrame> prev;

        private StackFrame(int exprId, int exprPosition, GrammarRule rule, ImmList<StackFrame> prev) {
            this.exprId = exprId;
            this.exprPosition = exprPosition;
            this.rule = rule;
            this.prev = prev;
        }

        public static StackFrame initial() {
            return new StackFrame(Integer.MIN_VALUE, Integer.MIN_VALUE, null, ImmList.empty());
        }

        public static StackFrame push(int exprId, int exprPosition, GrammarRule rule, ImmList<StackFrame> prev) {
            return new StackFrame(exprId, exprPosition, rule, prev);
        }

        public int getExprId() {
            return this.exprId;
        }

        public Integer getExprPosition() {
            return this.exprPosition;
        }

        public GrammarRule getRule() {
            return this.rule;
        }

        public boolean isRoot() {
            return this.prev.isEmpty() && this.exprId == Integer.MIN_VALUE && this.exprPosition == Integer.MIN_VALUE && this.rule == null;
        }

        public ImmList<StackFrame> pop() {
            return this.prev;
        }

        private void formatTo(StringBuilder sb) {
            sb.append("[").append(this.rule == null ? "<NULL>" : this.rule.getName()).append(":").append(this.exprId).append("@").append(this.exprPosition);
            if (!this.prev.isEmpty()) {
                sb.append(" ");
                if (sb.length() > 100) {
                    sb.append(", ...]");
                    return;
                }
                this.prev.forEach(f -> f.formatTo(sb));
            }
            sb.append("]");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StackFrame");
            this.formatTo(sb);
            return sb.toString();
        }
    }
}

