/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.utils.CommonUtils;

public abstract class OraclePartitionBase<PARENT extends DBSObject>
extends OracleObject<PARENT>
implements DBSObjectLazy {
    public static final String CAT_PARTITIONING = "Partitioning";
    private int position;
    private String highValue;
    private boolean usable;
    private Object tablespace;
    private long numRows;
    private long sampleSize;
    private Timestamp lastAnalyzed;

    protected OraclePartitionBase(PARENT parent, boolean subpartition, ResultSet dbResult) {
        super(parent, subpartition ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUBPARTITION_NAME") : JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_NAME"), true);
        this.highValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HIGH_VALUE");
        this.position = subpartition ? JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SUBPARTITION_POSITION") : JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARTITION_POSITION");
        this.usable = "USABLE".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.tablespace = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABLESPACE_NAME");
        this.numRows = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUM_ROWS");
        this.sampleSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SAMPLE_SIZE");
        this.lastAnalyzed = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ANALYZED");
    }

    public Object getLazyReference(Object propertyId) {
        return this.tablespace;
    }

    @Property(viewable=true, order=10)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=11)
    public boolean isUsable() {
        return this.usable;
    }

    @Property(viewable=true, order=12)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, null);
    }

    @Property(viewable=true, order=30)
    public String getHighValue() {
        return this.highValue;
    }

    @Property(viewable=true, order=40)
    public long getNumRows() {
        return this.numRows;
    }

    @Property(viewable=true, order=41)
    public long getSampleSize() {
        return this.sampleSize;
    }

    @Property(viewable=true, order=42)
    public Timestamp getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    public static class PartitionInfoBase {
        private PartitionType partitionType;
        private PartitionType subpartitionType;
        private Object partitionTablespace;

        @Property(category="Partitioning", order=120)
        public PartitionType getPartitionType() {
            return this.partitionType;
        }

        @Property(category="Partitioning", order=121)
        public PartitionType getSubpartitionType() {
            return this.subpartitionType;
        }

        @Property(category="Partitioning", order=122)
        public Object getPartitionTablespace() {
            return this.partitionTablespace;
        }

        public PartitionInfoBase(DBRProgressMonitor monitor, OracleDataSource dataSource, ResultSet dbResult) throws DBException {
            this.partitionType = (PartitionType)CommonUtils.valueOf(PartitionType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PARTITIONING_TYPE"));
            this.subpartitionType = (PartitionType)CommonUtils.valueOf(PartitionType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SUBPARTITIONING_TYPE"));
            this.partitionTablespace = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"DEF_TABLESPACE_NAME");
            if (dataSource.isAdmin()) {
                this.partitionTablespace = dataSource.tablespaceCache.getObject(monitor, (DBSObject)dataSource, (String)this.partitionTablespace);
            }
        }
    }

    public static enum PartitionType {
        NONE,
        RANGE,
        HASH,
        SYSTEM,
        LIST;

    }
}

