import QtQuick 2.1
import QtQuick.Controls 1.4
import QtQuick.Layouts 1.0
import Shotcut.Controls 1.0 as Shotcut
Shotcut.KeyframableFilter {
    width: 350
    height: 525
    keyframableParameters: ["yaw", "pitch", "roll", "frontX", "frontY", "frontUp", "backX", "backY", "backUp", "fov", "radius", "nadirRadius", "nadirCorrectionStart"]
    startValues: [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5]
    middleValues: [0.0, 0.0, 0.0, 0.75, 0.5, 90, 0.25, 0.5, 270, 180, 0.25, 0.2229, 0.8]
    endValues: [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5]
    property var allParameters: [
        {
            name: "yaw",
            type: "simple",
            def: 0
        },
        {
            name: "pitch",
            type: "simple",
            def: 0
        },
        {
            name: "roll",
            type: "simple",
            def: 0
        },
        {
            name: "frontX",
            type: "simple",
            def: 0.75
        },
        {
            name: "frontY",
            type: "simple",
            def: 0.5
        },
        {
            name: "frontUp",
            type: "simple",
            def: 90
        },
        {
            name: "backX",
            type: "simple",
            def: 0.25
        },
        {
            name: "backY",
            type: "simple",
            def: 0.5
        },
        {
            name: "backUp",
            type: "simple",
            def: 270
        },
        {
            name: "fov",
            type: "simple",
            def: 180
        },
        {
            name: "radius",
            type: "simple",
            def: 0.25
        },
        {
            name: "nadirRadius",
            type: "simple",
            def: 0.2229
        },
        {
            name: "nadirCorrectionStart",
            type: "simple",
            def: 0.8
        },
        {
            name: "interpolation",
            type: "combobox",
            def: 1
        },
        {
            name: "projection",
            type: "combobox",
            def: 0
        }
        ]
    function isKeyframeButtonChecked(control){
        return filter.animateIn <= 0 && filter.animateOut <= 0 && filter.keyframeCount(control) > 0;
    }
    
    function setSimpleControl(parameter, controlSlider, controlKeyframeButton) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
        controlKeyframeButton.checked = isKeyframeButtonChecked(parameter);
    }
    
    function setSimpleControlStatic(parameter, controlSlider) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
    }
    
    function setSimpleComboBox(parameter, controlComboBox) {
        controlComboBox.currentIndex = filter.get(parameter);
    }
    
    function setSimpleCheckBox(parameter, controlCheckBox) {
        controlCheckBox.checked = filter.get(parameter) == "1";
    }
    
    function setSimpleTextField(parameter, controlTextField) {
        controlTextField.text = filter.get(parameter);
    }
    
    function setSimpleNumTextField(parameter, controlTextField) {
        controlTextField.text = filter.getDouble(parameter).toFixed(4);
    }
    
    function getFrameRate() {
        return producer.getDouble("meta.media.frame_rate_num", getPosition()) / producer.getDouble("meta.media.frame_rate_den", getPosition());
    }
    
    function getClipOffset() {
        return filter.in;
    }
    function getKeyframesButton(param) {
        return this["prop_" + param.name + "KeyframesButton"];
    }
    
    function getControl(param) {
        if (param.control != null && param.control !== undefined) {
            return this["prop_" + param.control];
        } else if (param.type == "simple" || param.type == "static") {
            return this["prop_" + param.name + "Slider"];
        } else if (param.type == "checkbox") {
            return this["prop_" + param.name + "CheckBox"];
        } else if (param.type == "combobox") {
            return this["prop_" + param.name + "ComboBox"];
        } else if (param.type == "textfield" || param.type == "numtextfield") {
            return this["prop_" + param.name + "TextField"];
        } else {
            return null;
        }
    }
    
    function enableControls(enabled) {
        for (var i = 0; i < allParameters.length; ++i) {
            var control = getControl(allParameters[i]);
            control.enabled = enabled;
        }
    }
    
    function defaultBeforePresetLoaded() {
        for (var i in preset.parameters) {
            filter.resetProperty(preset.parameters[i]);
        }
        resetSimpleKeyframes();
    }
    
    function defaultPresetSelected() {
        initializeSimpleKeyframes();
        setControls();
    }
    
    function setControlsForAllParameters() {
        console.log("START");
        console.log(allParameters.length);
        for (var i = 0; i < allParameters.length; ++i) {
            console.log(i);
            var param = allParameters[i];
            var control = getControl(param);
            console.log(param.name);
            console.log(param.type);
            console.log(control);
            if (param.type == "simple") {
                setSimpleControl(param.name, control, getKeyframesButton(param));
            } else if (param.type == "static") {
                setSimpleControlStatic(param.name, control);
            } else if (param.type == "combobox") {
                setSimpleComboBox(param.name, control);
            } else if (param.type == "checkbox") {
                setSimpleCheckBox(param.name, control);
            } else if (param.type == "textfield") {
                setSimpleTextField(param.name, control);
            } else if (param.type == "numtextfield") {
                setSimpleNumTextField(param.name, control);
            }
        }
    }
    function setControls() {
        blockUpdate = true;
        setControlsForAllParameters();
        blockUpdate = false;
        enableControls(isSimpleKeyframesActive());
    }
    
    function defaultOnCompleted() {
        if (filter.isNew) {
            for (var i = 0; i < allParameters.length; ++i) {
                var param = allParameters[i];
                console.log(param.name);
                if (param.def != null) {
                    var control = getControl(param);
                    filter.set(param.name, param.def);
                }
            }
            filter.savePreset(preset.parameters);
        }
        setControls();
    }
    
    function updateSimpleKeyframes() {
        setControlsForAllParameters();
    }
    
    Component.onCompleted: {
        defaultOnCompleted()
    }
    function updateProperty_yaw () {
        if (!blockUpdate) {
            updateFilter("yaw", yawSlider.value, yawKeyframesButton, getPosition());
        }
    }
    property alias prop_yawSlider : yawSlider;
    property alias prop_yawKeyframesButton : yawKeyframesButton;
    
    function updateProperty_pitch () {
        if (!blockUpdate) {
            updateFilter("pitch", pitchSlider.value, pitchKeyframesButton, getPosition());
        }
    }
    property alias prop_pitchSlider : pitchSlider;
    property alias prop_pitchKeyframesButton : pitchKeyframesButton;
    
    function updateProperty_roll () {
        if (!blockUpdate) {
            updateFilter("roll", rollSlider.value, rollKeyframesButton, getPosition());
        }
    }
    property alias prop_rollSlider : rollSlider;
    property alias prop_rollKeyframesButton : rollKeyframesButton;
    
    function updateProperty_frontX () {
        if (!blockUpdate) {
            updateFilter("frontX", frontXSlider.value, frontXKeyframesButton, getPosition());
        }
    }
    property alias prop_frontXSlider : frontXSlider;
    property alias prop_frontXKeyframesButton : frontXKeyframesButton;
    
    function updateProperty_frontY () {
        if (!blockUpdate) {
            updateFilter("frontY", frontYSlider.value, frontYKeyframesButton, getPosition());
        }
    }
    property alias prop_frontYSlider : frontYSlider;
    property alias prop_frontYKeyframesButton : frontYKeyframesButton;
    
    function updateProperty_frontUp () {
        if (!blockUpdate) {
            updateFilter("frontUp", frontUpSlider.value, frontUpKeyframesButton, getPosition());
        }
    }
    property alias prop_frontUpSlider : frontUpSlider;
    property alias prop_frontUpKeyframesButton : frontUpKeyframesButton;
    
    function updateProperty_backX () {
        if (!blockUpdate) {
            updateFilter("backX", backXSlider.value, backXKeyframesButton, getPosition());
        }
    }
    property alias prop_backXSlider : backXSlider;
    property alias prop_backXKeyframesButton : backXKeyframesButton;
    
    function updateProperty_backY () {
        if (!blockUpdate) {
            updateFilter("backY", backYSlider.value, backYKeyframesButton, getPosition());
        }
    }
    property alias prop_backYSlider : backYSlider;
    property alias prop_backYKeyframesButton : backYKeyframesButton;
    
    function updateProperty_backUp () {
        if (!blockUpdate) {
            updateFilter("backUp", backUpSlider.value, backUpKeyframesButton, getPosition());
        }
    }
    property alias prop_backUpSlider : backUpSlider;
    property alias prop_backUpKeyframesButton : backUpKeyframesButton;
    
    function updateProperty_fov () {
        if (!blockUpdate) {
            updateFilter("fov", fovSlider.value, fovKeyframesButton, getPosition());
        }
    }
    property alias prop_fovSlider : fovSlider;
    property alias prop_fovKeyframesButton : fovKeyframesButton;
    
    function updateProperty_radius () {
        if (!blockUpdate) {
            updateFilter("radius", radiusSlider.value, radiusKeyframesButton, getPosition());
        }
    }
    property alias prop_radiusSlider : radiusSlider;
    property alias prop_radiusKeyframesButton : radiusKeyframesButton;
    
    function updateProperty_nadirRadius () {
        if (!blockUpdate) {
            updateFilter("nadirRadius", nadirRadiusSlider.value, nadirRadiusKeyframesButton, getPosition());
        }
    }
    property alias prop_nadirRadiusSlider : nadirRadiusSlider;
    property alias prop_nadirRadiusKeyframesButton : nadirRadiusKeyframesButton;
    
    function updateProperty_nadirCorrectionStart () {
        if (!blockUpdate) {
            updateFilter("nadirCorrectionStart", nadirCorrectionStartSlider.value, nadirCorrectionStartKeyframesButton, getPosition());
        }
    }
    property alias prop_nadirCorrectionStartSlider : nadirCorrectionStartSlider;
    property alias prop_nadirCorrectionStartKeyframesButton : nadirCorrectionStartKeyframesButton;
    
    function updateProperty_interpolation () {
        if (!blockUpdate) {
            filter.set("interpolation", interpolationComboBox.currentIndex);
        }
    }
    property alias prop_interpolationComboBox : interpolationComboBox;
    
    function updateProperty_projection () {
        if (!blockUpdate) {
            filter.set("projection", projectionComboBox.currentIndex);
        }
    }
    property alias prop_projectionComboBox : projectionComboBox;
    
    GridLayout {
        columns: 4
        anchors.fill: parent
        anchors.margins: 8
        Label {
            text: qsTr('Preset')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.Preset {
            id: preset
            parameters: ["yaw", "pitch", "roll", "frontX", "frontY", "frontUp", "backX", "backY", "backUp", "fov", "radius", "nadirRadius", "nadirCorrectionStart", "interpolation", "projection"]
            Layout.columnSpan: 3
            onBeforePresetLoaded: {
                defaultBeforePresetLoaded()
            }
            onPresetSelected: {
                defaultPresetSelected()
            }
        }
        Label {
            text: qsTr('Interpolation')
            Layout.alignment: Qt.AlignRight
        }
        ComboBox {
            currentIndex: 0
            model: ["Nearest-neighbor", "Bilinear"]
            id: interpolationComboBox
            Layout.columnSpan: 2
            onCurrentIndexChanged: updateProperty_interpolation()
        }
        Shotcut.UndoButton {
            id: interpolationUndo
            onClicked: interpolationComboBox.currentIndex = 0
        }
        Label {
            text: qsTr('Alignment')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('Yaw')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: yawSlider
            minimumValue: -360
            maximumValue: 360
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_yaw()
        }
        Shotcut.KeyframesButton {
            id: yawKeyframesButton;
            checked: isKeyframeButtonChecked("yaw");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "yaw", yawSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: yawUndo
            onClicked: yawSlider.value = 0
        }
        Label {
            text: qsTr('Pitch')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: pitchSlider
            minimumValue: -180
            maximumValue: 180
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_pitch()
        }
        Shotcut.KeyframesButton {
            id: pitchKeyframesButton;
            checked: isKeyframeButtonChecked("pitch");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "pitch", pitchSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: pitchUndo
            onClicked: pitchSlider.value = 0
        }
        Label {
            text: qsTr('Roll')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: rollSlider
            minimumValue: -180
            maximumValue: 180
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_roll()
        }
        Shotcut.KeyframesButton {
            id: rollKeyframesButton;
            checked: isKeyframeButtonChecked("roll");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "roll", rollSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: rollUndo
            onClicked: rollSlider.value = 0
        }
        Label {
            text: qsTr('Lens')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('Projection')
            Layout.alignment: Qt.AlignRight
        }
        ComboBox {
            currentIndex: 0
            model: ["Equidistant Fisheye"]
            id: projectionComboBox
            Layout.columnSpan: 2
            onCurrentIndexChanged: updateProperty_projection()
        }
        Shotcut.UndoButton {
            id: projectionUndo
            onClicked: projectionComboBox.currentIndex = 0
        }
        Label {
            text: qsTr('FOV')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: fovSlider
            minimumValue: 0
            maximumValue: 360
            spinnerWidth: 120
            suffix: ' deg'
            decimals: 4
            stepSize: 0.0001
            onValueChanged: updateProperty_fov()
        }
        Shotcut.KeyframesButton {
            id: fovKeyframesButton;
            checked: isKeyframeButtonChecked("fov");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "fov", fovSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: fovUndo
            onClicked: fovSlider.value = 180
        }
        Label {
            text: qsTr('Radius')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: radiusSlider
            minimumValue: 0
            maximumValue: 1
            suffix: ' '
            decimals: 4
            stepSize: 0.0001
            onValueChanged: updateProperty_radius()
        }
        Shotcut.KeyframesButton {
            id: radiusKeyframesButton;
            checked: isKeyframeButtonChecked("radius");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "radius", radiusSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: radiusUndo
            onClicked: radiusSlider.value = 0.25
        }
        Label {
            text: qsTr('Front')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('X')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: frontXSlider
            minimumValue: 0
            maximumValue: 1
            stepSize: 0.0001
            decimals: 4
            suffix: ' '
            onValueChanged: updateProperty_frontX()
        }
        Shotcut.KeyframesButton {
            id: frontXKeyframesButton;
            checked: isKeyframeButtonChecked("frontX");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "frontX", frontXSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: frontXUndo
            onClicked: frontXSlider.value = 0.25
        }
        Label {
            text: qsTr('Y')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: frontYSlider
            minimumValue: 0
            maximumValue: 1
            stepSize: 0.0001
            decimals: 4
            suffix: ' '
            onValueChanged: updateProperty_frontY()
        }
        Shotcut.KeyframesButton {
            id: frontYKeyframesButton;
            checked: isKeyframeButtonChecked("frontY");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "frontY", frontYSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: frontYUndo
            onClicked: frontYSlider.value = 0.25
        }
        Label {
            text: qsTr('Up')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: frontUpSlider
            minimumValue: 0
            maximumValue: 360
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_frontUp()
        }
        Shotcut.KeyframesButton {
            id: frontUpKeyframesButton;
            checked: isKeyframeButtonChecked("frontUp");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "frontUp", frontUpSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: frontUpUndo
            onClicked: frontUpSlider.value = 90
        }
        Label {
            text: qsTr('Back')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('X')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: backXSlider
            minimumValue: 0
            maximumValue: 1
            stepSize: 0.0001
            decimals: 4
            suffix: ' '
            onValueChanged: updateProperty_backX()
        }
        Shotcut.KeyframesButton {
            id: backXKeyframesButton;
            checked: isKeyframeButtonChecked("backX");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "backX", backXSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: backXUndo
            onClicked: backXSlider.value = 0.25
        }
        Label {
            text: qsTr('Y')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: backYSlider
            minimumValue: 0
            maximumValue: 1
            stepSize: 0.0001
            decimals: 4
            suffix: ' '
            onValueChanged: updateProperty_backY()
        }
        Shotcut.KeyframesButton {
            id: backYKeyframesButton;
            checked: isKeyframeButtonChecked("backY");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "backY", backYSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: backYUndo
            onClicked: backYSlider.value = 0.25
        }
        Label {
            text: qsTr('Up')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: backUpSlider
            minimumValue: 0
            maximumValue: 360
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_backUp()
        }
        Shotcut.KeyframesButton {
            id: backUpKeyframesButton;
            checked: isKeyframeButtonChecked("backUp");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "backUp", backUpSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: backUpUndo
            onClicked: backUpSlider.value = 90
        }
        Label {
            text: qsTr('Nadir')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('Radius')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: nadirRadiusSlider
            minimumValue: 0
            maximumValue: 1
            suffix: ' '
            decimals: 4
            stepSize: 0.0001
            onValueChanged: updateProperty_nadirRadius()
        }
        Shotcut.KeyframesButton {
            id: nadirRadiusKeyframesButton;
            checked: isKeyframeButtonChecked("nadirRadius");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "nadirRadius", nadirRadiusSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: nadirRadiusUndo
            onClicked: nadirRadiusSlider.value = 0.2229
        }
        Label {
            text: qsTr('Start')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: nadirCorrectionStartSlider
            minimumValue: 0
            maximumValue: 1
            suffix: ' '
            decimals: 4
            stepSize: 0.0001
            onValueChanged: updateProperty_nadirCorrectionStart()
        }
        Shotcut.KeyframesButton {
            id: nadirCorrectionStartKeyframesButton;
            checked: isKeyframeButtonChecked("nadirCorrectionStart");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "nadirCorrectionStart", nadirCorrectionStartSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: nadirCorrectionStartUndo
            onClicked: radiusSlider.value = 0.8
        }
    }
    Connections {
        target: filter
        onInChanged: updateSimpleKeyframes();
        onOutChanged: updateSimpleKeyframes();
        onAnimateInChanged: updateSimpleKeyframes();
        onAnimateOutChanged: updateSimpleKeyframes();
        onChanged: setControls();
    }
    
    Connections {
        target: producer;
        onPositionChanged: setControls();
    }
    
}
