/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.flogger.FloggerHelpers;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.stream.Collectors;

@BugPattern(name="FloggerStringConcatenation", summary="Prefer string formatting using printf placeholders (e.g. %s) instead of string concatenation", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerStringConcatenation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log").withParameters(new String[]{"java.lang.String"});

    public Description matchMethodInvocation(MethodInvocationTree tree, final VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (!(argument instanceof BinaryTree)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.constValue((Tree)argument, String.class) != null) {
            return Description.NO_MATCH;
        }
        final ArrayList pieces = new ArrayList();
        argument.accept(new SimpleTreeVisitor<Void, Void>(){

            @Override
            public Void visitBinary(BinaryTree tree, Void unused) {
                if (tree.getKind().equals((Object)Tree.Kind.PLUS) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)state.getSymtab().stringType, (VisitorState)state)) {
                    tree.getLeftOperand().accept(this, null);
                    return tree.getRightOperand().accept(this, null);
                }
                return this.defaultAction((Tree)tree, null);
            }

            @Override
            public Void visitParenthesized(ParenthesizedTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }

            @Override
            protected Void defaultAction(Tree tree, Void unused) {
                pieces.add(tree);
                return null;
            }
        }, null);
        StringBuilder formatString = new StringBuilder();
        ArrayList<Tree> formatArguments = new ArrayList<Tree>();
        for (Tree piece : pieces) {
            if (piece.getKind().equals((Object)Tree.Kind.STRING_LITERAL)) {
                formatString.append((String)((LiteralTree)piece).getValue());
                continue;
            }
            formatString.append('%').append(FloggerHelpers.inferFormatSpecifier(piece, state));
            formatArguments.add(piece);
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)argument, (String)(state.getConstantExpression((Object)formatString.toString()) + ", " + formatArguments.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ")))));
    }
}

