/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="LockOnBoxedPrimitive", summary="It is dangerous to use a boxed primitive as a lock as it can unintentionally lead to sharing a lock with another piece of code.", severity=BugPattern.SeverityLevel.WARNING)
public class LockOnBoxedPrimitive
extends BugChecker
implements BugChecker.SynchronizedTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOCKING_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("wait").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.LONG_TYPE)), Matchers.instanceMethod().anyClass().named("wait").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.LONG_TYPE, (Object)Suppliers.INT_TYPE)), Matchers.instanceMethod().anyClass().namedAnyOf(new String[]{"wait", "notify", "notifyAll"}).withNoParameters()});
    private static final Matcher<ExpressionTree> BOXED_PRIMITIVE = Matchers.isBoxedPrimitiveType();

    public Description matchSynchronized(SynchronizedTree tree, VisitorState state) {
        ExpressionTree locked = ASTHelpers.stripParentheses((ExpressionTree)tree.getExpression());
        if (!LockOnBoxedPrimitive.isDefinitelyBoxedPrimitive(locked, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)this.createFix(locked, state));
    }

    private SuggestedFix createFix(ExpressionTree locked, final VisitorState state) {
        final Symbol lock = ASTHelpers.getSymbol((Tree)locked);
        if (lock == null) {
            return SuggestedFix.emptyFix();
        }
        if (!lock.getKind().equals((Object)ElementKind.FIELD)) {
            return SuggestedFix.emptyFix();
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final String lockName = lock.getSimpleName() + "Lock";
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)node);
                if (lock.equals(sym)) {
                    String unboxedType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)state.getTypes().unboxedType(ASTHelpers.getType((Tree)node)));
                    fix.prefixWith((Tree)node, String.format("private final Object %s = new Object();\n@GuardedBy(\"%s\")", lockName, lockName)).replace(node.getType(), unboxedType).addImport("com.google.errorprone.annotations.concurrent.GuardedBy");
                }
                return (Void)super.visitVariable(node, null);
            }

            @Override
            public Void visitSynchronized(SynchronizedTree node, Void aVoid) {
                ExpressionTree expression = ASTHelpers.stripParentheses((ExpressionTree)node.getExpression());
                if (lock.equals(ASTHelpers.getSymbol((Tree)expression))) {
                    fix.replace((Tree)expression, lockName);
                }
                return (Void)super.visitSynchronized(node, aVoid);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (LOCKING_METHOD.matches((Tree)tree, state) && LockOnBoxedPrimitive.isDefinitelyBoxedPrimitive(ASTHelpers.getReceiver((ExpressionTree)tree), state)) {
            return this.describeMatch(tree.getMethodSelect());
        }
        return Description.NO_MATCH;
    }

    private static boolean isDefinitelyBoxedPrimitive(ExpressionTree tree, VisitorState state) {
        return BOXED_PRIMITIVE.matches((Tree)tree, state);
    }
}

